/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.share;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.userserver.share.UserInShare;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.admin.verifier.NonEmptyJComboBoxVerifier;
import com.luna.insight.admin.verifier.NonEmptyJTextComponentVerifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserServerShareEditComponent
extends EditComponent
implements ListSelectionListener {
    private UserServerShare userShare;
    private JLabel shareNameLabel;
    private JTextField shareNameField;
    private JLabel shareOwnerLabel;
    private JComboBox shareOwnerComboBox;
    private JLabel shareUsersLabel;
    private JList shareUsersList;
    Action addUserAction;
    Action editUserAction;
    Action removeUserAction;
    private Map usersRemoved = new HashMap();

    public UserServerShareEditComponent(UserServerShare userServerShare) {
        this.initComponents();
        this.userShare = userServerShare;
    }

    public UserServerShare getUserServerShare() {
        return this.userShare;
    }

    private void initComponents() {
        this.shareNameLabel = new JLabel();
        this.shareNameField = new JTextField();
        this.shareOwnerLabel = new JLabel();
        this.shareOwnerComboBox = new JComboBox();
        this.shareUsersLabel = new JLabel();
        this.shareUsersList = new JList(new DefaultListModel());
        this.setLayout(new GridBagLayout());
        this.shareNameLabel.setText("Share Name:");
        this.shareNameLabel.setPreferredSize(new Dimension(100, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.shareNameLabel, gridBagConstraints);
        this.shareNameField.setPreferredSize(new Dimension(224, 22));
        this.shareNameField.setInputVerifier(new NonEmptyJTextComponentVerifier());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.shareNameField, gridBagConstraints);
        this.shareOwnerLabel.setText("Share Owner:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.shareOwnerLabel, gridBagConstraints);
        this.shareOwnerComboBox.setInputVerifier(new NonEmptyJComboBoxVerifier());
        this.shareOwnerComboBox.setPreferredSize(new Dimension(224, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.shareOwnerComboBox, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(3, 3, 0, 3);
        this.add((Component)jPanel, gridBagConstraints2);
        JLabel jLabel = new JLabel("User Name");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6));
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Write");
        jPanel.add(jLabel2);
        JLabel jLabel3 = new JLabel("Delete");
        jLabel3.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        JLabel jLabel4 = new JLabel("Create Folders");
        jLabel4.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        jPanel.add((Component)jLabel4, gridBagConstraints2);
        JScrollPane jScrollPane = new JScrollPane(this.shareUsersList);
        this.shareUsersList.addListSelectionListener(this);
        this.shareUsersList.setCellRenderer(new ShareUsersCellRenderer());
        this.shareUsersList.setPrototypeCellValue(new UserInShare(0, "xxxxxxxxxxxxxxxxxxxxx", false, false, false));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.insets = new Insets(0, 3, 3, 3);
        this.add((Component)jScrollPane, gridBagConstraints2);
        this.addUserAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddUserDialog addUserDialog = new AddUserDialog();
                addUserDialog.pack();
                addUserDialog.setResizable(false);
                addUserDialog.show();
            }
        };
        this.addUserAction.setEnabled(true);
        this.addUserAction.putValue("Name", "Add User...");
        this.addUserAction.putValue("ShortDescription", "Add a user to this share");
        this.removeUserAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object[] objectArray = UserServerShareEditComponent.this.shareUsersList.getSelectedValues();
                if (objectArray.length > 1 && JOptionPane.showConfirmDialog(null, "Remove these users from the share?", "Confirm Remove Users", 0) == 1) {
                    return;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    UserInShare userInShare = (UserInShare)objectArray[i];
                    ((DefaultListModel)UserServerShareEditComponent.this.shareUsersList.getModel()).removeElement(userInShare);
                    UserServerShareEditComponent.this.usersRemoved.put(new Integer(userInShare.userID), userInShare);
                }
                if (((DefaultListModel)UserServerShareEditComponent.this.shareUsersList.getModel()).size() > 0) {
                    UserServerShareEditComponent.this.editUserAction.setEnabled(true);
                } else {
                    UserServerShareEditComponent.this.editUserAction.setEnabled(false);
                }
            }
        };
        this.removeUserAction.setEnabled(false);
        this.removeUserAction.putValue("Name", "Remove User");
        this.removeUserAction.putValue("ShortDescription", "Remove the selected user from this share");
        this.editUserAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditUserDialog editUserDialog = new EditUserDialog();
                editUserDialog.pack();
                editUserDialog.setResizable(false);
                editUserDialog.show();
            }
        };
        this.editUserAction.setEnabled(false);
        this.editUserAction.putValue("Name", "Set User Privileges...");
        this.editUserAction.putValue("ShortDescription", "Modify the selected user's rights in this share");
        JButton jButton = new JButton(this.addUserAction);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jButton, gridBagConstraints3);
        JButton jButton2 = new JButton(this.editUserAction);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jButton2, gridBagConstraints3);
        JButton jButton3 = new JButton(this.removeUserAction);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 2;
        gridBagConstraints3.gridy = 4;
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.insets = new Insets(3, 3, 3, 3);
        this.add((Component)jButton3, gridBagConstraints3);
    }

    public JTextField getShareNameField() {
        return this.shareNameField;
    }

    public JComboBox getShareOwnerComboBox() {
        return this.shareOwnerComboBox;
    }

    public JList getShareUsersList() {
        return this.shareUsersList;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.shareUsersList && !listSelectionEvent.getValueIsAdjusting()) {
            int[] nArray = this.shareUsersList.getSelectedIndices();
            if (nArray.length == 0) {
                this.removeUserAction.setEnabled(false);
                this.editUserAction.setEnabled(false);
            } else {
                this.removeUserAction.setEnabled(true);
                this.editUserAction.setEnabled(true);
            }
        }
    }

    private class AddUserDialog
    extends JDialog
    implements ListSelectionListener {
        private JLabel usersLabel;
        private JList usersList;
        Action addUsers;
        Action cancel;

        public AddUserDialog() {
            super(((UserServerShareEditComponent)UserServerShareEditComponent.this).userShare.userServer.getInsightAdministrator().getFrame(), "Add Users To Share " + ((UserServerShareEditComponent)UserServerShareEditComponent.this).userShare.shareName, true);
            this.initComponents();
            this.setLocationRelativeTo(UserServerShareEditComponent.this);
        }

        private void initComponents() {
            this.usersLabel = new JLabel();
            this.usersList = new JList(new DefaultListModel());
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            this.usersLabel.setText("Available Users:");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)this.usersLabel, gridBagConstraints);
            JScrollPane jScrollPane = new JScrollPane(this.usersList);
            this.populateUserListModel();
            this.usersList.addListSelectionListener(this);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)jScrollPane, gridBagConstraints);
            this.addUsers = new AbstractAction(this){
                private final /* synthetic */ AddUserDialog this$1;
                {
                    this.this$1 = addUserDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    AddUserDialog.access$700(this.this$1);
                    this.this$1.dispose();
                }
            };
            this.addUsers.setEnabled(false);
            this.addUsers.putValue("Name", "ADD USERS");
            this.addUsers.putValue("ShortDescription", "Add the selected users to this share");
            this.cancel = new AbstractAction(this){
                private final /* synthetic */ AddUserDialog this$1;
                {
                    this.this$1 = addUserDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            };
            this.cancel.setEnabled(true);
            this.cancel.putValue("Name", "CANCEL");
            this.cancel.putValue("ShortDescription", "Cancel without adding users");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)jPanel2, gridBagConstraints);
            JButton jButton = new JButton(this.addUsers);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            jPanel2.add((Component)jButton, gridBagConstraints2);
            JButton jButton2 = new JButton(this.cancel);
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            jPanel2.add((Component)jButton2, gridBagConstraints2);
        }

        private void populateUserListModel() {
            Iterator iterator;
            Object[] objectArray = ((DefaultListModel)UserServerShareEditComponent.this.shareUsersList.getModel()).toArray();
            Vector vector = ((UserServerShareEditComponent)UserServerShareEditComponent.this).userShare.userServer.getUsers();
            HashMap hashMap = new HashMap();
            for (int i = 0; i < objectArray.length; ++i) {
                iterator = (UserInShare)objectArray[i];
                hashMap.put(new Integer(((UserInShare)((Object)iterator)).userID), iterator);
            }
            ArrayList<UserServerUser> arrayList = new ArrayList<UserServerUser>();
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                UserServerUser userServerUser = (UserServerUser)iterator.next();
                if (hashMap.containsKey(new Integer(userServerUser.getIndex()))) continue;
                arrayList.add(userServerUser);
            }
            Collections.sort(arrayList);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ((DefaultListModel)this.usersList.getModel()).addElement(iterator.next());
            }
        }

        private void addSelectedUsers() {
            Object object;
            DefaultListModel defaultListModel;
            Object object2;
            Object[] objectArray = this.usersList.getSelectedValues();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                object2 = (UserServerUser)objectArray[i];
                defaultListModel = new UserInShare(((UserServerUser)object2).getIndex(), ((UserServerUser)object2).getName(), false, false, false);
                object = UserServerShareEditComponent.this.usersRemoved.remove(new Integer(((UserInShare)((Object)defaultListModel)).userID));
                if (object != null) {
                    arrayList.add(object);
                    continue;
                }
                arrayList.add(defaultListModel);
            }
            if (arrayList.size() > 0) {
                Object[] objectArray2 = ((DefaultListModel)UserServerShareEditComponent.this.shareUsersList.getModel()).toArray();
                object2 = new Vector<Object>(Arrays.asList(objectArray2));
                defaultListModel = arrayList.iterator();
                while (defaultListModel.hasNext()) {
                    ((Vector)object2).add(defaultListModel.next());
                }
                Collections.sort(object2);
                defaultListModel = new DefaultListModel();
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    defaultListModel.addElement(object.next());
                    UserServerShareEditComponent.this.shareUsersList.setModel(defaultListModel);
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this.usersList && !listSelectionEvent.getValueIsAdjusting()) {
                if (this.usersList.getSelectedIndex() != -1) {
                    this.addUsers.setEnabled(true);
                } else {
                    this.addUsers.setEnabled(false);
                }
            }
        }

        static /* synthetic */ void access$700(AddUserDialog addUserDialog) {
            addUserDialog.addSelectedUsers();
        }
    }

    private class EditUserDialog
    extends JDialog {
        private JLabel label;
        private JCheckBox writePrivCheckBox;
        private JCheckBox deletePrivCheckBox;
        private JCheckBox createPrivCheckBox;
        private Action applyAction;
        private Action cancelAction;

        public EditUserDialog() {
            super(((UserServerShareEditComponent)UserServerShareEditComponent.this).userShare.userServer.getInsightAdministrator().getFrame(), "Set Share Rights - " + ((UserServerShareEditComponent)UserServerShareEditComponent.this).userShare.shareName, true);
            this.initComponents();
            this.setLocationRelativeTo(UserServerShareEditComponent.this);
        }

        private void initComponents() {
            UserInShare userInShare = UserServerShareEditComponent.this.shareUsersList.getSelectedIndices().length == 1 ? (UserInShare)((DefaultListModel)UserServerShareEditComponent.this.shareUsersList.getModel()).get(UserServerShareEditComponent.this.shareUsersList.getSelectedIndices()[0]) : null;
            this.label = new JLabel();
            this.label.setText("Set share rights for selected users:");
            this.writePrivCheckBox = new JCheckBox();
            this.deletePrivCheckBox = new JCheckBox();
            this.createPrivCheckBox = new JCheckBox();
            if (userInShare != null) {
                this.writePrivCheckBox.setSelected(userInShare.writePriv);
                this.deletePrivCheckBox.setSelected(userInShare.deletePriv);
                this.createPrivCheckBox.setSelected(userInShare.createPriv);
            }
            this.getContentPane().setLayout(new GridBagLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)this.label, gridBagConstraints);
            this.writePrivCheckBox.setText("Write");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)this.writePrivCheckBox, gridBagConstraints);
            this.deletePrivCheckBox.setText("Delete");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)this.deletePrivCheckBox, gridBagConstraints);
            this.createPrivCheckBox.setText("Create Folders");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)this.createPrivCheckBox, gridBagConstraints);
            this.applyAction = new AbstractAction(this){
                private final /* synthetic */ EditUserDialog this$1;
                {
                    this.this$1 = editUserDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = UserServerShareEditComponent.access$000(EditUserDialog.access$300(this.this$1)).getSelectedIndices();
                    for (int i = 0; i < nArray.length; ++i) {
                        UserInShare userInShare = (UserInShare)((DefaultListModel)UserServerShareEditComponent.access$000(EditUserDialog.access$300(this.this$1)).getModel()).get(nArray[i]);
                        userInShare.setWritePriv(EditUserDialog.access$400(this.this$1).isSelected());
                        userInShare.setDeletePriv(EditUserDialog.access$500(this.this$1).isSelected());
                        userInShare.setCreatePriv(EditUserDialog.access$600(this.this$1).isSelected());
                        ((DefaultListModel)UserServerShareEditComponent.access$000(EditUserDialog.access$300(this.this$1)).getModel()).set(nArray[i], userInShare);
                    }
                    this.this$1.dispose();
                }
            };
            this.applyAction.setEnabled(true);
            this.applyAction.putValue("Name", "Apply");
            this.applyAction.putValue("ShortDescription", "Apply these privileges to the selected users");
            this.cancelAction = new AbstractAction(this){
                private final /* synthetic */ EditUserDialog this$1;
                {
                    this.this$1 = editUserDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.dispose();
                }
            };
            this.cancelAction.setEnabled(true);
            this.cancelAction.putValue("Name", "Cancel");
            this.cancelAction.putValue("ShortDescription", "Cancel without applying changes");
            JButton jButton = new JButton(this.applyAction);
            JButton jButton2 = new JButton(this.cancelAction);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)jButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            jPanel.add((Component)jButton2, gridBagConstraints);
        }

        static /* synthetic */ UserServerShareEditComponent access$300(EditUserDialog editUserDialog) {
            return editUserDialog.UserServerShareEditComponent.this;
        }

        static /* synthetic */ JCheckBox access$400(EditUserDialog editUserDialog) {
            return editUserDialog.writePrivCheckBox;
        }

        static /* synthetic */ JCheckBox access$500(EditUserDialog editUserDialog) {
            return editUserDialog.deletePrivCheckBox;
        }

        static /* synthetic */ JCheckBox access$600(EditUserDialog editUserDialog) {
            return editUserDialog.createPrivCheckBox;
        }
    }

    private class ShareUsersCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel userLabel = new JLabel();
        JLabel writeLabel = new JLabel();
        JLabel deleteLabel = new JLabel();
        JLabel createLabel = new JLabel();

        public ShareUsersCellRenderer() {
            this.setLayout(new GridLayout(1, 4));
            this.userLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 6));
            this.deleteLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
            this.createLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 3));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setOpaque(true);
            UserInShare userInShare = (UserInShare)object;
            String string = userInShare.loginName;
            if (string.length() >= 20) {
                string = string.substring(0, 19) + "...";
            }
            this.userLabel.setText(string);
            this.add(this.userLabel);
            if (userInShare.writePriv) {
                this.writeLabel.setText("x");
            } else {
                this.writeLabel.setText("");
            }
            this.add(this.writeLabel);
            if (userInShare.deletePriv) {
                this.deleteLabel.setText("x");
            } else {
                this.deleteLabel.setText("");
            }
            this.add(this.deleteLabel);
            if (userInShare.createPriv) {
                this.createLabel.setText("x");
            } else {
                this.createLabel.setText("");
            }
            this.add(this.createLabel);
            return this;
        }
    }
}

