/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.share;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.share.UserInShare;
import com.luna.insight.admin.userserver.share.UserServerShareEditComponent;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;

public class UserServerShare
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int shareID;
    protected UserServer userServer;
    protected int ownerID = -1;
    protected String shareName = "";
    protected String legacyCodeKey = null;
    protected String createdTimestamp = "";
    protected String modifiedTimestamp = "";
    protected Set users = new HashSet();
    protected UserServerShareEditComponent editComponent;

    public UserServerShare(UserServer userServer, int n, int n2, String string, String string2, String string3, String string4) {
        this.userServer = userServer;
        this.shareID = n;
        this.ownerID = n2;
        this.shareName = string;
        this.legacyCodeKey = string2 == null ? "" : string2;
        String string5 = new SimpleDate().get();
        this.createdTimestamp = string3 == null ? string5 : string3;
        this.modifiedTimestamp = string4 == null ? string5 : string4;
    }

    public UserServerShare(UserServer userServer, int n) {
        String string;
        this.userServer = userServer;
        this.shareID = n;
        this.createdTimestamp = string = new SimpleDate().get();
        this.modifiedTimestamp = string;
    }

    public String getName() {
        return this.shareName;
    }

    public String getCodeKey() {
        return this.legacyCodeKey;
    }

    public void addUserInShare(UserInShare userInShare) {
        this.users.add(userInShare);
    }

    public EditComponent getEditComponent() {
        Object object;
        this.editComponent = new UserServerShareEditComponent(this);
        this.editComponent.getShareNameField().setText(this.shareName);
        Vector vector = this.userServer.getUsers();
        Collections.sort(vector);
        UserServerUser userServerUser = null;
        Object object2 = vector.iterator();
        while (object2.hasNext()) {
            object = (UserServerUser)object2.next();
            this.editComponent.getShareOwnerComboBox().addItem(object);
            if (((UserServerUser)object).getIndex() != this.ownerID) continue;
            userServerUser = object;
        }
        if (userServerUser != null) {
            this.editComponent.getShareOwnerComboBox().setSelectedItem(userServerUser);
        } else {
            this.editComponent.getShareOwnerComboBox().setSelectedIndex(0);
        }
        object2 = new Vector(this.users);
        Collections.sort(object2);
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            UserInShare userInShare = (UserInShare)object.next();
            UserInShare userInShare2 = new UserInShare(userInShare.userID, userInShare.loginName, userInShare.writePriv, userInShare.deletePriv, userInShare.createPriv);
            ((DefaultListModel)this.editComponent.getShareUsersList().getModel()).addElement(userInShare2);
        }
        return this.editComponent;
    }

    public void save() {
        UserServerUser userServerUser;
        UserServerShare.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.shareName, this.editComponent.getShareNameField().getText())) {
            this.shareName = this.editComponent.getShareNameField().getText();
        }
        if (this.hasChanged(this.ownerID, (userServerUser = (UserServerUser)this.editComponent.getShareOwnerComboBox().getSelectedItem()).getIndex())) {
            this.ownerID = userServerUser.getIndex();
        }
        List<Object> list = Arrays.asList(((DefaultListModel)this.editComponent.getShareUsersList().getModel()).toArray());
        ArrayList arrayList = new ArrayList(this.users);
        if (this.requiresCommit || !this.shareUsersAreEqual(list)) {
            this.users = new HashSet<Object>(list);
            this.requiresCommit = true;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.modifiedTimestamp = new SimpleDate().get();
            this.userServer.commitDataObject(this);
        } else {
            this.userServer.cancelEdit(this);
        }
    }

    public void cancel() {
        UserServerShare.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.userServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit User Share - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-user-groups-node-icon.gif");
    }

    public int getIndex() {
        return this.shareID;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        UserServerShare userServerShare = (UserServerShare)databaseRecord;
        if (!(this.shareName.equals(userServerShare.shareName) && this.shareID == userServerShare.shareID && this.ownerID == userServerShare.ownerID && UserServerShare.stringsAreEqual(this.createdTimestamp, userServerShare.createdTimestamp) && UserServerShare.stringsAreEqual(this.modifiedTimestamp, userServerShare.modifiedTimestamp) && UserServerShare.stringsAreEqual(this.legacyCodeKey, userServerShare.legacyCodeKey))) {
            return false;
        }
        return this.shareUsersAreEqual(new ArrayList(userServerShare.users));
    }

    private boolean shareUsersAreEqual(List list) {
        if (this.users.size() != list.size()) {
            return false;
        }
        ArrayList arrayList = new ArrayList(this.users);
        Collections.sort(arrayList);
        Collections.sort(list);
        for (int i = 0; i < arrayList.size(); ++i) {
            UserInShare userInShare;
            UserInShare userInShare2 = (UserInShare)arrayList.get(i);
            if (!userInShare2.equals(userInShare = (UserInShare)list.get(i))) {
                return false;
            }
            if (userInShare2.isCreatePriv() == userInShare.isCreatePriv() && userInShare2.isWritePriv() == userInShare.isWritePriv() && userInShare2.isDeletePriv() == userInShare.isDeletePriv()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.shareName;
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public static void debugOut(String string) {
        UserServerShare.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerShare: " + string, n);
    }
}

