/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver.collection;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.collection.UserServerCollection;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class UserServerCollectionsNode
extends TableDisplayControlPanelNode {
    protected UserServerNode userServerNode = null;

    public UserServerCollectionsNode(UserServerNode userServerNode) {
        super(userServerNode.getUserServer().getInsightAdministrator(), "Collections", false);
        this.userServerNode = userServerNode;
        this.columnNames = new Object[]{"Collection Name", "CollectionID", "Browser Unique CID", "InstitutionID", "Address", "Port", "Locale", "Virtual", "Inscribe Enabled", "Type"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.userServerNode.getUserServer().getCollections(true)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            String string = "";
            UserServerCollection userServerCollection = (UserServerCollection)vector.elementAt(i);
            switch (userServerCollection.recordType) {
                case 0: {
                    string = "Collection";
                    break;
                }
                case 2: {
                    string = "Server";
                    break;
                }
                case 1: {
                    string = "Personal Collection Server";
                }
            }
            objectArray[i][0] = userServerCollection;
            objectArray[i][1] = userServerCollection.collectionID;
            objectArray[i][2] = userServerCollection.collectionUniqueID;
            objectArray[i][3] = userServerCollection.institutionID;
            objectArray[i][4] = userServerCollection.address;
            objectArray[i][5] = "" + userServerCollection.port;
            objectArray[i][6] = userServerCollection.locale;
            objectArray[i][7] = new Boolean(userServerCollection.virtual);
            objectArray[i][8] = new Boolean(userServerCollection.medeEnabled);
            objectArray[i][9] = string;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.userServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Collection Command", this.userServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.userServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/user-server-collections-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.userServerNode.getAdminAccount(), "New Collection Command", "Edit Collection Command", "Delete Collection Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Collection Command")) {
            this.userServerNode.createNewCollection();
        } else if (string.equals("Delete Collection Command")) {
            if (vector != null && vector.size() > 0) {
                this.userServerNode.removeCollections(vector);
            }
        } else if (string.equals("Edit Collection Command") && vector != null && vector.size() == 1) {
            this.userServerNode.editCollection((UserServerCollection)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.userServerNode.editCollection((UserServerCollection)object);
        }
    }

    public static void debugOut(String string) {
        UserServerCollectionsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerCollectionsNode: " + string, n);
    }
}

