/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdminAccountsNode;
import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.userserver.ImageGroupFileDataObject;
import com.luna.insight.admin.userserver.UsImageGroupFilePath;
import com.luna.insight.admin.userserver.UsImageGroupFilesNode;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.UserServerConnectEditComponent;
import com.luna.insight.admin.userserver.collection.UserServerCollection;
import com.luna.insight.admin.userserver.collection.UserServerCollectionsNode;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.share.UserServerSharesNode;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroup;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroupsNode;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfile;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfilesNode;
import com.luna.insight.admin.userserver.usergroup.UserServerUsersNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageGroupFile;
import java.awt.event.ActionEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;

public class UserServerNode
extends AdministeredServerNode {
    public static final String COMMAND_NEW_COLLECTION = "New Collection Command";
    public static final String COMMAND_DELETE_COLLECTION = "Delete Collection Command";
    public static final String COMMAND_EDIT_COLLECTION = "Edit Collection Command";
    public static final String COMMAND_NEW_USER = "New User Command";
    public static final String COMMAND_DELETE_USER = "Delete User Command";
    public static final String COMMAND_EDIT_USER = "Edit User Command";
    public static final String COMMAND_NEW_USER_GROUP = "New User Group Command";
    public static final String COMMAND_DELETE_USER_GROUP = "Delete User Group Command";
    public static final String COMMAND_EDIT_USER_GROUP = "Edit User Group Command";
    public static final String COMMAND_NEW_USER_SHARE = "New User Share Command";
    public static final String COMMAND_DELETE_USER_SHARE = "Delete User Share Command";
    public static final String COMMAND_EDIT_USER_SHARE = "Edit User Share Command";
    public static final String COMMAND_NEW_USER_PROFILE = "New User Profile Command";
    public static final String COMMAND_DELETE_USER_PROFILE = "Delete User Profile Command";
    public static final String COMMAND_EDIT_USER_PROFILE = "Edit User Profile Command";
    public static final String COMMAND_VIEW_RENAME_IGF = "view-rename-image-group-file";
    public static final String COMMAND_DELETE_IGF = "delete-image-group-file";
    public static final String COMMAND_EDIT_IMAGE_GROUP_FILE_PATH = "Edit Image Group File Path";
    public static final String STORE_USER_SERVER_IMAGE_GROUP_FILE_PATH = "US_IMAGE_GROUP_FILE_PATH";
    protected UserServer userServer = null;
    protected UserServerCollectionsNode collectionsNode = null;
    protected UserServerUsersNode usersNode = null;
    protected UserServerUserGroupsNode groupsNode = null;
    protected UserServerSharesNode sharesNode = null;
    protected UserServerUserProfilesNode profilesNode = null;
    protected UsImageGroupFilesNode imageGroupFilesNode = null;

    public UserServerNode(UserServer userServer) {
        super(userServer);
        this.userServer = userServer;
        userServer.setNode(this);
    }

    protected void createInformationModel() {
        this.labelText = "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Remove Command")) {
            UserServerNode.debugOut("Remove UserServer.");
            if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete this UserServer registration?", "Delete Confirmation")) {
                if (this.userServer.disconnect()) {
                    TreeNode treeNode = this.getParent();
                    this.removeFromParent();
                    this.insightAdministrator.reloadTreeModel(treeNode);
                    this.insightAdministrator.removeUserServerFromStore(this.userServer.getName());
                } else {
                    UserServerNode.debugOut("Couldn't disconnect UserServer.");
                }
            }
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_COLLECTION)) {
            UserServerNode.debugOut("Add a new collection.");
            this.createNewCollection();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_USER)) {
            UserServerNode.debugOut("Add a new user.");
            this.createNewUser();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_USER_GROUP)) {
            UserServerNode.debugOut("Add a new user group.");
            this.createNewUserGroup();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_USER_SHARE)) {
            UserServerNode.debugOut("Add a new user share.");
            this.createNewUserShare();
        } else if (actionEvent.getActionCommand().equals(COMMAND_NEW_USER_PROFILE)) {
            UserServerNode.debugOut("Add a new user profile.");
            this.createNewUserProfile();
        } else if (actionEvent.getActionCommand().equals(COMMAND_EDIT_IMAGE_GROUP_FILE_PATH)) {
            UserServerNode.debugOut("Edit image group file path.");
            this.editImageGroupFilePath();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void connect() {
        UserServerNode.debugOut("Connect UserServer.");
        EditableDataObject editableDataObject = new EditableDataObject(){
            private UserServerConnectEditComponent usce = null;

            public EditComponent getEditComponent() {
                this.usce = new UserServerConnectEditComponent();
                boolean bl = UserServerNode.this.userServer.isPasswordRemembered();
                String string = UserServerNode.this.userServer.getAccountUsername();
                String string2 = "";
                if (bl) {
                    string2 = UserServerNode.this.userServer.getAccountPassword();
                }
                this.usce.getUsernameField().setText(string);
                this.usce.getPasswordField().setText(string2);
                this.usce.getRememberCheckBox().setSelected(bl);
                this.usce.getUsernameField().selectAll();
                return this.usce;
            }

            public void save() {
                UserServerNode.this.doConnect(this.usce.getUsernameField().getText(), new String(this.usce.getPasswordField().getPassword()), this.usce.getRememberCheckBox().isSelected());
            }

            public void cancel() {
            }

            public String getSaveButtonText() {
                return "Login";
            }

            public String getEditWindowTitle() {
                return "Login";
            }

            public ImageIcon getEditWindowIcon() {
                return IconMaker.createImage("images/user-server-node-icon.gif");
            }
        };
        new EditDialog(this.insightAdministrator.getFrame(), true, editableDataObject).show();
    }

    public void doConnect(String string, String string2, boolean bl) {
        if (this.userServer.isConnected()) {
            this.insightAdministrator.showWarningDialog("Already connected.  Disconnect first, and then try connecting again.", "Already Connected");
            return;
        }
        this.username = string;
        this.password = string2;
        this.userServer.setPasswordRemembered(bl);
        if (this.userServer.connect(string, string2)) {
            if (this.adminAccountsNode == null) {
                this.adminAccountsNode = new AdminAccountsNode(this);
            }
            this.add(this.adminAccountsNode);
            if (this.usersNode == null) {
                this.usersNode = new UserServerUsersNode(this);
            }
            this.add(this.usersNode);
            if (this.groupsNode == null) {
                this.groupsNode = new UserServerUserGroupsNode(this);
            }
            this.add(this.groupsNode);
            if (this.sharesNode == null) {
                this.sharesNode = new UserServerSharesNode(this);
            }
            this.add(this.sharesNode);
            if (this.collectionsNode == null) {
                this.collectionsNode = new UserServerCollectionsNode(this);
            }
            this.add(this.collectionsNode);
            if (this.imageGroupFilesNode == null) {
                this.imageGroupFilesNode = new UsImageGroupFilesNode(this);
            }
            this.add(this.imageGroupFilesNode);
            this.expandNode();
        }
        this.refreshData();
    }

    public void disconnect() {
        UserServerNode.debugOut("Disconnect UserServer.");
        this.userServer.disconnect();
        this.removeAllChildren();
        this.refreshData();
    }

    public void edit() {
        UserServerNode.debugOut("Edit UserServer.");
        this.userServer.edit();
    }

    public void refreshData() {
        if (!this.userServer.getAccountUsername().equals("") && this.userServer.isConnected()) {
            this.setText(this.userServer.getName() + " (" + this.userServer.getAccountUsername() + ")");
        } else {
            this.setText(this.userServer.getName());
        }
        this.userServer.getInsightAdministrator().reloadTreeModel(this);
    }

    public UserServer getUserServer() {
        return this.userServer;
    }

    public AdminAccount getAdminAccount() {
        return this.userServer.getAdminAccount();
    }

    public JComponent getDisplayComponent() {
        if (this.labelText == null) {
            this.createInformationModel();
        }
        return new JLabel(this.labelText);
    }

    public ImageIcon getIcon() {
        if (this.userServer.isConnected()) {
            if (this.treeIcon == null) {
                this.treeIcon = IconMaker.createImage("images/user-server-node-icon.gif");
            }
            return this.treeIcon;
        }
        if (this.disconnectedIcon == null) {
            this.disconnectedIcon = IconMaker.createImage("images/disconnected-user-server-node-icon.gif");
        }
        return this.disconnectedIcon;
    }

    public void createNewCollection() {
        this.userServer.addDataObject(new UserServerCollection(this.userServer.getUserServerConnector().getNextValidCollectionID(), this.userServer));
    }

    public void removeCollections(Vector vector) {
        UserServerNode.debugOut("Removing collections: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected collections?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.userServer.removeDataObject((UserServerCollection)vector.elementAt(i));
            }
            this.collectionsNode.updateInformationDisplay();
        }
    }

    public void editCollection(UserServerCollection userServerCollection) {
        UserServerNode.debugOut("Editing collection: " + userServerCollection);
        this.userServer.editDataObject(userServerCollection);
    }

    public void createNewUser() {
        this.userServer.addDataObject(new UserServerUser(this.userServer.getUserServerConnector().getNextValidUserID(), this.userServer));
    }

    public void removeUsers(Vector vector) {
        UserServerNode.debugOut("Removing users: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected users?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.userServer.removeDataObject((UserServerUser)vector.elementAt(i));
            }
            this.usersNode.updateInformationDisplay();
        }
    }

    public void editUser(UserServerUser userServerUser) {
        UserServerNode.debugOut("Editing user: " + userServerUser);
        this.userServer.editDataObject(userServerUser);
    }

    public void createNewUserGroup() {
        this.userServer.addDataObject(new UserServerUserGroup(this.userServer.getUserServerConnector().getNextValidUserGroupID(), this.userServer));
    }

    public void removeUserGroups(Vector vector) {
        UserServerNode.debugOut("Removing groups: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected groups?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.userServer.removeDataObject((UserServerUserGroup)vector.elementAt(i));
            }
            this.groupsNode.updateInformationDisplay();
        }
    }

    public void editUserGroup(UserServerUserGroup userServerUserGroup) {
        UserServerNode.debugOut("Editing user group: " + userServerUserGroup);
        this.userServer.editDataObject(userServerUserGroup);
    }

    public void createNewUserProfile() {
    }

    public void removeUserProfiles(Vector vector) {
        UserServerNode.debugOut("Removing profiles: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected profiles?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.userServer.removeDataObject((UserServerUserProfile)vector.elementAt(i));
            }
            this.profilesNode.updateInformationDisplay();
        }
    }

    public void editUserProfile(UserServerUserProfile userServerUserProfile) {
        UserServerNode.debugOut("Editing user profile: " + userServerUserProfile);
        this.userServer.editDataObject(userServerUserProfile);
    }

    public List getImageGroupFileList(String string, String string2) {
        if (this.userServer.doesImageGroupFilePathExist()) {
            return this.userServer.getImageGroupFileList(string, string2);
        }
        this.insightAdministrator.showWarningDialog("Image group file path (" + this.userServer.getImageGroupFilePath() + ") is not valid.\nRight-click on \"Image Group Files\" to set the path.", "Specify Image Group File Path");
        return new Vector(0);
    }

    public ImageGroupFile getImageGroupFile(String string, String string2, String string3) {
        if (this.userServer.doesImageGroupFilePathExist()) {
            return this.userServer.getImageGroupFile(string, string2, string3);
        }
        this.insightAdministrator.showWarningDialog("Image group file path (" + this.userServer.getImageGroupFilePath() + ") is not valid.\nRight-click on \"Image Group Files\" to set the path.", "Specify Image Group File Path");
        return null;
    }

    public void editImageGroupFile(ImageGroupFileDataObject imageGroupFileDataObject) {
        UserServerNode.debugOut("Editing image group file: " + imageGroupFileDataObject);
        this.userServer.editDataObject(imageGroupFileDataObject);
    }

    public void deleteImageGroupFiles(String string, String string2, Vector vector) {
        UserServerNode.debugOut("Deleting image group files: " + vector);
        if (vector != null && vector.size() > 0 && this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected image group file" + (vector.size() == 1 ? "" : "s") + "?", "Delete Confirmation")) {
            for (int i = 0; vector != null && i < vector.size(); ++i) {
                ImageGroupFileDataObject imageGroupFileDataObject = (ImageGroupFileDataObject)vector.get(i);
                if (this.userServer.deleteImageGroupFile(string, string2, imageGroupFileDataObject.getImageGroupFile())) continue;
                this.insightAdministrator.showWarningDialog("Unable to delete image group file " + imageGroupFileDataObject.getName(), "Deletion Error");
            }
        }
    }

    public void editImageGroupFilePath() {
        UserServerNode.debugOut("Editing image group file path: ");
        this.userServer.editDataObject(new UsImageGroupFilePath(this));
    }

    protected Properties loadProperties(String string) {
        String string2 = string;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            UserServerNode.debugOut("Cannot read configuration file. exc: " + iOException);
        }
        return properties;
    }

    public void createNewUserShare() {
        this.userServer.addDataObject(new UserServerShare(this.userServer, this.userServer.getUserServerConnector().getNextValidShareID()));
    }

    public void removeUserShares(Vector vector) {
        UserServerNode.debugOut("Removing shares: " + vector);
        if (this.insightAdministrator.showYesNoConfirmDialog("Are you sure you want to delete the selected groups?", "Delete Confirmation")) {
            for (int i = 0; i < vector.size(); ++i) {
                this.userServer.removeDataObject((UserServerShare)vector.elementAt(i));
            }
            this.sharesNode.updateInformationDisplay();
        }
    }

    public void editUserShare(UserServerShare userServerShare) {
        UserServerNode.debugOut("Editing user share: " + userServerShare);
        this.userServer.editDataObject(userServerShare);
    }

    public static void debugOut(String string) {
        UserServerNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServerNode: " + string, n);
    }
}

