/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver;

import com.luna.insight.admin.AdministeredServer;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.AdministeredServerEditComponent;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.userserver.ImageGroupFileDataObject;
import com.luna.insight.admin.userserver.UsImageGroupFilePath;
import com.luna.insight.admin.userserver.UserServerConnector;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.admin.userserver.collection.UserServerCollection;
import com.luna.insight.admin.userserver.config.UserServerConfigurationFileProperties;
import com.luna.insight.admin.userserver.share.UserServerShare;
import com.luna.insight.admin.userserver.usergroup.UserServerUser;
import com.luna.insight.admin.userserver.usergroup.UserServerUserGroup;
import com.luna.insight.admin.userserver.usergroup.UserServerUserProfile;
import com.luna.insight.admin.verifier.NonDuplicateJTextComponentVerifier;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageGroupFile;
import com.luna.insight.server.ImageGroupFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class UserServer
extends AdministeredServer {
    public static String USER_CONNECT_STRING_KEY = "UserDatabaseConnect";
    private Vector userGroups = new Vector();
    private Hashtable collectionsTable = new Hashtable();
    private Hashtable usersTable = new Hashtable();
    private Hashtable groupsTable = new Hashtable();
    private Hashtable sharesTable = new Hashtable();
    private Hashtable profilesTable = new Hashtable();
    private Hashtable imageGroupFilesTable = new Hashtable();
    private Hashtable imageGroupFilePathsTable = new Hashtable();
    private ImageGroupFileManager igfManager = new ImageGroupFileManager(null, false);

    public UserServer(String string, InsightAdministrator insightAdministrator) {
        super(string, insightAdministrator);
    }

    public String getConnectStringKey() {
        return USER_CONNECT_STRING_KEY;
    }

    public void setNode(UserServerNode userServerNode) {
        this.parentNode = userServerNode;
    }

    public void edit() {
        if (this.editDialog == null) {
            this.oldName = this.getName();
            this.editDialog = new EditDialog(this.insightAdministrator.getFrame(), true, this);
            this.editDialog.show();
        } else {
            this.insightAdministrator.setSelectedFrame(this.editDialog);
        }
    }

    public void commitEdit() {
        if (this.creationCompleted) {
            this.insightAdministrator.removeUserServerFromStore(this.oldName);
            this.insightAdministrator.registerNewUserServer(this);
            this.parentNode.refreshData();
        }
    }

    public AdministeredServerConnector getServerConnector() {
        return this.getUserServerConnector();
    }

    public void saveToDisk() {
        if (this.creationCompleted) {
            this.insightAdministrator.removeUserServerFromStore(this.getName());
        }
        if (this.creationCompleted) {
            this.insightAdministrator.registerNewUserServer(this);
        }
    }

    public UserServerConnector getUserServerConnector() {
        if (this.serverConnector == null) {
            Properties properties = new Properties();
            properties.setProperty("DefaultUsername", this.databaseUsername);
            properties.setProperty("DefaultPassword", this.databasePassword);
            properties.setProperty("DatabaseConnector", this.databaseConnector);
            properties.setProperty("JDBCDriverName", this.jdbcDriverName);
            properties.setProperty("JDBCUrlPrefix", this.jdbcUrlPrefix);
            properties.setProperty(this.getConnectStringKey(), this.connectString);
            this.serverConnector = new UserServerConnector(this, properties);
        }
        return (UserServerConnector)this.serverConnector;
    }

    public EditComponent getEditComponent() {
        UserServer.debugOut("in getEditComponent");
        this.editComponent = new AdministeredServerEditComponent(this);
        JLabel jLabel = this.editComponent.getNameLabel();
        jLabel.setText("User Manager Name:");
        JTextField jTextField = this.editComponent.getNameField();
        jTextField.setInputVerifier(new NonDuplicateJTextComponentVerifier(InsightAdministrator.getExistingUserServerNames(this.name)));
        this.editComponent.getNameField().setText(this.getName());
        if (this.getConnectString() != null && this.getConnectString().length() > 0) {
            this.editComponent.getConnectStringField().setText(this.getConnectString());
        }
        if (this.databaseUsername != null && this.databaseUsername.length() > 0) {
            this.editComponent.getDatabaseUsernameField().setText(this.databaseUsername);
        }
        if (this.databasePassword != null && this.databasePassword.length() > 0) {
            this.editComponent.getDatabasePasswordField().setText(this.databasePassword);
        }
        if (this.databaseConnector != null && this.databaseConnector.length() > 0) {
            this.editComponent.getDatabaseConnectorComboBox().setSelectedItem(this.databaseConnector);
        }
        if (this.globalEscapeDelimiter != null && this.globalEscapeDelimiter.length() > 0) {
            this.editComponent.getGlobalEscapeDelimiterField().setText(this.globalEscapeDelimiter);
        }
        if (this.unicodeFieldPrefix != null && this.unicodeFieldPrefix.length() > 0) {
            this.editComponent.getUnicodeFieldPrefixField().setText(this.unicodeFieldPrefix);
        }
        if (this.jdbcDriverName != null && this.jdbcDriverName.length() > 0) {
            this.editComponent.getJdbcDriverNameField().setText(this.jdbcDriverName);
        }
        if (this.jdbcUrlPrefix != null && this.jdbcUrlPrefix.length() > 0) {
            this.editComponent.getJdbcUrlPrefixField().setText(this.jdbcUrlPrefix);
        }
        if (this.configFilePath != null && this.configFilePath.length() > 0) {
            this.editComponent.getConfigFileNameField().setText(this.configFilePath);
        }
        this.editComponent.setJdbcFieldsAppropriately();
        this.editComponent.getNameField().selectAll();
        this.editComponent.getConfigFileNameField().setCaretPosition(0);
        return this.editComponent;
    }

    public String getSaveButtonText() {
        if (this.isNew()) {
            return "Save";
        }
        return "Save";
    }

    public boolean isNew() {
        return "".equals(this.getName());
    }

    public String getEditWindowTitle() {
        if (this.isNew()) {
            return "Register New User Manager";
        }
        return "Edit User Manager - " + this.getName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/user-server-node-icon.gif");
    }

    protected Hashtable getEditDialogCache(EditableDataObject editableDataObject) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof UserServerCollection) {
                return this.collectionsTable;
            }
            if (editableDataObject instanceof UserServerUser) {
                return this.usersTable;
            }
            if (editableDataObject instanceof UserServerUserGroup) {
                return this.groupsTable;
            }
            if (editableDataObject instanceof UserServerUserProfile) {
                return this.profilesTable;
            }
            if (editableDataObject instanceof ImageGroupFileDataObject) {
                return this.imageGroupFilesTable;
            }
            if (editableDataObject instanceof UsImageGroupFilePath) {
                return this.imageGroupFilePathsTable;
            }
            if (editableDataObject instanceof UserServerShare) {
                return this.sharesTable;
            }
            return super.getEditDialogCache(editableDataObject);
        }
        return null;
    }

    public void updateParentNode(EditableDataObject editableDataObject) {
        if (editableDataObject != null) {
            if (editableDataObject instanceof UserServerCollection) {
                ((UserServerNode)this.parentNode).collectionsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof UserServerUser) {
                ((UserServerNode)this.parentNode).usersNode.updateInformationDisplay();
            } else if (editableDataObject instanceof UserServerUserGroup) {
                ((UserServerNode)this.parentNode).groupsNode.updateInformationDisplay();
            } else if (editableDataObject instanceof UserServerShare) {
                ((UserServerNode)this.parentNode).sharesNode.updateInformationDisplay();
            } else if (editableDataObject instanceof UserServerUserProfile) {
                ((UserServerNode)this.parentNode).profilesNode.updateInformationDisplay();
            } else if (editableDataObject instanceof ImageGroupFileDataObject) {
                ((ImageGroupFileDataObject)editableDataObject).updateInformationDisplay();
            } else {
                super.updateParentNode(editableDataObject);
            }
        }
    }

    public Vector getCollections(boolean bl) {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getUserServerConnector().getCollectionRecords(bl);
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    private Vector getLocaleFileLanguages(String string, boolean bl) {
        Vector<Locale> vector = null;
        UserServer.debugOut("Trying: " + string, 3);
        try {
            File file = new File(string);
            File[] fileArray = file.listFiles();
            vector = new Vector<Locale>();
            for (int i = 0; i < fileArray.length; ++i) {
                int n;
                String string2;
                Object object;
                Object object2;
                Object object3;
                String string3 = fileArray[i].getName();
                if (bl) {
                    if (!fileArray[i].isDirectory()) continue;
                    String string4 = string3;
                    UserServer.debugOut("filenameBody is: " + string4);
                    object3 = new Vector();
                    object2 = new StringTokenizer(string4, "_");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        ((Vector)object3).addElement(((StringTokenizer)object2).nextToken());
                    }
                    object = "";
                    string2 = "";
                    if (((Vector)object3).size() > 0) {
                        object = (String)((Vector)object3).elementAt(0);
                    }
                    if (((Vector)object3).size() > 1) {
                        string2 = (String)((Vector)object3).elementAt(1);
                    }
                    vector.addElement(new Locale((String)object, string2));
                    continue;
                }
                if (!string3.endsWith("conf") || (n = string3.indexOf(".")) <= 0) continue;
                object3 = string3.substring(0, n);
                UserServer.debugOut("filenameBody is: " + (String)object3);
                object2 = new Vector();
                object = new StringTokenizer((String)object3, "_");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ((Vector)object2).addElement(((StringTokenizer)object).nextToken());
                }
                string2 = "";
                String string5 = "";
                if (((Vector)object2).size() > 1) {
                    string2 = (String)((Vector)object2).elementAt(1);
                }
                if (((Vector)object2).size() > 2) {
                    string5 = (String)((Vector)object2).elementAt(2);
                }
                vector.addElement(new Locale(string2, string5));
            }
        }
        catch (Exception exception) {
            UserServer.debugOut("Exception in getLocaleFileLanguages");
        }
        return vector;
    }

    public Vector getAvailableLocales() {
        Object object;
        Vector vector;
        block11: {
            UserServer.debugOut("in getAvailableLocales()...", 2);
            vector = null;
            try {
                if (this.configFilePath == null || this.configFilePath.equals("")) {
                    vector = this.getUserServerConnector().getCollectionsLanguages();
                } else {
                    object = this.getConfigFilePath();
                    UserServer.debugOut("loadFilePath is: " + (String)object, 3);
                    if (object != null) {
                        File file = new File((String)object);
                        String string = file.getParent();
                        UserServer.debugOut("pathToServer is: " + string, 3);
                        vector = this.getLocaleFileLanguages(string + File.separator + "Locale-Files", true);
                        if (vector == null || vector.size() <= 0) {
                            vector = this.getLocaleFileLanguages(string, false);
                        }
                    }
                    if (vector == null || vector.size() <= 0) {
                        vector = this.getUserServerConnector().getCollectionsLanguages();
                    }
                }
            }
            catch (Exception exception) {
                UserServer.debugOut("Exception in getAvailableLocales(): " + exception, 3);
                if (vector != null && vector.size() > 0) break block11;
                vector = this.getUserServerConnector().getCollectionsLanguages();
            }
        }
        try {
            if (vector == null) {
                vector = new Vector();
            }
            if (!vector.contains(object = new Locale("en", "US"))) {
                vector.addElement(object);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return vector;
    }

    public Vector getUsers() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getUserServerConnector().getUserRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new Vector();
    }

    public Vector getUserGroups() {
        return this.getUserGroups(true);
    }

    public Vector getUserGroups(boolean bl) {
        if (this.hasServerReadPermission(true)) {
            if (bl || this.userGroups == null || this.userGroups.size() == 0) {
                this.insightAdministrator.showWaitCursor(true);
                this.userGroups = this.getUserServerConnector().getUserGroupRecords();
                this.insightAdministrator.showWaitCursor(false);
            }
            return this.userGroups;
        }
        return new Vector();
    }

    public void refreshConfigurationFileProperties() {
        UserServer.debugOut("in refreshConfigurationInformation()...");
        this.insightAdministrator.showWaitCursor(true);
        this.configFileProperties = new UserServerConfigurationFileProperties(this, this.configFilePath);
        this.configFileProperties.refresh();
        this.insightAdministrator.showWaitCursor(false);
    }

    public String getImageGroupFilePath() {
        return this.igfManager.getGroupFilePath();
    }

    public void setImageGroupFilePath(String string) {
        this.igfManager.setGroupFilePath(string, false);
    }

    public boolean doesImageGroupFilePathExist() {
        return this.igfManager.groupFilePathExists();
    }

    public List getImageGroupFileList(String string, String string2) {
        return this.igfManager.getImageGroupFileInfoList(string, string2, 0);
    }

    public ImageGroupFile getImageGroupFile(String string, String string2, String string3) {
        return this.igfManager.getImageGroupFile(string, string2, 0, string3);
    }

    public boolean renameImageGroupFile(String string, String string2, ImageGroupFile imageGroupFile, String string3) {
        if (this.deleteImageGroupFile(string, string2, imageGroupFile)) {
            imageGroupFile.setGroupName(string3);
            if (this.igfManager.saveImageGroupFile(string, string2, 0, imageGroupFile, true)) {
                UserServer.debugOut(imageGroupFile.getGroupName() + " successfully renamed.");
                return true;
            }
            UserServer.debugOut("Could not save " + imageGroupFile.getGroupName() + ".");
        } else {
            UserServer.debugOut("Could not rename " + imageGroupFile.getGroupName() + " to " + string3 + "; " + imageGroupFile.getGroupName() + " could not be deleted.");
        }
        return false;
    }

    public boolean deleteImageGroupFile(String string, String string2, ImageGroupFile imageGroupFile) {
        return this.igfManager.deleteImageGroupFile("", "", string, string2, 0, imageGroupFile.getGroupName(), true);
    }

    public List getUserShares() {
        if (this.hasServerReadPermission(true)) {
            this.insightAdministrator.showWaitCursor(true);
            Vector vector = this.getUserServerConnector().getUserShareRecords();
            this.insightAdministrator.showWaitCursor(false);
            return vector;
        }
        return new ArrayList();
    }

    public static void debugOut(String string) {
        UserServer.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UserServer: " + string, n);
    }
}

