/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.userserver;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.userserver.UsImageGroupFilePathEditComponent;
import com.luna.insight.admin.userserver.UserServer;
import com.luna.insight.admin.userserver.UserServerNode;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class UsImageGroupFilePath
extends EditableDataObject {
    protected UserServerNode serverNode;
    protected UserServer userServer;
    protected String path = null;
    protected UsImageGroupFilePathEditComponent editComponent = null;

    public UsImageGroupFilePath(UserServerNode userServerNode) {
        this.serverNode = userServerNode;
        this.userServer = userServerNode.getUserServer();
        this.path = this.userServer.getImageGroupFilePath();
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getPath();
    }

    public EditComponent getEditComponent() {
        this.editComponent = new UsImageGroupFilePathEditComponent(this);
        this.editComponent.getPathField().setText(this.path);
        return this.editComponent;
    }

    public void save() {
        UsImageGroupFilePath.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.path, this.editComponent.getPathField().getText())) {
            this.path = this.editComponent.getPathField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.userServer.setImageGroupFilePath(this.path);
            this.userServer.saveToDisk();
            this.serverNode.imageGroupFilesNode.expandNode();
            this.serverNode.imageGroupFilesNode.updateInformationDisplay();
            this.cancelEdit();
        } else {
            this.cancelEdit();
        }
    }

    public void cancel() {
        UsImageGroupFilePath.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.cancelEdit();
    }

    private void cancelEdit() {
        this.userServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Image Group File Path";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.userServer.getName() + "-" + this.getPath();
    }

    public boolean equals(Object object) {
        if (object instanceof UsImageGroupFilePath) {
            UsImageGroupFilePath usImageGroupFilePath = (UsImageGroupFilePath)object;
            return this.path.equals(usImageGroupFilePath.path);
        }
        return super.equals(object);
    }

    public static void debugOut(String string) {
        UsImageGroupFilePath.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("UsImageGroupFilePath: " + string, n);
    }
}

