/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.manytomanymap;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.SaveCancelController;
import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.manytomanymap.ManyToManyMap;
import com.luna.insight.admin.manytomanymap.ManyToManyMapController;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.admin.manytomanymap.MappedThumbnailViewer;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ManyToManyMapEditComponent
extends EditComponent
implements ManyToManyMapController,
SaveCancelController,
ActionListener {
    protected static final int WEST_SIDE = 0;
    protected static final int EAST_SIDE = 1;
    protected static final int NORMAL_MODE = 0;
    protected static final int SPLIT_MODE = 1;
    protected static final int HORIZONTAL_SPACE = 10;
    protected static final int VERTICAL_SPACE = 10;
    protected static final int SPLIT_VIEW_DIVIDER_SPACE = 3;
    protected static final String RETURN_COMMAND = "return-command";
    protected static final ImageIcon PASSIVE_RETURN_ICON = IconMaker.createImage("images/passive-close-icon.gif");
    protected static final ImageIcon ROLLOVER_RETURN_ICON = IconMaker.createImage("images/rollover-close-icon.gif");
    protected static final Font TEXT_FONT = new Font("Dialog", 1, 12);
    protected static final Border LEFT_PAD_BORDER = new EmptyBorder(0, 4, 0, 0);
    protected static final LayoutManager THUMBNAIL_LAYOUT = new VerticalStackResizeWidthLayout();
    protected ManyToManyMap theMap;
    protected List westThumbnails;
    protected List eastThumbnails;
    public MappedThumbnailViewer westViewer;
    public MappedThumbnailViewer eastViewer;
    protected MappedThumbnailViewer splitBottomViewer = null;
    protected MappedThumbnailViewer splitTopViewer = null;
    protected JPanel splitViewPanel = null;
    protected JPanel splitViewDivider = null;
    protected JButton returnButton = null;
    protected JLabel selectionCntLabel = null;
    protected JLabel availableCntLabel = null;
    public MappedThumbnail anchorThumbnail = null;
    public MappedThumbnail lastAnchorThumbnail;
    public MappedThumbnailViewer anchorViewer = null;
    protected int anchorSide = 0;
    protected int targetSide = 1;
    protected Rectangle westSideBounds = null;
    protected Rectangle eastSideBounds = null;
    protected MappedThumbnailViewer targetViewer = null;
    protected List targetThumbnails = null;
    protected int currentMode;
    protected int lastMode = this.currentMode = 0;

    public static void debugOut(String string) {
        ManyToManyMapEditComponent.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("ManyToManyMapEditComponent: " + string, n);
    }

    public ManyToManyMapEditComponent(ManyToManyMap manyToManyMap) {
        this.theMap = manyToManyMap;
        this.setLayout(null);
        this.westViewer = new MappedThumbnailViewer(this.getThumbnailLayout(0));
        this.eastViewer = new MappedThumbnailViewer(this.getThumbnailLayout(1));
        this.splitTopViewer = new MappedThumbnailViewer();
        this.splitBottomViewer = new MappedThumbnailViewer();
        this.splitViewDivider = new JPanel();
        this.splitViewDivider.setBackground(Color.black);
        this.selectionCntLabel = new JLabel();
        this.selectionCntLabel.setFont(TEXT_FONT);
        this.selectionCntLabel.setBorder(LEFT_PAD_BORDER);
        this.availableCntLabel = new JLabel();
        this.availableCntLabel.setFont(TEXT_FONT);
        this.availableCntLabel.setBorder(LEFT_PAD_BORDER);
        this.returnButton = this.createImageButton(PASSIVE_RETURN_ICON, ROLLOVER_RETURN_ICON, ROLLOVER_RETURN_ICON, RETURN_COMMAND, this);
        this.returnButton.addActionListener(this);
        this.splitViewPanel = new JPanel(null){

            public void doLayout() {
                Insets insets = this.getInsets();
                ManyToManyMapEditComponent.this.returnButton.setLocation(this.getWidth() - insets.right - ManyToManyMapEditComponent.this.returnButton.getWidth(), insets.top + (Math.max(ManyToManyMapEditComponent.this.returnButton.getHeight(), ManyToManyMapEditComponent.this.selectionCntLabel.getPreferredSize().height) - ManyToManyMapEditComponent.this.returnButton.getHeight()) / 2);
                ManyToManyMapEditComponent.this.selectionCntLabel.setBounds(insets.left, insets.top, ManyToManyMapEditComponent.this.returnButton.getX() - insets.left, ManyToManyMapEditComponent.this.selectionCntLabel.getPreferredSize().height);
                ManyToManyMapEditComponent.this.availableCntLabel.setSize(this.getWidth() - insets.left - insets.right, ManyToManyMapEditComponent.this.availableCntLabel.getPreferredSize().height);
                ManyToManyMapEditComponent.this.availableCntLabel.setLocation(insets.left, this.getHeight() - insets.bottom - ManyToManyMapEditComponent.this.availableCntLabel.getHeight());
                int n = ManyToManyMapEditComponent.this.selectionCntLabel.getPreferredSize().height;
                int n2 = Math.max(n, ManyToManyMapEditComponent.this.returnButton.getHeight());
                n = ManyToManyMapEditComponent.this.availableCntLabel.getPreferredSize().height;
                Insets insets2 = ManyToManyMapEditComponent.this.splitViewPanel.getInsets();
                int n3 = (ManyToManyMapEditComponent.this.splitViewPanel.getHeight() - 3 - n2 - n - insets2.top) / 3;
                ManyToManyMapEditComponent.this.splitTopViewer.setBounds(0, insets2.top + n2, this.getWidth(), n3);
                ManyToManyMapEditComponent.this.splitBottomViewer.setLocation(0, ManyToManyMapEditComponent.this.splitTopViewer.getY() + ManyToManyMapEditComponent.this.splitTopViewer.getHeight() + 3);
                ManyToManyMapEditComponent.this.splitBottomViewer.setSize(this.getWidth(), ManyToManyMapEditComponent.this.availableCntLabel.getY() - ManyToManyMapEditComponent.this.splitBottomViewer.getY());
                ManyToManyMapEditComponent.this.splitViewDivider.setBounds(0, ManyToManyMapEditComponent.this.splitTopViewer.getHeight(), ManyToManyMapEditComponent.this.splitViewPanel.getWidth(), ManyToManyMapEditComponent.this.splitBottomViewer.getY() - ManyToManyMapEditComponent.this.splitTopViewer.getY() - ManyToManyMapEditComponent.this.splitTopViewer.getHeight());
            }
        };
        this.splitViewPanel.add(this.splitTopViewer);
        this.splitViewPanel.add(this.splitBottomViewer);
        this.splitViewPanel.add(this.returnButton);
        this.splitViewPanel.add(this.selectionCntLabel);
        this.splitViewPanel.add(this.availableCntLabel);
        this.splitViewPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add(this.westViewer);
        this.add(this.eastViewer);
        this.add(this.splitViewPanel);
        this.switchMode(this.currentMode);
    }

    public Rectangle getWestSideBounds() {
        return this.westSideBounds;
    }

    public Rectangle getEastSideBounds() {
        return this.eastSideBounds;
    }

    public void setWestSideBounds(Rectangle rectangle) {
        this.westSideBounds = rectangle;
    }

    public void setEastSideBounds(Rectangle rectangle) {
        this.eastSideBounds = rectangle;
    }

    public List getWestThumbnails() {
        return this.westThumbnails;
    }

    public List getEastThumbnails() {
        return this.eastThumbnails;
    }

    public void populateWestViewer(List list) {
        this.westThumbnails = list;
        this.westViewer.populate(this.westThumbnails);
        this.westViewer.refreshLayout();
    }

    public void populateEastViewer(List list) {
        this.eastThumbnails = list;
        this.eastViewer.populate(this.eastThumbnails);
        this.eastViewer.refreshLayout();
    }

    public void switchMode(int n) {
        this.lastMode = this.currentMode;
        this.currentMode = n;
    }

    protected void setTargets() {
        this.anchorSide = this.anchorViewer == this.westViewer ? 0 : 1;
        this.targetSide = this.anchorViewer == this.westViewer ? 1 : 0;
        this.targetViewer = this.anchorViewer == this.westViewer ? this.eastViewer : this.westViewer;
        this.targetThumbnails = this.anchorViewer == this.westViewer ? this.eastThumbnails : this.westThumbnails;
    }

    public void resetView() {
        this.anchorThumbnail = null;
        this.anchorViewer = null;
        this.switchMode(0);
        this.updateView();
    }

    protected void updateView() {
        this.deselectAllThumbnails();
        this.splitTopViewer.removeAllThumbnails();
        this.splitBottomViewer.removeAllThumbnails();
        if (this.currentMode == 0 && this.lastMode != 0) {
            this.populateWestViewer(this.westThumbnails);
            this.populateEastViewer(this.eastThumbnails);
        }
        this.setTargets();
        if (this.anchorThumbnail != null && this.anchorViewer != null) {
            this.anchorThumbnail.select(true, true);
            this.anchorThumbnail.getViewer().scrollToThumbnail(this.anchorThumbnail);
            List list = this.theMap.getMappingsList(this.anchorThumbnail.getMapObject());
            if (this.currentMode == 0) {
                this.targetViewer.selectThumbnails(list, true, false, this.anchorThumbnail != this.lastAnchorThumbnail);
            } else {
                this.splitTopViewer.populate(this.getThumbnails(this.targetThumbnails, list, true));
                this.splitTopViewer.selectAllThumbnails(true, false);
                this.splitBottomViewer.populate(this.getThumbnails(this.targetThumbnails, list, false));
                this.selectionCntLabel.setText(this.getSelectionCountText(this.splitTopViewer.getThumbnailCount(), this.targetSide));
                this.availableCntLabel.setText(this.getAvailableCountText(this.splitBottomViewer.getThumbnailCount(), this.targetSide));
            }
            this.lastAnchorThumbnail = this.anchorThumbnail;
        }
        this.doLayout();
    }

    public void calculateSideBounds() {
        Insets insets = this.getInsets();
        int n = (this.getWidth() - insets.left - insets.right - 10) / 2;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        this.westSideBounds = new Rectangle(insets.left, insets.top, n, n2);
        this.eastSideBounds = new Rectangle(this.westSideBounds.x + this.westSideBounds.width + 10, insets.top, this.getWidth() - insets.right - 10 - this.westSideBounds.x - this.westSideBounds.width, n2);
    }

    public void doLayout() {
        this.calculateSideBounds();
        if (this.currentMode == 0) {
            this.westViewer.setBounds(this.westSideBounds);
            this.eastViewer.setBounds(this.eastSideBounds);
            this.splitViewPanel.setBounds(-100, -100, 0, 0);
            this.westViewer.refreshLayout();
            this.eastViewer.refreshLayout();
        } else if (this.currentMode == 1) {
            this.setTargets();
            if (this.targetSide == 0) {
                this.splitTopViewer.setThumbnailLayout(this.getThumbnailLayout(0));
                this.splitBottomViewer.setThumbnailLayout(this.getThumbnailLayout(0));
                this.splitViewPanel.setBounds(this.westSideBounds);
                this.eastViewer.setBounds(this.eastSideBounds);
                this.eastViewer.refreshLayout();
                this.westViewer.setBounds(-100, -100, 0, 0);
            } else if (this.targetSide == 1) {
                this.westViewer.setBounds(this.westSideBounds);
                this.splitTopViewer.setThumbnailLayout(this.getThumbnailLayout(1));
                this.splitBottomViewer.setThumbnailLayout(this.getThumbnailLayout(1));
                this.splitViewPanel.setBounds(this.eastSideBounds);
                this.westViewer.refreshLayout();
                this.eastViewer.setBounds(-100, -100, 0, 0);
            }
            this.splitViewPanel.doLayout();
            this.splitTopViewer.refreshLayout();
            this.splitBottomViewer.refreshLayout();
        }
    }

    public void hideViewers() {
        this.westViewer.setBounds(-100, -100, 0, 0);
        this.eastViewer.setBounds(-100, -100, 0, 0);
        this.splitViewPanel.setBounds(-100, -100, 0, 0);
    }

    public List getThumbnails(List list, List list2, boolean bl) {
        ArrayList<MappedThumbnail> arrayList = new ArrayList<MappedThumbnail>();
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            MappedThumbnail mappedThumbnail = (MappedThumbnail)list.get(i);
            bl2 = false;
            for (int j = 0; j < list2.size(); ++j) {
                if (!mappedThumbnail.mapObjectEquals(list2.get(j))) continue;
                bl2 = true;
                break;
            }
            if (bl && bl2) {
                arrayList.add(mappedThumbnail);
                continue;
            }
            if (bl || bl2) continue;
            arrayList.add(mappedThumbnail);
        }
        return arrayList;
    }

    public String getSelectionCountText(int n, int n2) {
        return n + " selected.";
    }

    public String getAvailableCountText(int n, int n2) {
        return n + " available.";
    }

    public LayoutManager getThumbnailLayout(int n) {
        return THUMBNAIL_LAYOUT;
    }

    public void deselectAllThumbnails() {
        int n;
        for (n = 0; this.westThumbnails != null && n < this.westThumbnails.size(); ++n) {
            ((MappedThumbnail)this.westThumbnails.get(n)).select(false, false);
        }
        for (n = 0; this.eastThumbnails != null && n < this.eastThumbnails.size(); ++n) {
            ((MappedThumbnail)this.eastThumbnails.get(n)).select(false, false);
        }
    }

    public void thumbnailPressed(MappedThumbnail mappedThumbnail, int n) {
        int n2 = this.currentMode;
        if (n >= 2) {
            n2 = 1;
        }
        if (this.anchorThumbnail == null) {
            this.anchorThumbnail = mappedThumbnail;
            this.anchorViewer = mappedThumbnail.getViewer();
        } else if (mappedThumbnail.getViewer() == this.anchorViewer) {
            if (mappedThumbnail == this.anchorThumbnail && n == 1) {
                this.anchorThumbnail = null;
                this.anchorViewer = null;
                this.lastAnchorThumbnail = null;
                n2 = 0;
            } else {
                this.anchorThumbnail = mappedThumbnail;
            }
        } else if (mappedThumbnail.isSelected()) {
            this.theMap.unmap(this.anchorThumbnail.getMapObject(), mappedThumbnail.getMapObject());
        } else {
            this.theMap.map(this.anchorThumbnail.getMapObject(), mappedThumbnail.getMapObject());
        }
        this.switchMode(n2);
        this.updateView();
    }

    public void save() {
    }

    public void cancel() {
    }

    public EditComponent getEditComponent() {
        return this;
    }

    public String getWindowTitle() {
        return "";
    }

    public ImageIcon getWindowIcon() {
        return null;
    }

    public String getSaveButtonText() {
        return "Save";
    }

    public String getCancelButtonText() {
        return "Cancel";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(RETURN_COMMAND)) {
            this.switchMode(0);
            this.updateView();
        }
    }

    protected JButton createImageButton(ImageIcon imageIcon, ImageIcon imageIcon2, ImageIcon imageIcon3, String string, ActionListener actionListener) {
        JButton jButton = new JButton(imageIcon);
        jButton.setOpaque(false);
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setRolloverIcon(imageIcon2);
        jButton.setPressedIcon(imageIcon3);
        jButton.setActionCommand(string);
        jButton.addActionListener(actionListener);
        jButton.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        return jButton;
    }
}

