/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.vocab;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.vocab.CsVocabValue;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlBatchController;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Enumeration;
import java.util.Vector;

public class CsVocabValueRecordHandler
extends DatabaseRecordHandler {
    public CsVocabValueRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CsVocabValueRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CsVocabValue csVocabValue = (CsVocabValue)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "INSERT INTO IRVOCABULARIES (FieldID, VocabValueID, VocabValue) VALUES (" + csVocabValue.fieldID + ", " + csVocabValue.vocabValueID + ", " + this.prepForInsertQuery(csVocabValue.value) + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertVocabValueQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            this.syncFromNewToOld();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            if (databaseRecord instanceof CsVocabValue) {
                int n = ((CsVocabValue)databaseRecord).fieldID;
                int n2 = ((CsVocabValue)databaseRecord).vocabValueID;
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                String string = "DELETE FROM IRVOCABULARIES WHERE FieldID = " + n + " AND VocabValueID = " + n2;
                databaseConnector.setQuery(string);
                this.debugOut("deleteVocabValueQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            this.syncFromNewToOld();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(-1);
    }

    public Vector getRecords(int n) {
        this.debugOut("in getRecords()");
        Vector<CsVocabValue> vector = new Vector<CsVocabValue>();
        int n2 = n;
        try {
            this.syncFromOldToNew();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRVOCABULARIES", null, "*");
            if (n2 != -1) {
                sqlQueryGenerator.appendToWhere("FieldID = " + n2);
            }
            sqlQueryGenerator.addOrderBy("IRVOCABULARIES", "FieldID");
            sqlQueryGenerator.addOrderBy("IRVOCABULARIES", "VocabValueID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Vocab values query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CsVocabValue csVocabValue = new CsVocabValue((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("FieldID"), databaseConnector.getIntegerFieldByName("VocabValueID"), databaseConnector.getFieldByName("VocabValue"));
                    vector.addElement(csVocabValue);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CsVocabValue csVocabValue = null;
        try {
            int n = ((CsVocabValue)databaseRecord).fieldID;
            int n2 = ((CsVocabValue)databaseRecord).vocabValueID;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRVOCABULARIES", null, "*");
            sqlQueryGenerator.appendToWhere("FieldID = " + n + " AND VocabValueID = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Vocab value query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                csVocabValue = new CsVocabValue((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("FieldID"), databaseConnector.getIntegerFieldByName("VocabValueID"), databaseConnector.getFieldByName("VocabValue"));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return csVocabValue;
    }

    public String getNextValidIDQuery() {
        return "";
    }

    public String getNextValidIDQuery(int n) {
        return "SELECT VocabValueID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRVOCABULARIES" + " WHERE FieldID = " + n + " ORDER BY VocabValueID";
    }

    private void syncFromOldToNew() {
        this.debugOut("in syncFromOldToNew()");
        try {
            Object object;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "SELECT F.FieldID, VO.VocabValue FROM IRFIELDS F, IRVOCABULARY VO WHERE F.FieldName = VO.FieldName ORDER BY FieldID";
            databaseConnector.setQuery(string);
            this.debugOut("getOldValuesQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            Vector<CsVocabValue> vector = new Vector<CsVocabValue>();
            if (databaseConnector.more()) {
                int n = 1;
                while (databaseConnector.more()) {
                    object = new CsVocabValue((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("FieldID"), n, databaseConnector.getFieldByName("VocabValue"));
                    ++n;
                    vector.addElement((CsVocabValue)object);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            if (vector.size() > 0) {
                String string2 = "DELETE FROM IRVOCABULARIES";
                databaseConnector.setQuery(string2);
                this.debugOut("clearVocabTableQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                object = new SqlBatchController(databaseConnector, 100);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    CsVocabValue csVocabValue = (CsVocabValue)enumeration.nextElement();
                    ((SqlBatchController)object).postSqlCommand("INSERT INTO IRVOCABULARIES (FieldID, VocabValueID, VocabValue) VALUES (" + csVocabValue.fieldID + ", " + csVocabValue.vocabValueID + ", " + this.prepForInsertQuery(csVocabValue.value) + ")");
                }
                ((SqlBatchController)object).executeRemainingCommands();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in syncFromOldToNew(): " + exception);
        }
    }

    private void syncFromNewToOld() {
        this.debugOut("in syncFromNewToOld()");
        try {
            Object object;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "SELECT F.FieldName, T.TableName, VN.VocabValue FROM IRFIELDS F, ISTABLES T, IRVOCABULARIES VN WHERE F.FieldID = VN.FieldID AND T.TableID = F.TableID ORDER BY F.FieldID";
            databaseConnector.setQuery(string);
            this.debugOut("getNewValuesQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            Vector<Object> vector = new Vector<Object>();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    object = new OldVocabValueShell(databaseConnector.getFieldByName("FieldName"), databaseConnector.getFieldByName("TableName"), databaseConnector.getFieldByName("VocabValue"));
                    vector.addElement(object);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            if (vector.size() > 0) {
                object = "DELETE FROM IRVOCABULARY";
                databaseConnector.setQuery((String)object);
                this.debugOut("clearVocabTableQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                SqlBatchController sqlBatchController = new SqlBatchController(databaseConnector, 100);
                for (int i = 0; i < vector.size(); ++i) {
                    OldVocabValueShell oldVocabValueShell = (OldVocabValueShell)vector.elementAt(i);
                    sqlBatchController.postSqlCommand("INSERT INTO IRVOCABULARY (VocabularyID, FieldName, TableName, VocabValue) VALUES (" + (i + 1) + ", " + this.prepForInsertQuery(oldVocabValueShell.fieldName) + ", " + this.prepForInsertQuery(oldVocabValueShell.tableName) + ", " + this.prepForInsertQuery(oldVocabValueShell.vocabValue) + ")");
                }
                sqlBatchController.executeRemainingCommands();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in syncFromNewToOld(): " + exception);
        }
    }

    public void updateMaxIDValue(long l) {
    }

    class OldVocabValueShell {
        protected String fieldName;
        protected String tableName;
        protected String vocabValue;

        public OldVocabValueShell(String string, String string2, String string3) {
            this.fieldName = string;
            this.tableName = string2;
            this.vocabValue = string3;
        }
    }
}

