/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.vocab;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.NodeChildConstituent;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.vocab.CsVocabularyEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CsVocabValue
extends EditableDataObject
implements IndexedObject,
DatabaseRecord,
NodeChildConstituent {
    protected int vocabValueID;
    protected CollectionServer collectionServer;
    protected String value = "";
    protected int fieldID = 0;
    protected CsVocabularyEditComponent editComponent = null;

    public CsVocabValue(CollectionServer collectionServer, int n, int n2, String string) {
        this.collectionServer = collectionServer;
        this.fieldID = n;
        this.vocabValueID = n2;
        this.value = string == null ? "" : string;
    }

    public CsVocabValue(int n, int n2, CollectionServer collectionServer) {
        this.fieldID = n;
        this.vocabValueID = n2;
        this.collectionServer = collectionServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.value;
    }

    public int getIndex() {
        return this.vocabValueID;
    }

    public int getParentNodeID() {
        return this.fieldID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CsVocabularyEditComponent();
        this.editComponent.getValueField().setText(this.value);
        this.editComponent.getValueField().selectAll();
        this.editComponent.getValueField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CsVocabValue.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.value, this.editComponent.getValueField().getText())) {
            this.value = this.editComponent.getValueField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CsVocabValue.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Vocabulary Value - " + this.value;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-vocab-values-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.fieldID + "-" + this.vocabValueID;
    }

    public boolean equals(Object object) {
        if (object instanceof CsVocabValue) {
            CsVocabValue csVocabValue = (CsVocabValue)object;
            return this.fieldID == csVocabValue.fieldID && this.vocabValueID == csVocabValue.vocabValueID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CsVocabValue) {
            CsVocabValue csVocabValue = (CsVocabValue)databaseRecord;
            return this.fieldID == csVocabValue.fieldID && this.vocabValueID == csVocabValue.vocabValueID && CsVocabValue.stringsAreEqual(this.value, csVocabValue.value);
        }
        return false;
    }

    public static void debugOut(String string) {
        CsVocabValue.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsVocabValue: " + string, n);
    }
}

