/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.usergroup;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.usergroup.CollectionServerUserGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CollectionServerUserGroupsNode
extends TableDisplayControlPanelNode {
    protected CollectionNode collectionNode = null;

    public CollectionServerUserGroupsNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "User Groups", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Group Name", "Code Key", "Profile ID", "Connection Pool ID", "Connection Reserve", "IP Address Range", "Browser IP Address Range", "Created"};
    }

    public void updateInformationDisplay() {
        Integer n = this.collectionNode.getCollection().getUniqueCollectionID();
        this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollectionServerNode().getCollectionServer().getUserGroups(n)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerUserGroup collectionServerUserGroup = (CollectionServerUserGroup)vector.elementAt(i);
            objectArray[i][0] = collectionServerUserGroup;
            objectArray[i][1] = collectionServerUserGroup.codeKey;
            objectArray[i][2] = "" + collectionServerUserGroup.profileID;
            objectArray[i][3] = "" + collectionServerUserGroup.connectionPoolID;
            objectArray[i][4] = "" + collectionServerUserGroup.connectionReserve;
            objectArray[i][5] = collectionServerUserGroup.ipAddressRange;
            objectArray[i][6] = collectionServerUserGroup.browserIpAddressRange;
            objectArray[i][7] = new SimpleDate(collectionServerUserGroup.createdTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New User Group Command", this.collectionNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-user-groups-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), "New User Group Command", "Edit User Group Command", "Delete User Group Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New User Group Command")) {
            this.collectionNode.getCollectionServerNode().createNewUserGroup(this.collectionNode.getCollection().getUniqueCollectionID());
        } else if (string.equals("Delete User Group Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionNode.getCollectionServerNode().removeUserGroups(vector);
            }
        } else if (string.equals("Edit User Group Command") && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().editUserGroup((CollectionServerUserGroup)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().editUserGroup((CollectionServerUserGroup)object);
        }
    }

    public static void debugOut(String string) {
        CollectionServerUserGroupsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerUserGroupsNode: " + string, n);
    }
}

