/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.usergroup;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPool;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CollectionServerConnectionPoolsNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode collectionServerNode = null;

    public CollectionServerConnectionPoolsNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "Connection Pools", false);
        this.collectionServerNode = collectionServerNode;
        this.columnNames = new Object[]{"Name", "Maximum Connections"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getConnectionPools()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CollectionServerConnectionPool collectionServerConnectionPool = (CollectionServerConnectionPool)vector.elementAt(i);
            objectArray[i][0] = collectionServerConnectionPool;
            objectArray[i][1] = "" + collectionServerConnectionPool.maxConnections;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New Connection Pool Command", this.collectionServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), "New Connection Pool Command", "Edit Connection Pool Command", "Delete Connection Pool Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Connection Pool Command")) {
            this.collectionServerNode.createNewConnectionPool();
        } else if (string.equals("Delete Connection Pool Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionServerNode.removeConnectionPools(vector);
            }
        } else if (string.equals("Edit Connection Pool Command") && vector != null && vector.size() == 1) {
            this.collectionServerNode.editConnectionPool((CollectionServerConnectionPool)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionServerNode.editConnectionPool((CollectionServerConnectionPool)object);
        }
    }

    public static void debugOut(String string) {
        CollectionServerConnectionPoolsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConnectionPoolsNode: " + string, n);
    }
}

