/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.usergroup;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.usergroup.CollectionServerConnectionPoolEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CollectionServerConnectionPool
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int connectionPoolID;
    protected CollectionServer collectionServer;
    protected String poolName = "";
    protected int maxConnections = 50;
    protected CollectionServerConnectionPoolEditComponent editComponent = null;

    public CollectionServerConnectionPool(CollectionServer collectionServer, int n, String string, int n2) {
        this.collectionServer = collectionServer;
        this.connectionPoolID = n;
        this.poolName = string == null ? "" : string;
        this.maxConnections = n2;
    }

    public CollectionServerConnectionPool(int n, CollectionServer collectionServer) {
        this.connectionPoolID = n;
        this.collectionServer = collectionServer;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.poolName;
    }

    public int getIndex() {
        return this.connectionPoolID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CollectionServerConnectionPoolEditComponent();
        this.editComponent.getPoolNameField().setText(this.poolName);
        this.editComponent.getMaxConnectionsField().setText("" + this.maxConnections);
        this.editComponent.getPoolNameField().selectAll();
        this.editComponent.getPoolNameField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CollectionServerConnectionPool.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.poolName, this.editComponent.getPoolNameField().getText())) {
            this.poolName = this.editComponent.getPoolNameField().getText();
        }
        try {
            if (this.hasChanged(this.maxConnections, Integer.parseInt(this.editComponent.getMaxConnectionsField().getText()))) {
                this.maxConnections = Integer.parseInt(this.editComponent.getMaxConnectionsField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CollectionServerConnectionPool.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Connection Pool - " + this.poolName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CollectionServerConnectionPool) {
            CollectionServerConnectionPool collectionServerConnectionPool = (CollectionServerConnectionPool)object;
            return this.connectionPoolID == collectionServerConnectionPool.connectionPoolID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CollectionServerConnectionPool) {
            CollectionServerConnectionPool collectionServerConnectionPool = (CollectionServerConnectionPool)databaseRecord;
            return this.connectionPoolID == collectionServerConnectionPool.connectionPoolID && CollectionServerConnectionPool.stringsAreEqual(this.poolName, collectionServerConnectionPool.poolName) && this.maxConnections == collectionServerConnectionPool.maxConnections;
        }
        return false;
    }

    public static void debugOut(String string) {
        CollectionServerConnectionPool.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CollectionServerConnectionPool: " + string, n);
    }
}

