/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.task;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskItemRecordHandler;
import com.luna.insight.admin.collserver.task.CcTaskLockFailedException;
import com.luna.insight.admin.collserver.task.CcTaskRecord;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class CcTaskRecordHandler
extends DatabaseRecordHandler {
    private CcTaskItemRecordHandler taskItemHandler;
    private Object taskLockObj = new Object();

    public CcTaskRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcTaskRecordHandler";
        this.taskItemHandler = new CcTaskItemRecordHandler(administeredServerConnector);
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            DatabaseRecord databaseRecord2;
            CcTaskRecord ccTaskRecord = (CcTaskRecord)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TaskID", 2, stringBuffer2, ccTaskRecord.getIndex() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "TaskName", 1, stringBuffer2, ccTaskRecord.getTaskName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "Description", 1, stringBuffer2, ccTaskRecord.getDescription());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StartTime", 1, stringBuffer2, ccTaskRecord.getStartTime() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EndTime", 1, stringBuffer2, ccTaskRecord.getCompleteTime() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "LockOwnerAccountID", 2, stringBuffer2, ccTaskRecord.getTaskLockerID() + "");
            databaseConnector.setQuery("INSERT INTO CCTASKS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert task record:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            Iterator iterator = ccTaskRecord.getAssignedAccounts().iterator();
            while (iterator.hasNext()) {
                databaseRecord2 = (AdminAccount)iterator.next();
                String string = "INSERT INTO CCTASKACCOUNTMAP (TaskID, AccountID) VALUES (" + ccTaskRecord.getIndex() + ", " + ((AdminAccount)databaseRecord2).getIndex() + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertAccountMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
            iterator = ccTaskRecord.getTaskItems().iterator();
            while (iterator.hasNext()) {
                databaseRecord2 = (CcTaskItem)iterator.next();
                databaseRecord2.setTaskItemID(this.taskItemHandler.getNextValidID());
                this.taskItemHandler.doInsert(databaseRecord2, ccTaskRecord.getIndex());
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CCTASKS WHERE TaskID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteTaskQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "DELETE FROM CCTASKACCOUNTMAP WHERE TaskID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string2);
            this.debugOut("deleteAccountMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            this.taskItemHandler.clearItemsForTask(databaseRecord.getIndex());
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    private Hashtable getAccountsHashtable() {
        Hashtable<Integer, AdminAccount> hashtable = new Hashtable<Integer, AdminAccount>();
        Iterator iterator = this.serverConnector.getAdminAccountRecords().iterator();
        while (iterator.hasNext()) {
            AdminAccount adminAccount = (AdminAccount)iterator.next();
            hashtable.put(new Integer(adminAccount.getIndex()), adminAccount);
        }
        return hashtable;
    }

    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        try {
            int n;
            Object object;
            Hashtable hashtable = this.getAccountsHashtable();
            Hashtable<Integer, Object> hashtable2 = new Hashtable<Integer, Object>();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCTASKS", null, "*");
            sqlQueryGenerator.addOrderBy("CCTASKS", "TaskID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Task records query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    object = new CcTaskRecord((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("TaskID"), databaseConnector.getFieldByName("TaskName"), databaseConnector.getFieldByName("Description"), databaseConnector.getLongField("StartTime"), databaseConnector.getLongField("EndTime"), (AdminAccount)hashtable.get(new Integer(databaseConnector.getIntegerFieldByName("LockOwnerAccountID"))));
                    Vector vector2 = this.taskItemHandler.getRecords((CcTaskRecord)object, hashtable);
                    for (n = 0; n < vector2.size(); ++n) {
                        ((CcTaskRecord)object).addTaskItem((CcTaskItem)vector2.elementAt(n));
                    }
                    hashtable2.put(new Integer(((CcTaskRecord)object).getIndex()), object);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCTASKACCOUNTMAP", null, "*");
            sqlQueryGenerator.addOrderBy("CCTASKACCOUNTMAP", "TaskID");
            sqlQueryGenerator.addOrderBy("CCTASKACCOUNTMAP", "AccountID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Task-account mapping query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                object = null;
                while (databaseConnector.more()) {
                    int n2 = databaseConnector.getIntegerFieldByName("TaskID");
                    n = databaseConnector.getIntegerFieldByName("AccountID");
                    object = (CcTaskRecord)hashtable2.get(new Integer(n2));
                    if (object != null) {
                        ((CcTaskRecord)object).assignAccount((AdminAccount)hashtable.get(new Integer(n)));
                    } else {
                        this.debugOut("Could not find task with TaskID: " + n2);
                    }
                    databaseConnector.next();
                }
            } else {
                this.debugOut("Could not find any task-account mappings.");
            }
            object = hashtable2.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcTaskRecord ccTaskRecord = null;
        int n = databaseRecord.getIndex();
        try {
            Hashtable hashtable = this.getAccountsHashtable();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCTASKS", null, "*");
            sqlQueryGenerator.appendToWhere("TaskID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Task record query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccTaskRecord = new CcTaskRecord((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("TaskID"), databaseConnector.getFieldByName("TaskName"), databaseConnector.getFieldByName("Description"), databaseConnector.getLongField("StartTime"), databaseConnector.getLongField("EndTime"), (AdminAccount)hashtable.get(new Integer(databaseConnector.getIntegerFieldByName("LockOwnerAccountID"))));
                Vector vector = this.taskItemHandler.getRecords(ccTaskRecord, hashtable);
                for (int i = 0; i < vector.size(); ++i) {
                    ccTaskRecord.addTaskItem((CcTaskItem)vector.elementAt(i));
                }
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCTASKACCOUNTMAP", null, "*");
            sqlQueryGenerator.appendToWhere("TaskID = " + n);
            sqlQueryGenerator.addOrderBy("CCTASKACCOUNTMAP", "AccountID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Task-account mapping query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    int n2 = databaseConnector.getIntegerFieldByName("AccountID");
                    ccTaskRecord.assignAccount((AdminAccount)hashtable.get(new Integer(n2)));
                    databaseConnector.next();
                }
            } else {
                this.debugOut("Could not find any task-account mappings.");
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return ccTaskRecord;
    }

    public String getNextValidIDQuery() {
        return "SELECT TaskID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CCTASKS" + " ORDER BY TaskID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockTask(CcTaskRecord ccTaskRecord, AdminAccount adminAccount) throws CcTaskLockFailedException {
        String string = "";
        try {
            Object object = this.taskLockObj;
            synchronized (object) {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
                sqlQueryGenerator.addTable("CCTASKS", null, "LockOwnerAccountID");
                sqlQueryGenerator.appendToWhere("TaskID = " + ccTaskRecord.getIndex());
                databaseConnector.setQuery(sqlQueryGenerator.getQuery());
                this.debugOut("Task record query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runQuery();
                if (databaseConnector.more()) {
                    int n = databaseConnector.getIntegerField("LockOwnerAccountID");
                    if (n > 0 && n != adminAccount.getIndex()) {
                        AdminAccount adminAccount2 = this.serverConnector.getAdministeredServer().getAdminAccount(n);
                        string = "Task \"" + ccTaskRecord + "\" is currently locked by user " + (adminAccount2 == null ? "[Unknown]" : adminAccount2.getName()) + ".";
                        ccTaskRecord.setTaskIsLocked(true);
                        ccTaskRecord.setTaskLocker(adminAccount2);
                    }
                } else {
                    string = "Task \"" + ccTaskRecord + "\" could not be found.";
                }
                databaseConnector.close();
                if (string == null || string.length() == 0) {
                    databaseConnector.setQuery("UPDATE CCTASKS SET LockOwnerAccountID = " + adminAccount.getIndex() + " WHERE TaskID = " + ccTaskRecord.getIndex());
                    this.debugOut("Lock task query: \n" + databaseConnector.getQuery(), 3);
                    databaseConnector.runUpdateQuery();
                    databaseConnector.close();
                    ccTaskRecord.setTaskIsLocked(true);
                    ccTaskRecord.setTaskLocker(adminAccount);
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in lockTask(): " + exception);
            string = "Exception " + exception + " encounterd while locking task \"" + ccTaskRecord + "\".";
        }
        if (string != null && string.length() > 0) {
            throw new CcTaskLockFailedException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockTask(CcTaskRecord ccTaskRecord) {
        try {
            Object object = this.taskLockObj;
            synchronized (object) {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE CCTASKS SET LockOwnerAccountID = 0 WHERE TaskID = " + ccTaskRecord.getIndex());
                this.debugOut("Unlock task query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                ccTaskRecord.setTaskIsLocked(false);
                ccTaskRecord.setTaskLocker(null);
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in unlockTask(): " + exception);
        }
    }

    public void updateTaskStartTime(CcTaskRecord ccTaskRecord) {
        this.debugOut("in updateTaskStartTime()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("UPDATE CCTASKS SET StartTime = " + this.prepForInsertQuery("" + ccTaskRecord.getStartTime()) + " WHERE TaskID = " + ccTaskRecord.getIndex());
            this.debugOut("Update task start time query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateTaskStartTime(): " + exception);
        }
    }

    public void updateTaskCompletionTime(CcTaskRecord ccTaskRecord) {
        this.debugOut("in updateTaskCompletionTime()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("UPDATE CCTASKS SET EndTime = " + this.prepForInsertQuery("" + ccTaskRecord.getCompleteTime()) + " WHERE TaskID = " + ccTaskRecord.getIndex());
            this.debugOut("Update task completion time query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateTaskCompletionTime(): " + exception);
        }
    }

    public void updateMaxIDValue(long l) {
    }
}

