/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.task;

import com.luna.insight.admin.AdminAccount;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ListItemSelector;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.indexer.CcInvokeIndexerTaskItem;
import com.luna.insight.admin.collserver.mediacreation.CcImageCreationTaskItem;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMapTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.admin.collserver.task.CcTaskItemFactory;
import com.luna.insight.admin.collserver.task.CcTaskOpenEditComponent;
import com.luna.insight.admin.collserver.task.CcTaskOpenItemEditComponent;
import com.luna.insight.admin.collserver.task.CcTaskRecordEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CcTaskRecord
extends EditableDataObject
implements DatabaseRecord {
    protected int taskID;
    protected String name;
    protected String description;
    protected long startTime;
    protected long completeTime;
    protected List taskItems = new Vector();
    protected List originalTaskItems = new Vector();
    protected List assignedAccounts = new Vector();
    protected boolean isTaskLocked;
    protected AdminAccount taskLocker;
    protected CollectionServer collectionServer;
    protected CcTaskRecordEditComponent editComponent = null;
    protected CcTaskOpenEditComponent openEditComponent = null;
    protected ListItemSelector itemSelector = null;
    protected boolean isOpeningTask = false;

    public CcTaskRecord(CollectionServer collectionServer, int n, String string, String string2, long l, long l2, AdminAccount adminAccount) {
        this.collectionServer = collectionServer;
        this.taskID = n;
        this.name = string;
        this.description = string2;
        this.startTime = l;
        this.completeTime = l2;
        this.taskLocker = adminAccount;
        this.setTaskIsLocked(adminAccount != null);
    }

    public String getTaskName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCompleteTime() {
        return this.completeTime;
    }

    public boolean isTaskLocked() {
        return this.isTaskLocked;
    }

    public AdminAccount getTaskLocker() {
        return this.taskLocker;
    }

    public boolean isOpeningTask() {
        return this.isOpeningTask;
    }

    public int getTaskLockerID() {
        if (this.taskLocker == null) {
            return -1;
        }
        return this.taskLocker.getIndex();
    }

    public List getTaskItems() {
        return this.taskItems;
    }

    public List getOriginalTaskItems() {
        return this.originalTaskItems;
    }

    public List getAssignedAccounts() {
        return this.assignedAccounts;
    }

    public void setTaskName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setStartTime(long l) {
        this.startTime = l;
        this.refreshOpenTaskComponent();
    }

    public void setCompleteTime(long l) {
        this.completeTime = l;
        this.refreshOpenTaskComponent();
    }

    public void setTaskIsLocked(boolean bl) {
        this.isTaskLocked = bl;
    }

    public void setTaskLocker(AdminAccount adminAccount) {
        this.taskLocker = adminAccount;
    }

    public void setIsOpeningTask(boolean bl) {
        this.isOpeningTask = bl;
    }

    public String toString() {
        return this.getTaskName();
    }

    public void addTaskItem(CcTaskItem ccTaskItem) {
        if (ccTaskItem != null && !this.taskItems.contains(ccTaskItem)) {
            this.taskItems.add(ccTaskItem);
        }
    }

    public void assignAccount(AdminAccount adminAccount) {
        if (adminAccount != null && !this.assignedAccounts.contains(adminAccount)) {
            this.assignedAccounts.add(adminAccount);
        }
    }

    public boolean isAssignedUser(AdminAccount adminAccount) {
        if (this.assignedAccounts != null) {
            return this.assignedAccounts.contains(adminAccount);
        }
        return false;
    }

    public List getPreviousIncompleteTaskItems(CcTaskItem ccTaskItem) {
        int n;
        Vector<CcTaskItem> vector = new Vector<CcTaskItem>(1);
        int n2 = n = this.taskItems != null ? this.taskItems.indexOf(ccTaskItem) : -1;
        if (n > 0) {
            for (int i = 0; i < n && this.taskItems != null && i < this.taskItems.size(); ++i) {
                CcTaskItem ccTaskItem2 = (CcTaskItem)this.taskItems.get(i);
                if (ccTaskItem2.isTaskItemComplete()) continue;
                vector.add(ccTaskItem2);
            }
        }
        return vector;
    }

    public String getUniqueIdentifier() {
        return "Task-" + this.getIndex();
    }

    public EditComponent getEditComponent() {
        if (this.isOpeningTask) {
            return this.getOpenTaskComponent();
        }
        this.editComponent = new CcTaskRecordEditComponent();
        this.editComponent.getNameField().setText(this.name);
        this.editComponent.getDescriptionTextArea().setText(this.description);
        for (int i = 0; i < this.taskItems.size(); ++i) {
            if (this.taskItems.get(i) instanceof CcInvokeIndexerTaskItem) {
                this.editComponent.getInvokeIndexerCheckBox().setSelected(true);
                continue;
            }
            if (this.taskItems.get(i) instanceof CcImageCreationTaskItem) {
                this.editComponent.getCreateImagesCheckBox().setSelected(true);
                continue;
            }
            if (!(this.taskItems.get(i) instanceof CcObjectMediaMapTaskItem)) continue;
            this.editComponent.getMapObjectsCheckBox().setSelected(true);
        }
        if (this.assignedAccounts == null) {
            this.assignedAccounts = new Vector();
        }
        Vector<Integer> vector = new Vector<Integer>();
        Iterator iterator = this.assignedAccounts.iterator();
        while (iterator.hasNext()) {
            vector.addElement(new Integer(((AdminAccount)iterator.next()).getIndex()));
        }
        this.itemSelector = new ListItemSelector("Available Users:", "Assign To:", this.collectionServer.getAdminAccounts(), vector);
        this.editComponent.getAssignToPanel().add(this.itemSelector);
        this.editComponent.getNameField().selectAll();
        this.editComponent.getNameField().requestFocus();
        return this.editComponent;
    }

    public String getCancelButtonText() {
        if (this.isOpeningTask) {
            return "Close";
        }
        return super.getCancelButtonText();
    }

    public boolean getShowSaveButton() {
        return !this.isOpeningTask;
    }

    public void save() {
        Vector vector;
        CcTaskRecord.debugOut("Save...", 3);
        if (this.isOpeningTask) {
            this.cancel();
            return;
        }
        this.requiresCommit = false;
        if (this.hasChanged(this.name, this.editComponent.getNameField().getText())) {
            this.name = this.editComponent.getNameField().getText();
        }
        if (this.hasChanged(this.description, this.editComponent.getDescriptionTextArea().getText())) {
            this.description = this.editComponent.getDescriptionTextArea().getText();
        }
        if (this.hasChanged(this.taskItems, vector = this.getTaskItemsFromEditComponent())) {
            this.originalTaskItems = this.taskItems;
            this.taskItems = vector;
        }
        Vector<IndexedObject> vector2 = new Vector<IndexedObject>();
        IndexedObject[] indexedObjectArray = this.itemSelector.getChosenItems();
        for (int i = 0; i < indexedObjectArray.length; ++i) {
            vector2.addElement(indexedObjectArray[i]);
        }
        if (this.hasChanged(this.assignedAccounts, vector2)) {
            this.assignedAccounts = vector2;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CcTaskRecord.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        if (this.isOpeningTask) {
            return "Open Task: " + this.name;
        }
        return "Edit Task: " + this.name;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public EditComponent getOpenTaskComponent() {
        this.openEditComponent = new CcTaskOpenEditComponent();
        this.openEditComponent.getNameField().setText(this.name);
        this.openEditComponent.getDescriptionTextArea().setText(this.description);
        String string = "";
        Iterator iterator = this.assignedAccounts.iterator();
        while (iterator.hasNext()) {
            string = string + ((AdminAccount)iterator.next()).getName() + "\n";
        }
        this.openEditComponent.getAssignedToTextArea().setText(string);
        this.refreshOpenTaskComponent();
        Collections.sort(this.taskItems);
        int n = 0;
        for (int i = 0; i < this.taskItems.size(); ++i) {
            CcTaskItem ccTaskItem = (CcTaskItem)this.taskItems.get(i);
            CcTaskOpenItemEditComponent ccTaskOpenItemEditComponent = (CcTaskOpenItemEditComponent)ccTaskItem.getTaskItemComponent();
            if (ccTaskOpenItemEditComponent == null) continue;
            ccTaskOpenItemEditComponent.setNumberLabel(++n);
            this.openEditComponent.getItemsPanel().add(ccTaskOpenItemEditComponent);
        }
        return this.openEditComponent;
    }

    public void refreshOpenTaskComponent() {
        if (this.openEditComponent != null) {
            String string = this.startTime > 0L ? DateFormat.getDateTimeInstance(3, 1).format(new Date(this.startTime)) : "Not started";
            this.openEditComponent.getStartedField().setText(string);
            String string2 = this.completeTime > 0L ? DateFormat.getDateTimeInstance(3, 1).format(new Date(this.completeTime)) : "Not completed";
            this.openEditComponent.getCompletedField().setText(string2);
        }
    }

    public int getIndex() {
        return this.taskID;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcTaskRecord) {
            CcTaskRecord ccTaskRecord = (CcTaskRecord)databaseRecord;
            return this.getIndex() == ccTaskRecord.getIndex() && CcTaskRecord.stringsAreEqual(this.getDescription(), ccTaskRecord.getDescription()) && this.getStartTime() == ccTaskRecord.getStartTime() && this.getCompleteTime() == ccTaskRecord.getCompleteTime() && this.isTaskLocked() == ccTaskRecord.isTaskLocked() && this.getTaskLockerID() == ccTaskRecord.getTaskLockerID() && this.getTaskItems().containsAll(ccTaskRecord.getTaskItems()) && ccTaskRecord.getTaskItems().containsAll(this.getTaskItems()) && this.getAssignedAccounts().containsAll(ccTaskRecord.getAssignedAccounts()) && ccTaskRecord.getAssignedAccounts().containsAll(this.getAssignedAccounts());
        }
        return databaseRecord == this;
    }

    private Vector getTaskItemsFromEditComponent() {
        Integer n = new Integer(1);
        Integer n2 = new Integer(2);
        Integer n3 = new Integer(3);
        Vector<Integer> vector = new Vector<Integer>();
        if (this.editComponent.getInvokeIndexerCheckBox().isSelected()) {
            vector.add(n);
        }
        if (this.editComponent.getCreateImagesCheckBox().isSelected()) {
            vector.add(n2);
        }
        if (this.editComponent.getMapObjectsCheckBox().isSelected()) {
            vector.add(n3);
        }
        Vector<CcTaskItem> vector2 = new Vector<CcTaskItem>();
        Iterator iterator = this.taskItems.iterator();
        while (iterator.hasNext()) {
            CcTaskItem ccTaskItem = (CcTaskItem)iterator.next();
            switch (ccTaskItem.getTaskItemType()) {
                case 1: {
                    if (!vector.contains(n)) break;
                    vector2.add(ccTaskItem);
                    vector.removeElement(n);
                    break;
                }
                case 2: {
                    if (!vector.contains(n2)) break;
                    vector2.add(ccTaskItem);
                    vector.removeElement(n2);
                    break;
                }
                case 3: {
                    if (!vector.contains(n3)) break;
                    vector2.add(ccTaskItem);
                    vector.removeElement(n3);
                }
            }
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n4 = (Integer)vector.elementAt(i);
            int n5 = this.collectionServer.getCollectionServerConnector().getNextValidTaskItemID();
            vector2.add(CcTaskItemFactory.getTaskItem(this.collectionServer, this, n5, "", n4, 0L, 0L, null));
        }
        return vector2;
    }

    public boolean allItemsComplete() {
        Iterator iterator = this.taskItems.iterator();
        while (iterator.hasNext()) {
            CcTaskItem ccTaskItem = (CcTaskItem)iterator.next();
            if (ccTaskItem.getTaskItemCompleteTime() > 0L) continue;
            return false;
        }
        return true;
    }

    public static void debugOut(String string) {
        CcTaskRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcTaskRecord: " + string, n);
    }
}

