/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.sps;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.sps.CcSpsData;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CcSpsDataNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode collectionServerNode = null;

    public CcSpsDataNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "SPS Data", false);
        this.collectionServerNode = collectionServerNode;
        this.columnNames = new Object[]{"SPS Number", "Resolution", "Collection ID", "Media Type", "Format", "URL"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getSpsData()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CcSpsData ccSpsData = (CcSpsData)vector.elementAt(i);
            objectArray[i][0] = ccSpsData;
            objectArray[i][1] = "" + ccSpsData.resolutionSize;
            objectArray[i][2] = "" + ccSpsData.collectionID;
            objectArray[i][3] = ImageFile.getMediaTypeToString(ccSpsData.mediaType);
            objectArray[i][4] = ccSpsData.format;
            objectArray[i][5] = ccSpsData.url;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New SPS Data Command", this.collectionServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-sps-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), "New SPS Data Command", "Edit SPS Data Command", "Delete SPS Data Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New SPS Data Command")) {
            this.collectionServerNode.createNewSpsData();
        } else if (string.equals("Delete SPS Data Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionServerNode.removeSpsData(vector);
            }
        } else if (string.equals("Edit SPS Data Command") && vector != null && vector.size() == 1) {
            this.collectionServerNode.editSpsData((CcSpsData)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionServerNode.editSpsData((CcSpsData)object);
        }
    }

    public static void debugOut(String string) {
        CcSpsDataNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcSpsDataNode: " + string, n);
    }
}

