/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.sps;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.sps.CcSpsDataEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import javax.swing.ImageIcon;

public class CcSpsData
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected static final String[] MEDIA_TYPE_OPTIONS = ImageFile.getMediaTypeStrings();
    protected static final String[] FORMAT_OPTIONS = ImageFile.getFormatTypeStrings();
    public CollectionServer collectionServer;
    public int spsNumber = 0;
    public int resolutionSize = 0;
    public int collectionID = 0;
    public int mediaType = 0;
    public String format = "";
    public int originalSpsNumber = 0;
    public int originalResolutionSize = 0;
    public int originalCollectionID = 0;
    public int originalMediaType = 0;
    public String originalFormat = "";
    public String url = "";
    public CcSpsDataEditComponent editComponent = null;

    public static void debugOut(String string) {
        CcSpsData.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcSpsData: " + string, n);
    }

    public CcSpsData(CollectionServer collectionServer, int n, int n2, int n3, int n4, String string, String string2) {
        this.collectionServer = collectionServer;
        this.spsNumber = n;
        this.resolutionSize = n2;
        this.collectionID = n3;
        this.mediaType = n4;
        this.format = string == null ? "" : string;
        this.originalSpsNumber = this.spsNumber;
        this.originalResolutionSize = this.resolutionSize;
        this.originalCollectionID = this.collectionID;
        this.originalMediaType = this.mediaType;
        this.originalFormat = this.format;
        this.url = string2 == null ? "" : string2;
    }

    public CcSpsData(int n, CollectionServer collectionServer) {
        this.spsNumber = n;
        this.collectionServer = collectionServer;
    }

    public int getFormat() {
        return ImageFile.getFormatTypeToInt(this.format);
    }

    public String toString() {
        return "" + this.getIndex();
    }

    public int getIndex() {
        return this.spsNumber;
    }

    public EditComponent getEditComponent() {
        int n;
        this.editComponent = new CcSpsDataEditComponent();
        this.editComponent.getSpsNumberField().setText("" + this.spsNumber);
        this.editComponent.getResolutionSizeField().setText("" + this.resolutionSize);
        this.editComponent.getCollectionIDField().setText("" + this.collectionID);
        int n2 = -1;
        for (n = 0; n < MEDIA_TYPE_OPTIONS.length; ++n) {
            this.editComponent.getMediaTypeComboBox().addItem(MEDIA_TYPE_OPTIONS[n]);
            if (n2 != -1 || this.mediaType != ImageFile.getMediaTypeToInt(MEDIA_TYPE_OPTIONS[n])) continue;
            n2 = n;
        }
        if (n2 > -1) {
            this.editComponent.getMediaTypeComboBox().setSelectedIndex(n2);
        }
        n = -1;
        for (int i = 0; i < FORMAT_OPTIONS.length; ++i) {
            this.editComponent.getFormatComboBox().addItem(FORMAT_OPTIONS[i]);
            if (n != -1 || !this.format.equalsIgnoreCase(FORMAT_OPTIONS[i])) continue;
            n = i;
        }
        if (n == -1) {
            this.editComponent.getFormatComboBox().setSelectedItem(ImageFile.getGeneralFormatString(this.format));
        } else if (n > -1) {
            this.editComponent.getFormatComboBox().setSelectedIndex(n);
        }
        this.editComponent.getUrlField().setText(this.url);
        this.editComponent.getSpsNumberField().selectAll();
        this.editComponent.getSpsNumberField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CcSpsData.debugOut("Save...", 3);
        this.requiresCommit = false;
        try {
            if (this.hasChanged(this.spsNumber, Integer.parseInt(this.editComponent.getSpsNumberField().getText()))) {
                this.spsNumber = Integer.parseInt(this.editComponent.getSpsNumberField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.hasChanged(this.resolutionSize, Integer.parseInt(this.editComponent.getResolutionSizeField().getText()))) {
                this.resolutionSize = Integer.parseInt(this.editComponent.getResolutionSizeField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.hasChanged(this.collectionID, Integer.parseInt(this.editComponent.getCollectionIDField().getText()))) {
                this.collectionID = Integer.parseInt(this.editComponent.getCollectionIDField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = ImageFile.getMediaTypeToInt((String)this.editComponent.getMediaTypeComboBox().getSelectedItem());
        String string = (String)this.editComponent.getFormatComboBox().getSelectedItem();
        if (this.hasChanged(this.mediaType, n)) {
            this.mediaType = n;
        }
        if (this.hasChanged(this.format, string)) {
            this.format = string;
        }
        if (this.hasChanged(this.url, this.editComponent.getUrlField().getText())) {
            this.url = this.editComponent.getUrlField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CcSpsData.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit SPS Data";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-user-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.spsNumber + "-" + this.resolutionSize + "-" + this.collectionID + "-" + this.mediaType + "-" + this.format;
    }

    public String getOriginalUniqueIdentifier() {
        return "" + this.originalSpsNumber + "-" + this.originalResolutionSize + "-" + this.originalCollectionID + "-" + this.originalMediaType + "-" + this.originalFormat;
    }

    public boolean equals(Object object) {
        if (object instanceof CcSpsData) {
            CcSpsData ccSpsData = (CcSpsData)object;
            return this.getUniqueIdentifier().equals(ccSpsData.getUniqueIdentifier());
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcSpsData) {
            CcSpsData ccSpsData = (CcSpsData)databaseRecord;
            return this.spsNumber == ccSpsData.spsNumber && this.resolutionSize == ccSpsData.resolutionSize && this.collectionID == ccSpsData.collectionID && this.mediaType == ccSpsData.mediaType && CcSpsData.stringsAreEqual(this.format, ccSpsData.format) && CcSpsData.stringsAreEqual(this.url, ccSpsData.url);
        }
        return false;
    }
}

