/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.VerticalStackResizeWidthLayout;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingEditComponent;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecord;
import com.luna.insight.admin.manytomanymap.ManyToManyMapController;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.server.Debug;
import com.luna.insight.server.FieldValue;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CcObjectRecordThumbnail
extends MappedThumbnail
implements PopupMenuListener,
ActionListener {
    public static final Border UNSELECTED_BORDER = BorderFactory.createMatteBorder(1, 1, 1, 0, Color.gray);
    public static final Color UNSELECTED_TEXT_COLOR = Color.black;
    public static Font UNSELECTED_FONT = new Font("Dialog", 0, 12);
    public static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.white, 1);
    public static final Color SELECTED_BKG_COLOR = Color.blue;
    public static final Color SELECTED_TEXT_COLOR = Color.white;
    public static Font SELECTED_FONT = new Font("Dialog", 1, 12);
    public static final Border ANCHOR_BORDER = BorderFactory.createLineBorder(Color.white, 1);
    public static final Color ANCHOR_BKG_COLOR = Color.red;
    public static final Color ANCHOR_TEXT_COLOR = Color.white;
    public static final Border RIGHT_CLICK_BORDER = BorderFactory.createLineBorder(MetalLookAndFeel.getPrimaryControl(), 1);
    public static final String COMMAND_VIEW_ALL_DATA = "command-view-all-data";
    protected CcObjectRecord objectRecord;
    protected List fieldValueLabels = new Vector();
    protected boolean isSelected = false;
    protected boolean isAnchor = false;
    protected boolean isRightClicked = false;

    public static void debugOut(String string) {
        CcObjectRecordThumbnail.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcObjectRecordThumbnail: " + string, n);
    }

    public CcObjectRecordThumbnail(ManyToManyMapController manyToManyMapController, CcObjectRecord ccObjectRecord) {
        super(manyToManyMapController);
        this.objectRecord = ccObjectRecord;
        this.setLayout(new VerticalStackResizeWidthLayout(2));
        this.addFieldValueLabels();
        this.setSize(this.getPreferredSize());
        this.setToolTipText("" + this.getObjectID());
        this.drawSelected();
    }

    public boolean equals(Object object) {
        if (object instanceof CcObjectRecordThumbnail) {
            CcObjectRecordThumbnail ccObjectRecordThumbnail = (CcObjectRecordThumbnail)object;
            return this.mapObjectEquals(ccObjectRecordThumbnail.getMapObject());
        }
        return object == this;
    }

    public long getObjectID() {
        return this.objectRecord.getObjectID();
    }

    public CcObjectRecord getObjectRecord() {
        return this.objectRecord;
    }

    public String toString() {
        return "Object " + this.objectRecord.getObjectID() + "";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CcObjectRecordThumbnail.debugOut("Received command: " + string);
        if (string.equals(COMMAND_VIEW_ALL_DATA)) {
            ((CcObjectMediaMappingEditComponent)this.controller).showThumbnailDetails(this);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if ((mouseEvent.getModifiers() & 4) == 4) {
                JPopupMenu jPopupMenu = this.getContextMenu();
                if (jPopupMenu != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                super.mousePressed(mouseEvent);
            }
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.isRightClicked = true;
        this.drawSelected();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.isRightClicked = false;
        this.drawSelected();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.isRightClicked = false;
        this.drawSelected();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void select(boolean bl, boolean bl2) {
        this.isSelected = bl;
        this.isAnchor = bl2;
        this.drawSelected();
    }

    public Object getMapObject() {
        return this.getObjectRecord();
    }

    public boolean mapObjectEquals(Object object) {
        return this.objectRecord.equals(object);
    }

    protected JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.addPopupMenuListener(this);
        jPopupMenu.add(((CcObjectMediaMappingEditComponent)this.controller).getServerNode().getAdminAccount().createPermittedServerMenuItem("View all data", COMMAND_VIEW_ALL_DATA, this));
        return jPopupMenu;
    }

    protected void addFieldValueLabels() {
        this.removeAll();
        this.fieldValueLabels.clear();
        FieldValue[] fieldValueArray = this.objectRecord.getFieldValues();
        boolean bl = true;
        for (int i = 0; i < fieldValueArray.length; ++i) {
            if (fieldValueArray[i].value == null || fieldValueArray[i].value.length() <= 0) continue;
            bl = false;
            break;
        }
        int n = new JLabel((String)"BLAH").getPreferredSize().height;
        if (bl) {
            JLabel jLabel = new JLabel("No data for object " + this.objectRecord.getObjectID() + ".");
            jLabel.setFont(UNSELECTED_FONT);
            jLabel.setSize(jLabel.getPreferredSize().width, n * 2);
            jLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
            jLabel.setHorizontalAlignment(2);
            jLabel.setVerticalAlignment(0);
            this.add(jLabel);
            this.fieldValueLabels.add(jLabel);
        } else {
            for (int i = 0; i < fieldValueArray.length; ++i) {
                FieldValue fieldValue = fieldValueArray[i];
                JLabel jLabel = new JLabel(fieldValue.value);
                if (i == 0) {
                    jLabel.setBorder(new EmptyBorder(2, 2, 0, 2));
                } else if (i == fieldValueArray.length - 1) {
                    jLabel.setBorder(new EmptyBorder(0, 2, 2, 2));
                } else {
                    jLabel.setBorder(new EmptyBorder(0, 2, 0, 2));
                }
                jLabel.setFont(UNSELECTED_FONT);
                jLabel.setSize(jLabel.getPreferredSize().width, n);
                this.add(jLabel);
                this.fieldValueLabels.add(jLabel);
            }
        }
    }

    protected void adjustLabelFontsAndColors() {
        Font font;
        Font font2 = font = this.isSelected ? SELECTED_FONT : UNSELECTED_FONT;
        Color color = this.isSelected ? (this.isAnchor ? ANCHOR_TEXT_COLOR : SELECTED_TEXT_COLOR) : UNSELECTED_TEXT_COLOR;
        for (int i = 0; i < this.fieldValueLabels.size(); ++i) {
            JLabel jLabel = (JLabel)this.fieldValueLabels.get(i);
            jLabel.setFont(font);
            jLabel.setForeground(color);
        }
    }

    protected void drawSelected() {
        if (this.isRightClicked) {
            this.setBorder(RIGHT_CLICK_BORDER);
        } else if (this.isSelected) {
            if (this.isAnchor) {
                this.setBorder(ANCHOR_BORDER);
                this.setBackground(ANCHOR_BKG_COLOR);
                this.setOpaque(true);
            } else {
                this.setBorder(SELECTED_BORDER);
                this.setBackground(SELECTED_BKG_COLOR);
                this.setOpaque(true);
            }
        } else {
            this.setBorder(UNSELECTED_BORDER);
            this.setOpaque(false);
        }
        this.adjustLabelFontsAndColors();
        this.repaint();
    }
}

