/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecord;
import com.luna.insight.server.Debug;
import com.luna.insight.server.Field;
import com.luna.insight.server.FieldValue;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.TrinityConnector;
import java.util.ArrayList;
import java.util.List;

public class CcObjectRecord
implements DatabaseRecord,
Comparable {
    public static final int MAXIMUM_SORT_FIELD_LENGTH = 30;
    protected long objectID = 0L;
    protected FieldValue[] fieldValues;
    protected String sortStr = null;

    public static void debugOut(String string) {
        CcObjectRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcObjectRecord: " + string, n);
    }

    public CcObjectRecord(long l) {
        this.objectID = l;
    }

    public long getObjectID() {
        return this.objectID;
    }

    public FieldValue[] getFieldValues() {
        return this.fieldValues;
    }

    public void setFields(Field[] fieldArray) {
        this.fieldValues = new FieldValue[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            this.fieldValues[i] = new FieldValue(fieldArray[i], "");
        }
        this.sortStr = null;
    }

    public void setFieldValue(int n, String string) {
        List list = this.getFieldValues(n);
        for (int i = 0; i < list.size(); ++i) {
            ((FieldValue)list.get((int)i)).value = string;
            this.sortStr = null;
        }
    }

    public List getFieldValues(int n) {
        ArrayList<FieldValue> arrayList = new ArrayList<FieldValue>();
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].field.fieldID != n) continue;
            arrayList.add(this.fieldValues[i]);
        }
        return arrayList;
    }

    public FieldValue getFieldValue(int n) {
        FieldValue fieldValue = null;
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].field.fieldID != n) continue;
            fieldValue = this.fieldValues[i];
            break;
        }
        return fieldValue;
    }

    public boolean contains(int n, String string) {
        FieldValue fieldValue = this.getFieldValue(n);
        if (fieldValue != null) {
            return InsightUtilities.indexOf(fieldValue.value, string) > -1;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseRecord) {
            return this.equalsRecord((DatabaseRecord)object);
        }
        return super.equals(object);
    }

    public String getSortString() {
        if (this.sortStr == null || this.sortStr.length() == 0) {
            this.sortStr = "";
            for (int i = 0; i < this.fieldValues.length; ++i) {
                this.sortStr = this.sortStr + TrinityConnector.convertSortValue(this.fieldValues[i].value, 30);
            }
        }
        return this.sortStr;
    }

    public int compareTo(Object object) {
        if (object instanceof CcObjectRecord) {
            return this.getComparableValue().compareTo(((CcObjectRecord)object).getComparableValue());
        }
        return this.getComparableValue().compareTo(((CcMediaRecord)object).getComparableValue());
    }

    public String getComparableValue() {
        return "ObjectRecord-" + this.getObjectID();
    }

    public int getIndex() {
        return (int)this.objectID;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcObjectRecord) {
            CcObjectRecord ccObjectRecord = (CcObjectRecord)databaseRecord;
            return this.getObjectID() == ccObjectRecord.getObjectID();
        }
        return false;
    }
}

