/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecordThumbnail;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaThumbnailLoadManager;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.net.URL;
import javax.swing.ImageIcon;

public class CcMediaThumbnailLoader
extends Thread {
    protected CcMediaThumbnailLoadManager loadManager;
    protected boolean stillNeeded = true;

    public static void debugOut(String string) {
        CcMediaThumbnailLoader.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaThumbnailLoader: " + string, n);
    }

    public static ImageIcon getImage(String string) {
        ImageIcon imageIcon = null;
        if (string != null && string.length() > 0) {
            URL uRL = InsightUtilities.getUrl(string);
            if (uRL == null) {
                CcMediaThumbnailLoader.debugOut("Malformed URL: " + string);
            }
            try {
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                CcMediaThumbnailLoader.debugOut("Exception creating image at " + string + ": " + InsightUtilities.getStackTrace(exception));
            }
        } else {
            CcMediaThumbnailLoader.debugOut("Image URL is not defined.");
        }
        return imageIcon;
    }

    public CcMediaThumbnailLoader(CcMediaThumbnailLoadManager ccMediaThumbnailLoadManager) {
        this.loadManager = ccMediaThumbnailLoadManager;
    }

    public void setStillNeeded(boolean bl) {
        this.stillNeeded = bl;
    }

    public void run() {
        while (this.stillNeeded) {
            try {
                if (this.loadManager.getThumbnailsToLoadCount() > 0) {
                    this.loadThumbnail(this.loadManager.getNextThumbToLoad());
                }
                CcMediaThumbnailLoader.sleep(100L);
            }
            catch (Exception exception) {
                CcMediaThumbnailLoader.debugOut("Exception in run():\n" + InsightUtilities.getStackTrace(exception));
            }
        }
    }

    protected void loadThumbnail(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        if (ccMediaRecordThumbnail != null && ccMediaRecordThumbnail.startLoading()) {
            ImageIcon imageIcon = null;
            String string = ccMediaRecordThumbnail.getImageUrl();
            if (this.stillNeeded) {
                if (string != null && string.length() > 0) {
                    imageIcon = CcMediaThumbnailLoader.getImage(string);
                } else {
                    CcMediaThumbnailLoader.debugOut("Image URL is not defined for thumbnail image ID: " + ccMediaRecordThumbnail.getImageID());
                }
            }
            if (this.stillNeeded) {
                ccMediaRecordThumbnail.setThumbnailImage(imageIcon);
                this.loadManager.thumbnailLoadComplete(ccMediaRecordThumbnail);
            }
        }
    }
}

