/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecordThumbnail;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaThumbnailLoader;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CcMediaThumbnailLoadManager {
    public static final int THUMB_LOADER_THREADS = 5;
    public static final long THREAD_TIMEOUT = 100L;
    protected List thumbnailsToLoad = new ArrayList();
    protected List thumbnailLoaders = new Vector(5);
    protected boolean stillNeeded = true;
    protected Object lockObj = new Object();

    public static void debugOut(String string) {
        CcMediaThumbnailLoadManager.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaThumbnailLoadManager: " + string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThumbnail(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        Object object = this.lockObj;
        synchronized (object) {
            if (ccMediaRecordThumbnail != null && !ccMediaRecordThumbnail.isLoadStarted() && !this.containsThumbnail(ccMediaRecordThumbnail)) {
                this.thumbnailsToLoad.add(ccMediaRecordThumbnail);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeThumbnail(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        boolean bl = false;
        Object object = this.lockObj;
        synchronized (object) {
            int n;
            if (ccMediaRecordThumbnail != null && (n = this.getThumbnailIndex(ccMediaRecordThumbnail)) > -1) {
                this.thumbnailsToLoad.remove(n);
                bl = true;
            }
        }
        return bl;
    }

    public void thumbnailLoadComplete(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        this.removeThumbnail(ccMediaRecordThumbnail);
    }

    public int getThumbnailsToLoadCount() {
        return this.thumbnailsToLoad.size();
    }

    public void start() {
        for (int i = 0; i < 5; ++i) {
            CcMediaThumbnailLoader ccMediaThumbnailLoader = new CcMediaThumbnailLoader(this);
            ccMediaThumbnailLoader.start();
            this.thumbnailLoaders.add(ccMediaThumbnailLoader);
        }
    }

    public void setStillNeeded(boolean bl) {
        this.stillNeeded = bl;
        for (int i = 0; i < this.thumbnailLoaders.size(); ++i) {
            ((CcMediaThumbnailLoader)this.thumbnailLoaders.get(i)).setStillNeeded(bl);
        }
    }

    protected CcMediaRecordThumbnail getNextThumbToLoad() {
        CcMediaRecordThumbnail ccMediaRecordThumbnail = null;
        try {
            for (int i = 0; i < this.thumbnailsToLoad.size(); ++i) {
                CcMediaRecordThumbnail ccMediaRecordThumbnail2 = (CcMediaRecordThumbnail)this.thumbnailsToLoad.get(i);
                if (ccMediaRecordThumbnail2.isLoadStarted()) continue;
                ccMediaRecordThumbnail = ccMediaRecordThumbnail2;
                break;
            }
        }
        catch (Exception exception) {
            CcMediaThumbnailLoadManager.debugOut("Exception in getNextThumbToLoad():\n" + InsightUtilities.getStackTrace(exception));
        }
        return ccMediaRecordThumbnail;
    }

    protected boolean containsThumbnail(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        return this.getThumbnailIndex(ccMediaRecordThumbnail) > -1;
    }

    protected int getThumbnailIndex(CcMediaRecordThumbnail ccMediaRecordThumbnail) {
        int n = -1;
        for (int i = 0; i < this.thumbnailsToLoad.size(); ++i) {
            if (this.thumbnailsToLoad.get(i) != ccMediaRecordThumbnail) continue;
            n = i;
            break;
        }
        return n;
    }
}

