/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.objectmediamap.CcMediaRecord;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectMediaMappingEditComponent;
import com.luna.insight.admin.manytomanymap.ManyToManyMapController;
import com.luna.insight.admin.manytomanymap.MappedThumbnail;
import com.luna.insight.server.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CcMediaRecordThumbnail
extends MappedThumbnail
implements PopupMenuListener,
ActionListener {
    public static final Border UNSELECTED_BORDER = BorderFactory.createLineBorder(Color.gray, 1);
    public static final Border SELECTED_BORDER = BorderFactory.createLineBorder(Color.white, 1);
    public static final Color SELECTED_BKG_COLOR = Color.blue;
    public static final Color SELECTED_LENS_COLOR = new Color(0, 0, 255, 100);
    public static final Border ANCHOR_BORDER = BorderFactory.createLineBorder(Color.white, 1);
    public static final Color ANCHOR_BKG_COLOR = Color.red;
    public static final Color ANCHOR_LENS_COLOR = new Color(255, 0, 0, 100);
    public static final Border RIGHT_CLICK_BORDER = BorderFactory.createLineBorder(MetalLookAndFeel.getPrimaryControl(), 1);
    public static final String COMMAND_VIEW_LARGER_IMAGE = "command-view-larger-image";
    public static final String COMMAND_DELETE_IMAGE = "command-delete-image";
    protected CcObjectMediaMappingEditComponent objImgMappingController;
    protected CcMediaRecord imageRecord;
    protected JLabel thumbnail;
    protected JPanel coloredLens;
    protected boolean isSelected = false;
    protected boolean isAnchor = false;
    protected boolean isRightClicked = false;
    protected boolean startedLoading = false;

    public static void debugOut(String string) {
        CcMediaRecordThumbnail.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaRecordThumbnail: " + string, n);
    }

    public CcMediaRecordThumbnail(ManyToManyMapController manyToManyMapController, CcMediaRecord ccMediaRecord) {
        super(manyToManyMapController);
        this.objImgMappingController = (CcObjectMediaMappingEditComponent)manyToManyMapController;
        this.imageRecord = ccMediaRecord;
        this.setLayout(null);
        this.setSize(96, 96);
        this.setMaximumSize(this.getSize());
        this.setMinimumSize(this.getSize());
        this.setPreferredSize(this.getSize());
        this.coloredLens = new JPanel();
        this.coloredLens.setOpaque(false);
        this.add((Component)this.coloredLens, "Center");
        this.thumbnail = new JLabel(ccMediaRecord.getImageFilename());
        this.thumbnail.setVerticalAlignment(0);
        this.thumbnail.setHorizontalAlignment(0);
        this.add((Component)this.thumbnail, "Center");
        this.setToolTipText("" + this.getImageID());
        this.drawSelected();
    }

    public void doLayout() {
        Insets insets = this.getInsets();
        int n = this.getWidth() - insets.left - insets.right;
        int n2 = this.getHeight() - insets.top - insets.bottom;
        this.coloredLens.setBounds(insets.left, insets.top, n, n2);
        this.thumbnail.setBounds(insets.left, insets.top, n, n2);
        this.thumbnail.doLayout();
    }

    public long getImageID() {
        return this.imageRecord.getImageID();
    }

    public String getImageUrl() {
        return this.imageRecord.getImageUrl();
    }

    public CcMediaRecord getImageRecord() {
        return this.imageRecord;
    }

    public String toString() {
        return "Medium " + this.getImageID() + "";
    }

    public boolean isLoadStarted() {
        return this.startedLoading;
    }

    public synchronized boolean startLoading() {
        if (!this.isLoadStarted()) {
            this.startedLoading = true;
            return true;
        }
        return false;
    }

    public void stopLoading() {
        this.startedLoading = true;
    }

    public void addNotify() {
        super.addNotify();
        if (!this.isLoadStarted()) {
            this.objImgMappingController.getLoadManager().addThumbnail(this);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.objImgMappingController.getLoadManager().removeThumbnail(this);
        if (this.objImgMappingController.flushThumbnails()) {
            this.flush();
        }
    }

    public void setThumbnailImage(ImageIcon imageIcon) {
        if (imageIcon != null && imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
            this.thumbnail.setText("");
            this.thumbnail.setIcon(imageIcon);
        }
        this.repaint();
    }

    public ImageIcon getThumbnailImage() {
        return (ImageIcon)this.thumbnail.getIcon();
    }

    public Image getImageObject() {
        ImageIcon imageIcon = this.getThumbnailImage();
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public void flushImage() {
        Image image = this.getImageObject();
        if (image != null && image != InsightAdministrator.NO_IMAGE.getImage()) {
            image.flush();
        }
    }

    public void flush() {
        this.flushImage();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CcMediaRecordThumbnail.debugOut("Received command: " + string);
        if (string.equals(COMMAND_VIEW_LARGER_IMAGE)) {
            ((CcObjectMediaMappingEditComponent)this.controller).showThumbnailDetails(this);
        } else if (string.equals(COMMAND_DELETE_IMAGE)) {
            ((CcObjectMediaMappingEditComponent)this.controller).deleteImageRecord(this);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this) {
            if ((mouseEvent.getModifiers() & 4) == 4) {
                JPopupMenu jPopupMenu = this.getContextMenu();
                if (jPopupMenu != null) {
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            } else {
                super.mousePressed(mouseEvent);
            }
        }
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.isRightClicked = true;
        this.drawSelected();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.isRightClicked = false;
        this.drawSelected();
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.isRightClicked = false;
        this.drawSelected();
    }

    public boolean isAnchor() {
        return this.isAnchor;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void select(boolean bl, boolean bl2) {
        this.isSelected = bl;
        this.isAnchor = bl2;
        this.drawSelected();
    }

    public Object getMapObject() {
        return this.getImageRecord();
    }

    public boolean mapObjectEquals(Object object) {
        return this.imageRecord.equals(object);
    }

    protected JPopupMenu getContextMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.addPopupMenuListener(this);
        JMenuItem jMenuItem = ((CcObjectMediaMappingEditComponent)this.controller).getServerNode().getAdminAccount().createPermittedServerMenuItem("View larger image", COMMAND_VIEW_LARGER_IMAGE, this);
        jPopupMenu.add(jMenuItem);
        jMenuItem.setEnabled(this.imageRecord.getMediaType() == 1);
        jMenuItem = ((CcObjectMediaMappingEditComponent)this.controller).getServerNode().getAdminAccount().createPermittedServerMenuItem("Delete medium", COMMAND_DELETE_IMAGE, this);
        jPopupMenu.add(jMenuItem);
        jMenuItem.setEnabled(this.imageRecord.getMediaBatch() != null);
        return jPopupMenu;
    }

    protected void drawSelected() {
        if (this.isRightClicked) {
            this.setBorder(RIGHT_CLICK_BORDER);
        } else if (this.isSelected) {
            if (this.isAnchor) {
                this.setBorder(ANCHOR_BORDER);
                this.setBackground(ANCHOR_BKG_COLOR);
                this.setOpaque(true);
                this.coloredLens.setBackground(ANCHOR_LENS_COLOR);
                this.coloredLens.setOpaque(true);
            } else {
                this.setBorder(SELECTED_BORDER);
                this.setBackground(SELECTED_BKG_COLOR);
                this.setOpaque(true);
                this.coloredLens.setBackground(SELECTED_LENS_COLOR);
                this.coloredLens.setOpaque(true);
            }
        } else {
            this.setBorder(UNSELECTED_BORDER);
            this.setOpaque(false);
            this.coloredLens.setOpaque(false);
        }
        this.repaint();
    }
}

