/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.objectmediamap;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.objectmediamap.CcObjectRecord;
import com.luna.insight.server.Debug;

public class CcMediaRecord
implements DatabaseRecord,
Comparable {
    protected long imageID = 0L;
    protected int mediaType = 1;
    protected String imageUrl = "";
    protected String imageFilename = "";
    protected CcMediaBatch mediaBatch = null;

    public static void debugOut(String string) {
        CcMediaRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaRecord: " + string, n);
    }

    public CcMediaRecord(long l) {
        this.imageID = l;
    }

    public long getImageID() {
        return this.imageID;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getImageFilename() {
        return this.imageFilename;
    }

    public CcMediaBatch getMediaBatch() {
        return this.mediaBatch;
    }

    public boolean isRecordComplete() {
        return this.imageUrl != null && this.imageUrl.length() > 0 && this.imageFilename != null && this.imageFilename.length() > 0;
    }

    public void setMediaType(int n) {
        this.mediaType = n;
    }

    public void setImageUrl(String string) {
        this.imageUrl = string;
    }

    public void setImageFilename(String string) {
        this.imageFilename = string;
    }

    public void setMediaBatch(CcMediaBatch ccMediaBatch) {
        this.mediaBatch = ccMediaBatch;
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseRecord) {
            return this.equalsRecord((DatabaseRecord)object);
        }
        return super.equals(object);
    }

    public int compareTo(Object object) {
        if (object instanceof CcMediaRecord) {
            return this.getComparableValue().compareTo(((CcMediaRecord)object).getComparableValue());
        }
        return this.getComparableValue().compareTo(((CcObjectRecord)object).getComparableValue());
    }

    public String getComparableValue() {
        return "ImageRecord-" + this.getImageID();
    }

    public int getIndex() {
        return (int)this.imageID;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMediaRecord) {
            CcMediaRecord ccMediaRecord = (CcMediaRecord)databaseRecord;
            return this.getImageID() == ccMediaRecord.getImageID();
        }
        return false;
    }
}

