/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mpd;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.mpd.CsMpdEditComponent;
import com.luna.insight.admin.collserver.table.CsTableInfo;
import com.luna.insight.admin.verifier.NonEmptyJTextComponentVerifier;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CsMpd
extends EditableDataObject
implements DatabaseRecord,
DocumentListener {
    private Integer uniqueCollectionID = null;
    private Collection collection = null;
    private String documentName = "";
    private int documentId = 0;
    private int targetGroupId = 0;
    private int identityFieldId = 0;
    private String identityValue = "";
    private String[] levelNames = null;
    private int[] levelFieldIds = null;
    private Vector levelInfo = new Vector();
    private Vector groupList = new Vector();
    private Vector fieldList = new Vector();
    private Vector levelfieldList = new Vector();
    private CsMpdEditComponent editComponent = null;

    public CsMpd(Integer n, Collection collection, String string, int n2, int n3, int n4, String string2, String[] stringArray, int[] nArray, Vector vector, Vector vector2, Vector vector3) {
        this.uniqueCollectionID = n;
        this.collection = collection;
        this.documentName = string;
        this.documentId = n2;
        this.targetGroupId = n3;
        this.identityFieldId = n4;
        this.identityValue = string2;
        this.levelNames = stringArray;
        this.levelFieldIds = nArray;
        this.levelInfo = vector;
        this.groupList = vector2;
        this.fieldList = vector3;
    }

    public CsMpd(Integer n, int n2, Collection collection, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this.uniqueCollectionID = n;
        this.collection = collection;
        this.documentId = n2;
        this.levelInfo = vector;
        this.groupList = vector2;
        this.fieldList = vector3;
        this.levelfieldList = vector4;
        this.levelNames = new String[vector.size()];
        this.levelFieldIds = new int[vector.size()];
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public EditComponent getEditComponent() {
        int n;
        int n2;
        int n3;
        int n4;
        this.editComponent = new CsMpdEditComponent(this.fieldList, this.levelfieldList, this.groupList, this.levelInfo, this.targetGroupId);
        this.editComponent.getDocumentName().setText(this.documentName);
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        JTextField jTextField = this.editComponent.getDocumentName();
        jTextField.setInputVerifier(new NonEmptyJTextComponentVerifier());
        if (this.levelNames != null) {
            for (n4 = 0; n4 < this.levelNames.length; ++n4) {
                if (this.levelNames.equals("null")) {
                    jTextFieldArray[n4].setText("");
                    continue;
                }
                jTextFieldArray[n4].setText(this.levelNames[n4]);
            }
        }
        if (this.levelFieldIds != null) {
            block1: for (n4 = 0; n4 < this.levelFieldIds.length; ++n4) {
                n3 = this.levelFieldIds[n4];
                for (n2 = 0; n2 < this.fieldList.size(); ++n2) {
                    if (((CsTableInfo)this.fieldList.elementAt(n2)).getTableId() != n3) continue;
                    jComboBoxArray[n4].setSelectedItem(this.fieldList.elementAt(n2));
                    continue block1;
                }
            }
        }
        JComboBox jComboBox = this.editComponent.getCollectionGroup();
        for (n3 = 0; n3 < this.groupList.size(); ++n3) {
            if (((CsTableInfo)this.groupList.elementAt(n3)).getTableId() != this.targetGroupId) continue;
            jComboBox.setSelectedItem(this.groupList.elementAt(n3));
            break;
        }
        JComboBox jComboBox2 = this.editComponent.getIdentityField();
        for (n2 = 0; n2 < this.fieldList.size(); ++n2) {
            if (((CsTableInfo)this.fieldList.elementAt(n2)).getTableId() != this.identityFieldId) continue;
            jComboBox2.setSelectedItem(this.fieldList.elementAt(n2));
            break;
        }
        JTextField jTextField2 = this.editComponent.getIdentityValue();
        jTextField2.setText(this.identityValue);
        JTextField[] jTextFieldArray2 = this.editComponent.getLevelTextFields();
        for (n = 0; n < jTextFieldArray2.length; ++n) {
            jTextFieldArray2[n].getDocument().addDocumentListener(this);
        }
        for (n = 0; n < jComboBoxArray.length; ++n) {
            jComboBoxArray[n].setEnabled(jTextFieldArray[n].getText().length() > 0);
        }
        return this.editComponent;
    }

    public void save() {
        int n;
        CsTableInfo csTableInfo;
        CsTableInfo csTableInfo2;
        boolean bl = true;
        boolean bl2 = true;
        String string = null;
        this.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.documentName, this.editComponent.getDocumentName().getText())) {
            this.documentName = this.editComponent.getDocumentName().getText();
        }
        if (this.hasChanged(this.targetGroupId, (csTableInfo2 = (CsTableInfo)this.editComponent.getCollectionGroup().getSelectedItem()).getTableId())) {
            this.targetGroupId = csTableInfo2.getTableId();
        }
        if (this.hasChanged(this.identityFieldId, (csTableInfo = (CsTableInfo)this.editComponent.getIdentityField().getSelectedItem()).getTableId())) {
            this.identityFieldId = csTableInfo.getTableId();
        }
        if (this.hasChanged(this.identityValue, this.editComponent.getIdentityValue().getText())) {
            this.identityValue = this.editComponent.getIdentityValue().getText();
        }
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        if (this.levelFieldIds != null) {
            for (n = 0; n < jComboBoxArray.length; ++n) {
                if (!this.hasChanged(this.levelFieldIds[n], ((CsTableInfo)jComboBoxArray[n].getSelectedItem()).getTableId())) continue;
                this.levelFieldIds[n] = ((CsTableInfo)jComboBoxArray[n].getSelectedItem()).getTableId();
            }
        }
        if (this.levelNames != null) {
            for (n = 0; n < this.levelNames.length; ++n) {
                string = "";
                if (this.hasChanged(this.levelNames[n], jTextFieldArray[n].getText())) {
                    string = jTextFieldArray[n].getText().trim();
                }
                if (string == null || string.length() <= 0) continue;
                this.levelNames[n] = string;
                bl = false;
            }
        }
        if (bl) {
            JOptionPane.showMessageDialog(null, "At least one level definition is required.\nLevel definition should start from Level 1", "Template Validation Warning", 0);
            bl2 = false;
        }
        if (!bl && this.levelNames[0] == null) {
            JOptionPane.showMessageDialog(null, "Level definition should start from Level 1", "Template Validation Warning", 0);
            bl2 = false;
        }
        if (bl2) {
            this.collection.getServer().commitDataObject(this);
        } else {
            this.collection.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        this.editComponent = null;
        this.collection.getServer().cancelEdit(this);
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-mpd-node-icon.gif");
    }

    public int getIndex() {
        return this.documentId;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        boolean bl = true;
        if (databaseRecord instanceof CsMpd) {
            CsMpd csMpd = (CsMpd)databaseRecord;
            if (!CsMpd.stringsAreEqual(this.documentName, csMpd.getDocumentName())) {
                bl = false;
            }
            if (this.targetGroupId != csMpd.getTargetGroupId()) {
                bl = false;
            }
            if (this.identityFieldId != csMpd.getIdentityFieldId()) {
                bl = false;
            }
            if (!CsMpd.stringsAreEqual(this.identityValue, csMpd.getIdentityValue())) {
                bl = false;
            }
            String[] stringArray = csMpd.getLevelNames();
            for (int i = 0; i < this.levelNames.length; ++i) {
                if (this.levelNames[i] == null || stringArray[i] == null || this.levelNames[i].equals(stringArray[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public String getEditWindowTitle() {
        return new String("Multi-Page Documents");
    }

    public String toString() {
        return this.documentName;
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        if (this.editComponent != null) {
            for (int i = 0; i < jTextFieldArray.length; ++i) {
                if (documentEvent.getDocument() != jTextFieldArray[i].getDocument()) continue;
                jComboBoxArray[i].setEnabled(jTextFieldArray[i].getText().length() > 0);
            }
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        JTextField[] jTextFieldArray = this.editComponent.getLevelTextFields();
        JComboBox[] jComboBoxArray = this.editComponent.getLevelComboBoxes();
        if (this.editComponent != null) {
            for (int i = 0; i < jTextFieldArray.length; ++i) {
                if (documentEvent.getDocument() != jTextFieldArray[i].getDocument()) continue;
                jComboBoxArray[i].setEnabled(jTextFieldArray[i].getText().length() > 0);
            }
        }
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public int getDocumentId() {
        return this.documentId;
    }

    public int getTargetGroupId() {
        return this.targetGroupId;
    }

    public int getIdentityFieldId() {
        return this.identityFieldId;
    }

    public String getIdentityValue() {
        return this.identityValue;
    }

    public String[] getLevelNames() {
        return this.levelNames;
    }

    public int[] getLevelFieldIds() {
        return this.levelFieldIds;
    }

    public Vector getLevelInfo() {
        return this.levelInfo;
    }

    public Vector getGroupList() {
        return this.groupList;
    }

    public Vector getFieldList() {
        return this.fieldList;
    }

    protected void debugOut(String string, int n) {
        Debug.debugOut("CsMpd: " + string, n);
    }

    protected void debugOut(String string) {
        Debug.debugOut("CsMpd: " + string, 3);
    }
}

