/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.mediacreation.InsightAdminMediaCreationConfigEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class InsightAdminMediaCreationConfig
extends EditableDataObject {
    protected InsightAdministrator insightAdministrator;
    protected int selectedMethod = 1;
    protected InsightAdminMediaCreationConfigEditComponent editComponent = null;

    public InsightAdminMediaCreationConfig(InsightAdministrator insightAdministrator, int n) {
        this.insightAdministrator = insightAdministrator;
        this.selectedMethod = n;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.selectedMethod + "";
    }

    public EditComponent getEditComponent() {
        this.editComponent = new InsightAdminMediaCreationConfigEditComponent();
        this.editComponent.getImageJButton().setText("Use ImageJ");
        this.editComponent.getImageMagickButton().setText("Use JAI and ImageMagick");
        this.editComponent.getExternalToolButton().setText("Use mbconvert utility");
        if (this.selectedMethod == 1) {
            this.editComponent.getImageJButton().setSelected(true);
        } else if (this.selectedMethod == 2) {
            this.editComponent.getExternalToolButton().setSelected(true);
        } else {
            this.editComponent.getImageMagickButton().setSelected(true);
        }
        return this.editComponent;
    }

    public void save() {
        InsightAdminMediaCreationConfig.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.selectedMethod != 0 && this.editComponent.getImageMagickButton().isSelected()) {
            this.insightAdministrator.writeMediaGenerationConfigurationValue(0);
        } else if (this.selectedMethod != 1 && this.editComponent.getImageJButton().isSelected()) {
            this.insightAdministrator.writeMediaGenerationConfigurationValue(1);
        } else if (this.selectedMethod != 2 && this.editComponent.getExternalToolButton().isSelected()) {
            this.insightAdministrator.writeMediaGenerationConfigurationValue(2);
        }
        this.creationCompleted = true;
        this.insightAdministrator.closeMediaGenerationConfigDialog();
    }

    public void cancel() {
        InsightAdminMediaCreationConfig.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.insightAdministrator.closeMediaGenerationConfigDialog();
    }

    public String getEditWindowTitle() {
        return "JPEG Generation";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "0";
    }

    public static void debugOut(String string) {
        InsightAdminMediaCreationConfig.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("InsightAdminMediaCreationConfig: " + string, n);
    }
}

