/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsMediaGroupsNode
extends TableDisplayControlPanelNode {
    protected CollectionNode collectionNode = null;

    public CsMediaGroupsNode(CollectionNode collectionNode) {
        super(collectionNode.getCollection().getServer().getInsightAdministrator(), "Media Groups", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Group Name", "GroupID", "Type", "Parent Group", "Parent VC", "Created", "Modified"};
    }

    public CollectionNode getCollectionNode() {
        return this.collectionNode;
    }

    public void updateInformationDisplay() {
        if (this.tableModel != null) {
            Integer n = this.collectionNode.getCollection().getUniqueCollectionID();
            this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollection().getServer().getMediaGroups(n)), this.columnNames);
        }
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CsMediaGroup csMediaGroup = (CsMediaGroup)vector.elementAt(i);
            objectArray[i][0] = csMediaGroup;
            objectArray[i][1] = new Integer(csMediaGroup.groupID);
            objectArray[i][2] = new Integer(csMediaGroup.groupType);
            objectArray[i][3] = new Integer(csMediaGroup.base);
            objectArray[i][4] = csMediaGroup.vcID;
            objectArray[i][5] = new SimpleDate(csMediaGroup.createdTimestamp).getFull();
            objectArray[i][6] = new SimpleDate(csMediaGroup.lastModifiedTimestamp).getFull();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Media Group Command", this.collectionNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-media-groups-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), "New Media Group Command", "Edit Media Group Command", "Delete Media Group Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Media Group Command")) {
            this.collectionNode.getCollectionServerNode().createNewMediaGroup(this.collectionNode.getCollection().getUniqueCollectionID());
        } else if (string.equals("Delete Media Group Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionNode.getCollectionServerNode().removeMediaGroups(this.collectionNode.getCollection().getUniqueCollectionID(), vector);
            }
        } else if (string.equals("Edit Media Group Command") && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().editMediaGroup((CsMediaGroup)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().editMediaGroup((CsMediaGroup)object);
        }
    }

    public static void debugOut(String string) {
        CsMediaGroupsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsMediaGroupsNode: " + string, n);
    }
}

