/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFile;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroup;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class CsMediaGroupRecordHandler
extends DatabaseRecordHandler {
    public CsMediaGroupRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CsMediaGroupRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CsMediaGroup csMediaGroup = (CsMediaGroup)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "INSERT INTO IRGROUPS (UniqueCollectionID, GroupID, Name, Base, GroupType, VCID, CreatedTimestamp, LastModifiedTimestamp) VALUES (" + csMediaGroup.getUniqueCollectionID() + ", " + csMediaGroup.groupID + ", " + this.prepForInsertQuery(csMediaGroup.groupName) + ", " + this.prepForInsertQuery(csMediaGroup.base + "") + ", " + csMediaGroup.groupType + ", " + this.prepForInsertQuery(csMediaGroup.vcID) + ", " + this.prepForInsertQuery(csMediaGroup.createdTimestamp) + ", " + this.prepForInsertQuery(csMediaGroup.lastModifiedTimestamp) + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertGroupQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            Enumeration enumeration = csMediaGroup.constituentMediaIndices.elements();
            while (enumeration.hasMoreElements()) {
                CsMediaFile csMediaFile = (CsMediaFile)enumeration.nextElement();
                String string2 = "INSERT INTO IRGROUPIMAGEMAP (GroupID, ImageID, MviSeries, MpdSeries, ObjectID, AbsoluteOrder) VALUES (" + csMediaGroup.groupID + ", " + csMediaFile.getMediaID() + ", " + (csMediaFile.isMVI ? 1 : 0) + ", " + (csMediaFile.isMPD ? 1 : 0) + ", " + "0" + ", " + "0" + ")";
                databaseConnector.setQuery(string2);
                this.debugOut("insertGroupImageMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + InsightUtilities.getStackTrace(exception));
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM IRGROUPS WHERE GroupID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteGroupQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            String string2 = "DELETE FROM IRGROUPIMAGEMAP WHERE GroupID = " + databaseRecord.getIndex();
            String string3 = " AND MPDSERIES = 0 AND MVISERIES = 0";
            databaseConnector.setQuery(string2 + string3);
            this.debugOut("deleteGroupImageMappingsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        return this.getRecords(null, -1);
    }

    public Vector getRecords(Integer n) {
        return this.getRecords(n, -1);
    }

    public Vector getRecords(Integer n, int n2) {
        this.debugOut("in getRecords()");
        Vector vector = new Vector();
        try {
            Object object;
            Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRGROUPS", null, "*");
            if (n2 != -1) {
                sqlQueryGenerator.appendToWhere("IRGROUPS.GroupType = " + n2);
            }
            if (n != null) {
                sqlQueryGenerator.appendToWhere("IRGROUPS.UniqueCollectionID = " + n);
            }
            sqlQueryGenerator.addOrderBy("IRGROUPS", "GroupID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Groups query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    object = new CsMediaGroup((CollectionServer)this.serverConnector.getAdministeredServer(), new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID")), databaseConnector.getIntegerFieldByName("GroupID"), databaseConnector.getFieldByName("Name"), databaseConnector.getIntegerFieldByName("Base"), databaseConnector.getIntegerFieldByName("GroupType"), databaseConnector.getFieldByName("VCID"), databaseConnector.getFieldByName("CreatedTimestamp"), databaseConnector.getFieldByName("LastModifiedTimestamp"));
                    hashtable.put(new Integer(((CsMediaGroup)object).getIndex()), object);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CsMediaGroup csMediaGroup = null;
        int n = databaseRecord.getIndex();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRGROUPS", null, "*");
            sqlQueryGenerator.appendToWhere("GroupID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Group query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                csMediaGroup = new CsMediaGroup((CollectionServer)this.serverConnector.getAdministeredServer(), new Integer(databaseConnector.getIntegerFieldByName("UniqueCollectionID")), databaseConnector.getIntegerFieldByName("GroupID"), databaseConnector.getFieldByName("Name"), databaseConnector.getIntegerFieldByName("Base"), databaseConnector.getIntegerFieldByName("GroupType"), databaseConnector.getFieldByName("VCID"), databaseConnector.getFieldByName("CreatedTimestamp"), databaseConnector.getFieldByName("LastModifiedTimestamp"));
                databaseConnector.next();
            }
            databaseConnector.close();
            sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRGROUPIMAGEMAP", null, new String[]{"GroupID", "ImageID", "MVISERIES", "MPDSERIES"});
            sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.GroupID = " + n);
            sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.MPDSERIES = 0");
            sqlQueryGenerator.appendToWhere("IRGROUPIMAGEMAP.MVISERIES = 0");
            sqlQueryGenerator.addOrderBy("IRGROUPIMAGEMAP", "ImageID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Constituent image query is:\n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    csMediaGroup.addConstituentMediaIndex(databaseConnector.getLongField("ImageID"), databaseConnector.getLongField("MVISERIES"), databaseConnector.getLongField("MPDSERIES"));
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return csMediaGroup;
    }

    public String getNextValidIDQuery() {
        return "SELECT GroupID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRGROUPS" + " ORDER BY GroupID";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxIDValue(long l) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRMAXIDS", null, new String[]{"MAXGROUPID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("MAXGROUPID", 0);
            }
            databaseConnector.close();
            if (l > (long)n && n != 0) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MAXGROUPID = " + l);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateMaxIDValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }
}

