/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.ObjectListItemSelector;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFile;
import com.luna.insight.admin.collserver.mediacreation.CsMediaGroupEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.SimpleDate;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;

public class CsMediaGroup
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected Integer uniqueCollectionID;
    protected int groupID;
    protected CollectionServer collectionServer;
    protected String groupName = "";
    protected int base = 0;
    protected int groupType = 3;
    protected String vcID = "NA";
    protected String createdTimestamp = "";
    protected String lastModifiedTimestamp = "";
    protected Vector constituentMediaIndices = new Vector();
    protected CsMediaGroupEditComponent editComponent = null;
    protected ObjectListItemSelector constituentMediaSelector = null;

    public CsMediaGroup(CollectionServer collectionServer, Integer n, int n2, String string, int n3, int n4, String string2, String string3, String string4) {
        this.collectionServer = collectionServer;
        this.uniqueCollectionID = n;
        this.groupID = n2;
        this.groupName = string == null ? "" : string;
        this.base = n3;
        this.groupType = n4;
        this.vcID = string2 == null ? "" : string2;
        String string5 = new SimpleDate().get();
        this.createdTimestamp = string3 == null ? string5 : string3;
        this.lastModifiedTimestamp = string4 == null ? string5 : string4;
    }

    public CsMediaGroup(Integer n, int n2, CollectionServer collectionServer) {
        String string;
        this.groupID = n2;
        this.collectionServer = collectionServer;
        this.uniqueCollectionID = n;
        this.createdTimestamp = string = new SimpleDate().get();
        this.lastModifiedTimestamp = string;
    }

    public void addConstituentMediaIndex(long l, long l2, long l3) {
        CsMediaFile csMediaFile = new CsMediaFile(l, this.collectionServer.getServerNode().getCollectionNode(this.uniqueCollectionID).getCollection(), l2, l3);
        if (!this.constituentMediaIndices.contains(csMediaFile)) {
            this.constituentMediaIndices.addElement(csMediaFile);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.groupName;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public int getIndex() {
        return this.getGroupID();
    }

    public EditComponent getEditComponent() {
        Object object;
        this.editComponent = new CsMediaGroupEditComponent();
        this.editComponent.getNameField().setText(this.groupName);
        this.editComponent.getTypeComboBox().setModel(new DefaultComboBoxModel<String>(new String[]{"Collection Group", "Permanent Group", "Temporary Group"}));
        this.editComponent.getTypeComboBox().setSelectedIndex(this.groupType - 1);
        Vector vector = this.collectionServer.getMediaGroups(this.uniqueCollectionID);
        Vector<CsMediaGroup> vector2 = new Vector<CsMediaGroup>();
        CsMediaGroup csMediaGroup = null;
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (CsMediaGroup)object2.nextElement();
            if (((CsMediaGroup)object).groupType != 2 || this.groupID == ((CsMediaGroup)object).groupID) continue;
            vector2.addElement((CsMediaGroup)object);
            if (((CsMediaGroup)object).groupID != this.base) continue;
            csMediaGroup = object;
        }
        this.editComponent.getBaseComboBox().setModel(new DefaultComboBoxModel(vector2));
        this.editComponent.getBaseComboBox().setSelectedItem(csMediaGroup);
        object2 = this.collectionServer.getConfigurations(this.uniqueCollectionID, false);
        object = new Vector();
        ((Vector)object).addElement("NA");
        String string = null;
        Enumeration enumeration = ((Vector)object2).elements();
        while (enumeration.hasMoreElements()) {
            CollectionServerConfiguration collectionServerConfiguration = (CollectionServerConfiguration)enumeration.nextElement();
            if (collectionServerConfiguration.vcID == null || collectionServerConfiguration.vcID.equals("NA")) continue;
            ((Vector)object).addElement(collectionServerConfiguration.vcID);
            if (!collectionServerConfiguration.vcID.equals(this.vcID)) continue;
            string = collectionServerConfiguration.vcID;
        }
        this.editComponent.getVCIDComboBox().setModel(new DefaultComboBoxModel(object));
        if (string != null) {
            this.editComponent.getVCIDComboBox().setSelectedItem(string);
        } else {
            this.editComponent.getVCIDComboBox().setSelectedIndex(0);
        }
        this.constituentMediaSelector = new ObjectListItemSelector("Available Media:", "Constituent Media:", this.collectionServer.getMediaFiles(this.uniqueCollectionID), this.constituentMediaIndices);
        this.constituentMediaSelector.setMoveAllButtonsVisible(true);
        this.editComponent.getConstituentImageSelectionPanel().add(this.constituentMediaSelector);
        this.editComponent.setEnabledFieldsAppropriately();
        return this.editComponent;
    }

    public void save() {
        CsMediaGroup.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.groupName, this.editComponent.getNameField().getText())) {
            this.groupName = this.editComponent.getNameField().getText();
        }
        if (this.hasChanged(this.groupType, this.editComponent.getTypeComboBox().getSelectedIndex() + 1)) {
            this.groupType = this.editComponent.getTypeComboBox().getSelectedIndex() + 1;
        }
        if (this.groupType == 3) {
            int n = ((CsMediaGroup)this.editComponent.getBaseComboBox().getSelectedItem()).groupID;
            if (this.hasChanged(this.base, n)) {
                this.base = n;
            }
        } else {
            this.base = 0;
        }
        String string = (String)this.editComponent.getVCIDComboBox().getSelectedItem();
        String string2 = "NA";
        if (string != null) {
            string2 = string;
        }
        if (this.hasChanged(this.vcID, string2)) {
            this.vcID = string2;
        }
        if (this.vcID == null || this.vcID.length() == 0) {
            this.vcID = "NA";
            this.requiresCommit = true;
        }
        if (this.hasChanged(this.constituentMediaIndices, this.constituentMediaSelector.getChosenItems())) {
            Vector vector = this.constituentMediaSelector.getChosenItems();
            block0: for (int i = 0; i < vector.size(); ++i) {
                CsMediaFile csMediaFile = (CsMediaFile)vector.elementAt(i);
                for (int j = 0; j < this.constituentMediaIndices.size(); ++j) {
                    CsMediaFile csMediaFile2 = (CsMediaFile)this.constituentMediaIndices.elementAt(j);
                    if (csMediaFile.mediaID != csMediaFile2.mediaID) continue;
                    csMediaFile.isMPD = csMediaFile2.isMPD;
                    csMediaFile.isMVI = csMediaFile2.isMVI;
                    continue block0;
                }
            }
            this.constituentMediaIndices = vector;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.lastModifiedTimestamp = new SimpleDate().get();
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CsMediaGroup.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Media Group - " + this.groupName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-media-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof CsMediaGroup) {
            CsMediaGroup csMediaGroup = (CsMediaGroup)object;
            return this.groupID == csMediaGroup.groupID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CsMediaGroup) {
            CsMediaGroup csMediaGroup = (CsMediaGroup)databaseRecord;
            return this.groupID == csMediaGroup.groupID && CsMediaGroup.stringsAreEqual(this.groupName, csMediaGroup.groupName) && this.base == csMediaGroup.base && this.groupType == csMediaGroup.groupType && CsMediaGroup.stringsAreEqual(this.vcID, csMediaGroup.vcID) && CsMediaGroup.stringsAreEqual(this.createdTimestamp, csMediaGroup.createdTimestamp) && CsMediaGroup.stringsAreEqual(this.lastModifiedTimestamp, csMediaGroup.lastModifiedTimestamp) && this.constituentMediaIndices.containsAll(csMediaGroup.constituentMediaIndices) && csMediaGroup.constituentMediaIndices.containsAll(this.constituentMediaIndices);
        }
        return false;
    }

    public static void debugOut(String string) {
        CsMediaGroup.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsMediaGroup: " + string, n);
    }
}

