/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchProcessListItem;
import com.luna.insight.admin.collserver.mediacreation.CcMediaCreationProgressDisplay;
import com.luna.insight.admin.collserver.mediacreation.CsMediaFile;
import com.luna.insight.admin.collserver.mediacreation.ImageMagickInvoker;
import com.luna.insight.admin.collserver.mediacreation.MBConvertInvoker;
import com.luna.insight.admin.collserver.mediacreation.SidGenerator;
import com.luna.insight.client.media.MediaFileMetadata;
import com.luna.insight.core.jpeg2000.IJPEG2KEncodeParam;
import com.luna.insight.core.jpeg2000.JPEG2KCodec;
import com.luna.insight.core.util.CoreUtilities;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.SimpleDate;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import net.sf.ij.jaiio.JAIReader;

public class CcMediaSourceRecord
extends CcMediaBatchElement {
    public static final int MULTIMEDIA_RESOLUTION = 2;
    public static final String JPEG_EXT = ".jpg";
    public static final String SID_EXT = ".sid";
    public static final String JP2_EXT = ".jp2";
    public static final String PHOTO_CD_EXT = ".pcd";
    public static final String SHORT_TIFF_EXT = ".tif";
    public static final String LONG_TIFF_EXT = ".tiff";
    public static final String TEMP_TIFF_DIRECTORY = "tmp_tiffs";
    private static final int BRIGHTNESS_HIGH = 256;
    private static final int BRIGHTNESS_LOW = -256;
    private static final String MOGRIFY_FILTER = "box";
    public static final int SID_LEVEL_8_MAX = 30000;
    public static final int SID_LEVEL_7_MAX = 12288;
    public static final int SID_LEVEL_6_MAX = 6144;
    public static final int SID_LEVEL_5_MAX = 3072;
    public static final int SID_LEVEL_4_MAX = 1536;
    public static final int SID_LEVEL_3_MAX = 768;
    public static final int SID_LEVEL_2_MAX = 384;
    public static final int SID_LEVEL_1_MAX = 192;
    public static final int SID_LEVEL_0_MAX = 96;
    private static boolean configuredJPEG2KCodec = false;
    protected Collection collection;
    protected List resolutions;
    protected String batchCode;
    protected String sequenceCode;
    protected boolean resampleDuringResize = true;
    protected RenderedOp source = null;
    protected int sourceWidth = 0;
    protected int sourceHeight = 0;
    protected boolean mediaCreationComplete = false;
    protected ImageIcon thumbImage = null;
    protected int resIndex = 0;
    protected String outputFilename = "";
    protected int destWidth = 0;
    protected int destHeight = 0;
    protected Vector mediaFileRecords = new Vector();
    protected Vector writtenFilePaths = new Vector();
    protected boolean jp2GenerationComplete = false;
    protected String jp2Filename = null;
    protected boolean sidGenerationComplete = false;
    protected String sidFilename = null;
    protected boolean preserveFilenames = false;
    protected CcMediaCreationProgressDisplay mediaProgressListener = null;
    int[] pixel = new int[3];

    public static void debugOut(String string) {
        CcMediaSourceRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaSourceRecord: " + string, n);
    }

    public CcMediaSourceRecord(Collection collection, CcMediaBatchProcessListItem ccMediaBatchProcessListItem) {
        super(ccMediaBatchProcessListItem);
        this.collection = collection;
    }

    public CcMediaSourceRecord(Collection collection, CcMediaBatch ccMediaBatch, long l, int n, String string, String string2, long l2, int n2, String string3, String string4, String string5) {
        super(ccMediaBatch, l, n, string, string2, l2, n2, string3, string4, string5);
        this.collection = collection;
    }

    public void setResolutions(List list) {
        this.resolutions = list;
    }

    public void setBatchCode(String string) {
        this.batchCode = string;
    }

    public void setSequenceCode(String string) {
        this.sequenceCode = string;
    }

    public void setResampleDuringResize(boolean bl) {
        this.resampleDuringResize = bl;
    }

    public void setPreserveFilenames(boolean bl) {
        this.preserveFilenames = bl;
    }

    public void setMediaProgressListener(CcMediaCreationProgressDisplay ccMediaCreationProgressDisplay) {
        this.mediaProgressListener = ccMediaCreationProgressDisplay;
    }

    public void setStatusMessage(String string) {
        if (this.mediaProgressListener != null) {
            this.mediaProgressListener.setStatusMessage(string);
        }
    }

    public String getBatchCode() {
        return this.batchCode;
    }

    public String getSequenceCode() {
        return this.sequenceCode;
    }

    public boolean getResampleDuringResize() {
        return this.resampleDuringResize;
    }

    public ImageIcon getThumbnailImage() {
        return this.thumbImage;
    }

    public int getResolutionSize() {
        return this.resIndex;
    }

    public String getDestFilename() {
        return this.outputFilename;
    }

    public int getDestWidth() {
        return this.destWidth;
    }

    public int getDestHeight() {
        return this.destHeight;
    }

    public void flushThumbnailImages() {
        if (this.thumbImage != null && this.thumbImage.getImage() != null) {
            this.thumbImage.getImage().flush();
            this.thumbImage = null;
        }
    }

    public void generateMedia() {
        this.setStatusMessage("Analyzing media type for " + this.getSrcFilename());
        MediaFileMetadata mediaFileMetadata = new MediaFileMetadata(this.getFullSrcFilepath());
        mediaFileMetadata.getMetadata();
        if (mediaFileMetadata.getMediaType() == 1) {
            this.createImages();
        } else {
            this.createMultimedia(mediaFileMetadata);
        }
        if (this.mediaCreationComplete) {
            this.setStatus(1);
            this.setProcessedTimestamp(new SimpleDate().get());
        } else {
            this.setStatus(2);
            this.logLineToFile(new Date() + "- WARNING: Derivative image creation could not be completed.");
        }
        this.setStatusMessage("Writing media records to database.");
        this.commitMediaFileRecords();
        try {
            this.collection.getServer().getCollectionServerConnector().commitRecord(this);
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Batch element " + this.getBatchElementID() + " could not be updated. exc: " + InsightUtilities.getStackTrace(exception));
            this.logLineToFile(new Date() + ": Batch element " + this.getBatchElementID() + " could not be updated. exc: " + InsightUtilities.getStackTrace(exception));
        }
        if (this.source != null) {
            this.source.dispose();
        }
        this.flushThumbnailImages();
    }

    protected void createMultimedia(MediaFileMetadata mediaFileMetadata) {
        StringBuffer stringBuffer = new StringBuffer(new Date() + "- Source: " + this.getSrcFilename());
        String[] stringArray = new String[9];
        try {
            String string;
            int n;
            this.mediaCreationComplete = true;
            CcMediaSourceRecord.debugOut("Generating source file " + this.getSrcFilename() + " as " + mediaFileMetadata.getMediaTypeName() + " media.");
            stringBuffer.append(", processed as " + mediaFileMetadata.getMediaTypeName() + " media");
            stringArray[0] = this.objectKey;
            stringArray[1] = this.getDestMediaID() + "";
            stringArray[2] = "2";
            stringArray[3] = mediaFileMetadata.getFileFormatExtension();
            stringArray[4] = mediaFileMetadata.getMediaType() + "";
            this.destWidth = mediaFileMetadata.getMediaWidth();
            this.destHeight = mediaFileMetadata.getMediaHeight();
            this.resIndex = 2;
            this.outputFilename = this.getSrcFilename();
            if (!this.preserveFilenames) {
                this.outputFilename = this.batchCode + 2 + this.sequenceCode;
                if (this.getSrcFilename().lastIndexOf(46) != -1) {
                    this.outputFilename = this.outputFilename + this.getSrcFilename().substring(this.getSrcFilename().lastIndexOf(46)).toLowerCase();
                }
            }
            if ((n = this.outputFilename.lastIndexOf(46)) != -1) {
                string = this.outputFilename.substring(n).toLowerCase();
                if (string.equals(".mpeg")) {
                    string = ".mpg";
                }
                this.outputFilename = this.outputFilename.substring(0, n) + string;
            }
            string = this.batch.getDestDir() + File.separator + CcBatchProfileResolution.getRelativeDirectoryPath(mediaFileMetadata.getMediaType(), 2, mediaFileMetadata.getMediaFormat()) + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
            stringBuffer.append(", Output dir path: \"" + string + "\"");
            stringBuffer.append(", Output filename: \"" + this.outputFilename + "\"");
            stringArray[5] = this.batchCode;
            stringArray[6] = this.outputFilename;
            stringArray[7] = "0";
            stringArray[8] = "0";
            String string2 = string + File.separator + this.outputFilename;
            CcMediaSourceRecord.debugOut("Output file path: \"" + string2 + "\"");
            stringBuffer.append(", Output file path: \"" + string2 + "\"");
            File file = new File(string);
            file.mkdirs();
            this.setStatusMessage("Copying source " + mediaFileMetadata.getMediaTypeName() + " file to destination.");
            if (CoreUtilities.copyFileBytes(this.getFullSrcFilepath(), string2)) {
                CcMediaSourceRecord.debugOut("Successfully copied file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
                stringBuffer.append(", Successfully copied src file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
                CsMediaFile csMediaFile = new CsMediaFile(this.collection, this.getDestMediaID(), 2, ImageFile.getFormatTypeToString(mediaFileMetadata.getMediaFormat()), mediaFileMetadata.getMediaType(), this.batch.getBatchID(), this.outputFilename, this.destWidth, this.destHeight);
                if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                    csMediaFile.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                }
                this.mediaFileRecords.addElement(csMediaFile);
                this.setStatusMessage("Searching for thumbnail image source file.");
                CcMediaSourceRecord.debugOut("Searching for thumbnail image source file for " + this.getSrcFilename() + ".");
                stringBuffer.append(", searching for thumbnail image source file for " + this.getSrcFilename());
                List list = InsightUtilities.getFilesWithFirstName(this.getFullSrcFilepath(), MediaFileMetadata.NON_IMAGE_FILE_EXTS, true);
                if (list != null && list.size() > 0) {
                    File file2 = (File)list.get(0);
                    this.setStatusMessage("Thumbnail image source file found: " + file2.getName());
                    CcMediaSourceRecord.debugOut("Thumbnail image source file found: " + file2.getName());
                    stringBuffer.append(", thumbnail image source file found: " + file2.getName());
                    this.createImages(file2.getName(), file2.getPath(), mediaFileMetadata.getMediaType(), 1);
                } else {
                    CcMediaSourceRecord.debugOut("Thumbnail image source file not found.");
                    stringBuffer.append(", thumbnail image source file not found");
                    String string3 = this.outputFilename.lastIndexOf(46) != -1 ? this.outputFilename.substring(0, this.outputFilename.lastIndexOf(46)) + JPEG_EXT : this.outputFilename;
                    CsMediaFile csMediaFile2 = new CsMediaFile(this.collection, this.getDestMediaID(), 0, ImageFile.getFormatTypeToString(mediaFileMetadata.getMediaFormat()), mediaFileMetadata.getMediaType(), this.batch.getBatchID(), string3, 0, 0);
                    if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                        csMediaFile2.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                    }
                    this.mediaFileRecords.addElement(csMediaFile2);
                    CsMediaFile csMediaFile3 = new CsMediaFile(this.collection, this.getDestMediaID(), 1, ImageFile.getFormatTypeToString(mediaFileMetadata.getMediaFormat()), mediaFileMetadata.getMediaType(), this.batch.getBatchID(), mediaFileMetadata.getMediaType() == 2 ? this.outputFilename : string3, 0, 0);
                    if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                        csMediaFile3.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                    }
                    this.mediaFileRecords.addElement(csMediaFile3);
                }
            } else {
                this.mediaCreationComplete = false;
                CcMediaSourceRecord.debugOut("Failed to copy src file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
                stringBuffer.append(", Failed to copy src file \"" + this.getFullSrcFilepath() + "\" to \"" + string2 + "\".");
            }
        }
        catch (Exception exception) {
            this.mediaCreationComplete = false;
            CcMediaSourceRecord.debugOut("Exception creating multimedia exc:\n" + InsightUtilities.getStackTrace(exception));
            stringBuffer.append("Exception creating multimedia exc:\n" + InsightUtilities.getStackTrace(exception));
        }
        this.logValuesToFile(stringArray);
    }

    protected void createImages() {
        this.createImages(this.getSrcFilename(), this.getFullSrcFilepath(), 1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void createImages(String var1_1, String var2_2, int var3_3, int var4_4) {
        block139: {
            block160: {
                block158: {
                    block159: {
                        block138: {
                            block134: {
                                block157: {
                                    block135: {
                                        var5_5 = new StringBuffer("");
                                        var6_6 = new String[9];
                                        var6_6[0] = this.objectKey;
                                        var6_6[1] = this.getDestMediaID() + "";
                                        var7_7 = new Vector<String>();
                                        var8_8 = null;
                                        var9_9 = false;
                                        var10_10 = false;
                                        if (this.collection.getServer().getInsightAdministrator().readMediaGenerationConfigurationValue() == 2) {
                                            var9_9 = true;
                                        } else if (this.collection.getServer().getInsightAdministrator().readMediaGenerationConfigurationValue() == 0) {
                                            var10_10 = true;
                                        }
                                        var11_11 = null;
                                        var12_12 = null;
                                        var13_13 = null;
                                        try {
                                            try {
                                                block136: {
                                                    block142: {
                                                        CcMediaSourceRecord.debugOut("------- image \"" + var1_1 + "\"-------");
                                                        var5_5.append(new Date() + "- Source: " + var1_1);
                                                        this.mediaCreationComplete = true;
                                                        if (var9_9 || var10_10) break block142;
                                                        this.source = null;
                                                        try {
                                                            this.setStatusMessage("Loading source file \"" + var1_1 + "\".");
                                                            var14_14 = new Opener();
                                                            var11_11 = var14_14.openImage(var2_2);
                                                            if (var11_11 == null) {
                                                                CcMediaSourceRecord.debugOut("Attempting to use JAI to open the file, ImagePlus Failed");
                                                                try {
                                                                    var15_19 = new File(var2_2);
                                                                    var16_21 = JAIReader.read((File)var15_19);
                                                                    var11_11 = var16_21[0];
                                                                    if (var11_11.getOriginalFileInfo() == null) {
                                                                        var17_22 = var11_11.getFileInfo();
                                                                        var17_22.directory = var15_19.getParent();
                                                                        var17_22.fileName = var15_19.getName();
                                                                        var11_11.setFileInfo((FileInfo)var17_22);
                                                                    }
                                                                }
                                                                catch (Throwable var15_20) {
                                                                    CcMediaSourceRecord.debugOut("JAI Failed too...\n" + InsightUtilities.getStackTrace(var15_20));
                                                                    throw var15_20;
                                                                }
                                                            }
                                                            if (var11_11 == null) {
                                                                CcMediaSourceRecord.debugOut("Unable to load source image: " + var2_2);
                                                                this.logLineToFile(new Date() + "- WARNING: Unable to load image: " + var2_2);
                                                                this.mediaCreationComplete = false;
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (Throwable var14_15) {
                                                            CcMediaSourceRecord.debugOut("Caught exception while loading source image: " + var14_15);
                                                            this.logLineToFile(new Date() + "- WARNING: Caught exception while loading image " + var2_2 + ": " + var14_15);
                                                            if (var11_11 != null) {
                                                                var11_11.flush();
                                                                var11_11 = null;
                                                            }
                                                            System.runFinalization();
                                                            System.gc();
                                                            this.mediaCreationComplete = false;
                                                            var35_25 = null;
                                                            if (var12_12 != null) {
                                                                try {
                                                                    var12_12.close();
                                                                }
                                                                catch (IOException var36_30) {
                                                                    CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var36_30);
                                                                }
                                                                var12_12 = null;
                                                            }
                                                            if (var13_13 == null) return;
                                                            try {
                                                                var13_13.close();
                                                                return;
                                                            }
                                                            catch (IOException var36_30) {
                                                                CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var36_30);
                                                            }
                                                            return;
                                                        }
                                                        var35_24 = null;
                                                        if (var12_12 == null) break block134;
                                                        break block135;
lbl-1000:
                                                        // 1 sources

                                                        {
                                                            var15_19 = var11_11.getProcessor();
                                                            this.sourceWidth = var15_19.getWidth();
                                                            this.sourceHeight = var15_19.getHeight();
                                                            var15_19 = null;
                                                            break block136;
                                                        }
                                                    }
                                                    try {
                                                        if (this.source == null) {
                                                            this.setStatusMessage("Loading source file \"" + var1_1 + "\".");
                                                            this.source = JAI.create((String)"fileload", (Object)var2_2);
                                                            this.sourceWidth = this.source.getWidth();
                                                            this.sourceHeight = this.source.getHeight();
                                                        }
                                                    }
                                                    catch (Exception var14_16) {
                                                        block143: {
                                                            block144: {
                                                                CcMediaSourceRecord.debugOut("Caught exception while loading image: " + InsightUtilities.getStackTrace(var14_16));
                                                                this.logLineToFile(new Date() + "- WARNING: Caught exception while loading image " + var2_2 + ": " + var14_16);
                                                                this.source = null;
                                                                this.mediaCreationComplete = false;
                                                                var35_26 = null;
                                                                if (var12_12 == null) break block143;
                                                                ** try [egrp 15[TRYBLOCK] [24 : 5325->5333)] { 
lbl101:
                                                                // 1 sources

                                                                var12_12.close();
                                                                break block144;
lbl103:
                                                                // 1 sources

                                                                catch (IOException var36_31) {
                                                                    CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var36_31);
                                                                }
                                                            }
                                                            var12_12 = null;
                                                        }
                                                        if (var13_13 == null) return;
                                                        ** try [egrp 16[TRYBLOCK] [25 : 5367->5375)] { 
lbl110:
                                                        // 1 sources

                                                        var13_13.close();
                                                        return;
lbl112:
                                                        // 1 sources

                                                        catch (IOException var36_31) {
                                                            CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var36_31);
                                                        }
                                                        return;
                                                    }
                                                }
                                                var14_14 = var11_11;
                                                this.setStatusMessage("Calculating target resolution sizes.");
                                                var15_19 = CcMediaSourceRecord.determineActualResolutions(this.sourceWidth, this.sourceHeight, this.resolutions);
                                                var16_21 = new Vector<E>();
                                                if (var9_9) {
                                                    CcMediaSourceRecord.debugOut("Generating derivative JPEGs using mbconvert utility.");
                                                    var16_21 = this.createJpegsWithoutJAI(var1_1, var2_2, var3_3, var4_4);
                                                }
                                                var18_34 = true;
                                                var19_35 = var15_19.size() - 1;
                                                if (var4_4 >= 0 && var4_4 < var19_35) {
                                                    var19_35 = var4_4;
                                                }
                                                this.resIndex = var19_35;
                                                while (this.resIndex >= 0) {
                                                    block150: {
                                                        block145: {
                                                            block137: {
                                                                block148: {
                                                                    block149: {
                                                                        block147: {
                                                                            block146: {
                                                                                var17_22 = (CcBatchProfileResolution)var15_19.get(this.resIndex);
                                                                                this.setStatusMessage("Generating derivative image " + this.resIndex + ".");
                                                                                this.destWidth = 0;
                                                                                this.destHeight = 0;
                                                                                if (var17_22 == null) break block145;
                                                                                CcMediaSourceRecord.debugOut("Generating image for resolution level " + this.resIndex + " format " + ImageFile.getFormatTypeToString(var17_22.getFormat()));
                                                                                var5_5 = new StringBuffer(new Date() + "- Source: " + var1_1);
                                                                                var5_5.append(", Resolution: " + this.resIndex);
                                                                                var6_6[2] = this.resIndex + "";
                                                                                this.outputFilename = var1_1;
                                                                                if (this.outputFilename.lastIndexOf(46) != -1) {
                                                                                    this.outputFilename = this.outputFilename.substring(0, this.outputFilename.lastIndexOf(46));
                                                                                }
                                                                                if (!this.preserveFilenames) {
                                                                                    this.outputFilename = this.batchCode + var17_22.getResolutionNumber() + this.sequenceCode;
                                                                                }
                                                                                var20_36 = this.batch.getDestDir() + File.separator + var17_22.getRelativeDirectoryPath(var3_3) + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
                                                                                var5_5.append(", Output path: \"" + var20_36 + "\"");
                                                                                if (var17_22.getFormat() != 0) break block146;
                                                                                this.outputFilename = this.outputFilename + ".jpg";
                                                                                if (!var9_9) {
                                                                                    if (var10_10) {
                                                                                        var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                                        var6_6[3] = "JPEG";
                                                                                        var6_6[4] = "1";
                                                                                        var6_6[5] = this.batchCode;
                                                                                        var6_6[6] = this.outputFilename;
                                                                                        if (var8_8 == null) {
                                                                                            var21_37 = CcBatchProfileResolution.PIXEL_SIZES[4] + 10;
                                                                                            var8_8 = this.getMogrifiedSource(var2_2, var1_1, var21_37);
                                                                                            this.sourceWidth = var8_8.getWidth();
                                                                                            this.sourceHeight = var8_8.getHeight();
                                                                                            var7_7.addElement(this.getTemporaryImageMagickFilename(var1_1));
                                                                                        }
                                                                                        var21_38 = var20_36 + File.separator + this.outputFilename;
                                                                                        var12_12 = null;
                                                                                        try {
                                                                                            var12_12 = new FileOutputStream(var21_38);
                                                                                        }
                                                                                        catch (FileNotFoundException var22_42) {
                                                                                            var23_47 = new File(new File(var21_38).getParent());
                                                                                            var23_47.mkdirs();
                                                                                            var12_12 = new FileOutputStream(var21_38);
                                                                                        }
                                                                                        CcMediaSourceRecord.debugOut("Output file path: \"" + var21_38 + "\"");
                                                                                        var22_43 = var8_8;
                                                                                        if (var17_22.getJpegSettings().automaticTrimEdges) {
                                                                                            var23_48 = var17_22.getJpegSettings().edgeThreshold;
                                                                                            if (var23_48 < 0.0f) {
                                                                                                var23_48 = 0.0f;
                                                                                            }
                                                                                            if ((var24_53 = (float)this.sourceWidth - 2.0f * var23_48) < 0.0f) {
                                                                                                var24_53 = 0.0f;
                                                                                            }
                                                                                            if ((var25_59 = (float)this.sourceHeight - 2.0f * var23_48) < 0.0f) {
                                                                                                var25_59 = 0.0f;
                                                                                            }
                                                                                            var26_65 = new ParameterBlock();
                                                                                            var26_65.addSource(var8_8);
                                                                                            var26_65.add(var23_48);
                                                                                            var26_65.add(var23_48);
                                                                                            var26_65.add(var24_53);
                                                                                            var26_65.add(var25_59);
                                                                                            var5_5.append(", Edge threshold=" + var23_48 + ", crop width=" + var24_53 + ", crop height=" + var25_59);
                                                                                            this.setStatusMessage("Cropping image...");
                                                                                            var22_43 = JAI.create((String)"crop", (ParameterBlock)var26_65, null);
                                                                                        }
                                                                                        this.setStatusMessage("Scaling image...");
                                                                                        var23_50 = this.sourceWidth >= this.sourceHeight ? (float)var17_22.getResolutionPixels() / (float)this.sourceWidth : (float)var17_22.getResolutionPixels() / (float)this.sourceHeight;
                                                                                        CcMediaSourceRecord.debugOut("scale ratio: " + var23_50);
                                                                                        if (var23_50 > 1.0f && !var17_22.getJpegSettings().forceUpsize) {
                                                                                            var23_50 = 1.0f;
                                                                                        }
                                                                                        var5_5.append(", Scale Ratio=" + var23_50);
                                                                                        var24_54 = (int)(1.0f / var23_50) + 1;
                                                                                        var25_60 = var24_54 = (int)((float)var24_54 * 0.75f);
                                                                                        var22_43 = JAI.create((String)"boxfilter", (RenderedImage)var22_43, (int)var24_54, (int)var25_60, (int)(var24_54 / 2), (int)(var25_60 / 2));
                                                                                        var26_65 = new ParameterBlock();
                                                                                        var26_65.addSource(var22_43);
                                                                                        var26_65.add(var23_50);
                                                                                        var26_65.add(var23_50);
                                                                                        var26_65.add(0.0f);
                                                                                        var26_65.add(0.0f);
                                                                                        var26_65.add(Interpolation.getInstance((int)2));
                                                                                        var27_73 = JAI.create((String)"scale", (ParameterBlock)var26_65, null);
                                                                                        var28_77 = null;
                                                                                        if (this.thumbImage == null) {
                                                                                            var28_77 = var27_73.getAsBufferedImage();
                                                                                            this.destWidth = var28_77.getWidth();
                                                                                            this.destHeight = var28_77.getHeight();
                                                                                            var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                                            this.thumbImage = new ImageIcon((Image)var28_77);
                                                                                        } else {
                                                                                            this.destWidth = var27_73.getWidth();
                                                                                            this.destHeight = var27_73.getHeight();
                                                                                        }
                                                                                        var6_6[7] = this.destWidth + "";
                                                                                        var6_6[8] = this.destHeight + "";
                                                                                        var29_80 = var27_73;
                                                                                        if (var17_22.getJpegSettings().useBrightness) {
                                                                                            this.setStatusMessage("Performing gamma correction.");
                                                                                            var30_82 = var17_22.getJpegSettings().brightness;
                                                                                            if (var30_82 > 256) {
                                                                                                var30_82 = 256;
                                                                                            } else if (var30_82 < -256) {
                                                                                                var30_82 = -256;
                                                                                            }
                                                                                            var31_88 = new byte[256];
                                                                                            for (var32_91 = 0; var32_91 < 256; ++var32_91) {
                                                                                                var31_88[var32_91] = this.clampByte(var32_91 + var30_82);
                                                                                            }
                                                                                            var32_92 = new LookupTableJAI(var31_88);
                                                                                            var33_96 = new ParameterBlock();
                                                                                            var33_96.addSource(var27_73);
                                                                                            var33_96.add(var32_92);
                                                                                            var29_80 = JAI.create((String)"lookup", (ParameterBlock)var33_96, null);
                                                                                        }
                                                                                        var30_83 = new com.sun.media.jai.codec.JPEGEncodeParam();
                                                                                        var31_87 = var17_22.getJpegSettings().jpegCompression;
                                                                                        if (var31_87 < 0) {
                                                                                            var31_87 = 0;
                                                                                        } else if (var31_87 > 100) {
                                                                                            var31_87 = 100;
                                                                                        }
                                                                                        var32_93 = 1.0f - (float)var31_87 / 100.0f;
                                                                                        var30_83.setQuality(var32_93);
                                                                                        var5_5.append(", Compression level: " + var31_87 + ", quality level: " + var32_93);
                                                                                        this.setStatusMessage("Writing media file to " + var21_38 + ".");
                                                                                        JAI.create((String)"encode", (RenderedImage)var29_80, (Object)var12_12, (Object)"JPEG", (Object)var30_83);
                                                                                        CcMediaSourceRecord.debugOut("encoded");
                                                                                        this.writtenFilePaths.addElement(var21_38);
                                                                                        CcMediaSourceRecord.debugOut("written");
                                                                                        var22_43 = null;
                                                                                        var27_73 = null;
                                                                                        var29_80 = null;
                                                                                        if (var28_77 != null) {
                                                                                            var28_77.flush();
                                                                                        }
                                                                                        var28_77 = null;
                                                                                        var12_12.close();
                                                                                        var12_12 = null;
                                                                                        break block137;
                                                                                    } else {
                                                                                        var21_39 = null;
                                                                                        var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                                        var6_6[3] = "JPEG";
                                                                                        var6_6[4] = "1";
                                                                                        var6_6[5] = this.batchCode;
                                                                                        var6_6[6] = this.outputFilename;
                                                                                        var22_44 = var20_36 + File.separator + this.outputFilename;
                                                                                        var12_12 = null;
                                                                                        try {
                                                                                            var12_12 = new FileOutputStream(var22_44);
                                                                                        }
                                                                                        catch (FileNotFoundException var23_51) {
                                                                                            var24_55 = new File(new File(var22_44).getParent());
                                                                                            var24_55.mkdirs();
                                                                                            var12_12 = new FileOutputStream(var22_44);
                                                                                        }
                                                                                        var13_13 = new BufferedOutputStream(var12_12);
                                                                                        CcMediaSourceRecord.debugOut("Output file path: \"" + var22_44 + "\"");
                                                                                        this.setStatusMessage("Scaling image...");
                                                                                        var23_52 = this.sourceWidth >= this.sourceHeight ? (float)var17_22.getResolutionPixels() / (float)this.sourceWidth : (float)var17_22.getResolutionPixels() / (float)this.sourceHeight;
                                                                                        CcMediaSourceRecord.debugOut("scale ratio: " + var23_52);
                                                                                        var5_5.append(", Scale Ratio=" + var23_52);
                                                                                        var24_56 = var11_11.getProcessor();
                                                                                        if (var23_52 > 1.0f) {
                                                                                            var25_61 = this.sourceWidth >= this.sourceHeight ? this.sourceWidth : this.sourceHeight;
                                                                                            var24_56 = this.averageReductionScale(var24_56, (ImagePlus)var11_11, var25_61);
                                                                                        } else if (var18_34 && var23_52 != 1.0f) {
                                                                                            if (this.getResampleDuringResize()) {
                                                                                                var24_56.smooth();
                                                                                            } else {
                                                                                                CcMediaSourceRecord.debugOut("*** createImages(): Smoothing is turned OFF");
                                                                                            }
                                                                                            var24_56.setInterpolate(true);
                                                                                            var24_56 = var24_56.resize(Math.round((float)var24_56.getWidth() * var23_52), Math.round((float)var24_56.getHeight() * var23_52));
                                                                                        } else {
                                                                                            var24_56 = this.averageReductionScale(var24_56, (ImagePlus)var11_11, var17_22.getResolutionPixels());
                                                                                        }
                                                                                        this.destWidth = var24_56.getWidth();
                                                                                        this.destHeight = var24_56.getHeight();
                                                                                        var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                                        var6_6[7] = this.destWidth + "";
                                                                                        var6_6[8] = this.destHeight + "";
                                                                                        var21_39 = new BufferedImage(this.destWidth, this.destHeight, 1);
                                                                                        var25_62 = var21_39.createGraphics();
                                                                                        var25_62.drawImage(var24_56.createImage(), 0, 0, null);
                                                                                        var25_62.dispose();
                                                                                        var24_56 = null;
                                                                                        var26_66 = var17_22.getJpegSettings().jpegCompression;
                                                                                        if (var26_66 < 0) {
                                                                                            var26_66 = 0;
                                                                                        } else if (var26_66 > 100) {
                                                                                            var26_66 = 100;
                                                                                        }
                                                                                        var27_74 = 1.0f - (float)var26_66 / 100.0f;
                                                                                        var28_77 = JPEGCodec.createJPEGEncoder((OutputStream)var13_13);
                                                                                        var29_80 = var28_77.getDefaultJPEGEncodeParam(var21_39);
                                                                                        var29_80.setQuality(var27_74, true);
                                                                                        var5_5.append(", Compression level: " + var26_66 + ", quality level: " + var27_74);
                                                                                        this.setStatusMessage("Writing media file to " + var22_44 + ".");
                                                                                        var28_77.encode(var21_39, (JPEGEncodeParam)var29_80);
                                                                                        var21_39.flush();
                                                                                        var21_39 = null;
                                                                                        CcMediaSourceRecord.debugOut("encoded");
                                                                                        if (var18_34 && var23_52 < 1.0f && this.resIndex > 0) {
                                                                                            try {
                                                                                                var11_11.flush();
                                                                                                var30_84 = new Opener();
                                                                                                var11_11 = var30_84.openImage(var22_44);
                                                                                                var18_34 = false;
                                                                                                var24_56 = var11_11.getProcessor();
                                                                                                this.sourceWidth = var24_56.getWidth();
                                                                                                this.sourceHeight = var24_56.getHeight();
                                                                                                var24_56 = null;
                                                                                            }
                                                                                            catch (Throwable var30_85) {
                                                                                                CcMediaSourceRecord.debugOut("Caught exception while loading source image: " + var30_85);
                                                                                                throw var30_85;
                                                                                            }
                                                                                        } else if (var23_52 <= 1.0f) {
                                                                                            var18_34 = false;
                                                                                        }
                                                                                        this.writtenFilePaths.addElement(var22_44);
                                                                                        CcMediaSourceRecord.debugOut("written");
                                                                                    }
                                                                                }
                                                                                break block137;
                                                                            }
                                                                            if (var17_22.getFormat() != 13) break block147;
                                                                            CcMediaSourceRecord.debugOut("Generating JP2 image for resolution level " + this.resIndex);
                                                                            this.outputFilename = this.outputFilename + ".jp2";
                                                                            if (this.jp2Filename == null) {
                                                                                this.jp2Filename = this.outputFilename;
                                                                            }
                                                                            this.outputFilename = this.jp2Filename;
                                                                            var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                            var6_6[3] = "JP2";
                                                                            var6_6[4] = "1";
                                                                            var6_6[5] = this.batchCode;
                                                                            var6_6[6] = this.outputFilename;
                                                                            var21_37 = var17_22.getResolutionPixels();
                                                                            var22_45 = (float)this.sourceWidth / (float)this.sourceHeight;
                                                                            if (this.sourceWidth >= this.sourceHeight) {
                                                                                if (var21_37 > this.sourceWidth) {
                                                                                    var21_37 = this.sourceWidth;
                                                                                }
                                                                                this.destWidth = var21_37;
                                                                                this.destHeight = (int)((float)this.destWidth / var22_45);
                                                                            } else {
                                                                                if (var21_37 > this.sourceHeight) {
                                                                                    var21_37 = this.sourceHeight;
                                                                                }
                                                                                this.destHeight = var21_37;
                                                                                this.destWidth = (int)((float)this.destHeight * var22_45);
                                                                            }
                                                                            var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                            var6_6[7] = this.destWidth + "";
                                                                            var6_6[8] = this.destHeight + "";
                                                                            if (this.jp2GenerationComplete) {
                                                                                this.setStatusMessage("JP2 images have already been generated.");
                                                                                CcMediaSourceRecord.debugOut("JP2 images have already been generated.");
                                                                                var5_5.append(", JP2 images have already been generated.");
                                                                                break block137;
                                                                            } else {
                                                                                var23_47 = var20_36 + File.separator + this.outputFilename;
                                                                                CcMediaSourceRecord.debugOut("Output file path: \"" + (String)var23_47 + "\"");
                                                                                var24_57 = this.getSrcFilepath();
                                                                                if (!var24_57.endsWith(File.separator)) {
                                                                                    var24_57 = var24_57 + File.separator;
                                                                                }
                                                                                var24_57 = var24_57 + var1_1;
                                                                                var25_63 = var23_47;
                                                                                try {
                                                                                    var26_67 = new File(new File((String)var25_63).getParent());
                                                                                    if (!var26_67.exists()) {
                                                                                        var26_67.mkdirs();
                                                                                    }
                                                                                }
                                                                                catch (Exception var26_68) {
                                                                                    // empty catch block
                                                                                }
                                                                                this.setStatusMessage("Generating JP2.");
                                                                                if (!CcMediaSourceRecord.configuredJPEG2KCodec) {
                                                                                    JPEG2KCodec.configure();
                                                                                    CcMediaSourceRecord.configuredJPEG2KCodec = true;
                                                                                }
                                                                                try {
                                                                                    var26_67 = JPEG2KCodec.getDefaultJPEG2KEncodeParam();
                                                                                    var27_75 = JPEG2KCodec.createJPEG2KEncoder((String)var25_63);
                                                                                    if (var14_14 != null) {
                                                                                        var27_75.encode((ImagePlus)var14_14, (IJPEG2KEncodeParam)var26_67);
                                                                                    } else {
                                                                                        var27_75.encode(var24_57, (IJPEG2KEncodeParam)var26_67);
                                                                                    }
                                                                                    CcMediaSourceRecord.debugOut("JP2 creation done");
                                                                                    try {
                                                                                        var28_77 = new File((String)var25_63);
                                                                                        if (!var28_77.isFile() || !var28_77.exists()) ** GOTO lbl533
                                                                                        this.writtenFilePaths.addElement(var25_63);
                                                                                        this.jp2GenerationComplete = true;
                                                                                    }
                                                                                    catch (Exception var28_78) {}
                                                                                }
                                                                                catch (Exception var26_69) {
                                                                                    CcMediaSourceRecord.debugOut("JP2 creation failed: " + var26_69);
                                                                                    this.mediaCreationComplete = false;
                                                                                    throw var26_69;
                                                                                }
                                                                                catch (OutOfMemoryError var26_70) {
                                                                                    CcMediaSourceRecord.debugOut("JP2 creation failed due to memory limitation: " + var26_70);
                                                                                    throw var26_70;
                                                                                }
                                                                            }
                                                                        }
                                                                        if (var17_22.getFormat() != 1) break block148;
                                                                        this.outputFilename = this.outputFilename + ".sid";
                                                                        if (this.sidFilename == null) {
                                                                            this.sidFilename = this.outputFilename;
                                                                        }
                                                                        this.outputFilename = this.sidFilename;
                                                                        var5_5.append(", filename: \"" + this.outputFilename + "\"");
                                                                        var6_6[3] = "SID";
                                                                        var6_6[4] = "1";
                                                                        var6_6[5] = this.batchCode;
                                                                        var6_6[6] = this.outputFilename;
                                                                        var21_37 = var17_22.getResolutionPixels();
                                                                        var22_46 = (float)this.sourceWidth / (float)this.sourceHeight;
                                                                        if (this.sourceWidth >= this.sourceHeight) {
                                                                            this.destWidth = var21_37;
                                                                            this.destHeight = (int)((float)this.destWidth / var22_46);
                                                                        } else {
                                                                            this.destHeight = var21_37;
                                                                            this.destWidth = (int)((float)this.destHeight * var22_46);
                                                                        }
                                                                        var5_5.append(", Generated width: " + this.destWidth + ", height: " + this.destHeight);
                                                                        var6_6[7] = this.destWidth + "";
                                                                        var6_6[8] = this.destHeight + "";
                                                                        if (!this.sidGenerationComplete) break block149;
                                                                        this.setStatusMessage("SID images have already been generated.");
                                                                        CcMediaSourceRecord.debugOut("SID images have already been generated.");
                                                                        var5_5.append(", SID images have already been generated.");
                                                                        break block137;
                                                                    }
                                                                    var23_47 = var20_36 + File.separator + this.outputFilename;
                                                                    CcMediaSourceRecord.debugOut("Output file path: \"" + (String)var23_47 + "\"");
                                                                    var24_58 = this.getSrcFilepath();
                                                                    if (!var24_58.endsWith(File.separator)) {
                                                                        var24_58 = var24_58 + File.separator;
                                                                    }
                                                                    var25_64 = var24_58 = var24_58 + var1_1;
                                                                    if (!CcMediaSourceRecord.isTiffFile(var1_1)) {
                                                                        try {
                                                                            var25_64 = this.generateTemporaryTiffSourceFile(var24_58, this.outputFilename);
                                                                        }
                                                                        catch (Exception var26_71) {
                                                                            var25_64 = null;
                                                                        }
                                                                        if (var25_64 != null && !var25_64.equalsIgnoreCase(var24_58)) {
                                                                            var7_7.addElement(var25_64);
                                                                        } else {
                                                                            var25_64 = var24_58;
                                                                        }
                                                                    }
                                                                    var26_72 = var23_47;
                                                                    var27_76 = this.getSidZoomLevel();
                                                                    var28_79 = 20;
                                                                    if (var17_22.getSidSettings().nonDefaultSidCompressionRatio) {
                                                                        var28_79 = var17_22.getSidSettings().sidCompressionRatio;
                                                                    }
                                                                    var29_81 = 2;
                                                                    if (var17_22.getSidSettings().nonDefaultSidGamma) {
                                                                        var29_81 = var17_22.getSidSettings().sidGamma;
                                                                    }
                                                                    var30_86 = 4;
                                                                    if (var17_22.getSidSettings().nonDefaultSidWeight) {
                                                                        var30_86 = var17_22.getSidSettings().sidWeight;
                                                                    }
                                                                    try {
                                                                        var31_89 = new File(new File((String)var26_72).getParent());
                                                                        if (!var31_89.exists()) {
                                                                            var31_89.mkdirs();
                                                                        }
                                                                    }
                                                                    catch (Exception var31_90) {
                                                                        // empty catch block
                                                                    }
                                                                    this.setStatusMessage("Generating SID.");
                                                                    var31_87 = SidGenerator.generate(var25_64, (String)var26_72, var27_76, var28_79, var29_81, var30_86);
                                                                    CcMediaSourceRecord.debugOut("SID creation done, exit code: " + var31_87);
                                                                    var5_5.append("; exit code: " + var31_87);
                                                                    if (var31_87 == 0) {
                                                                        try {
                                                                            var32_94 = new File((String)var26_72);
                                                                            if (var32_94.isFile() && var32_94.exists()) {
                                                                                this.writtenFilePaths.addElement(var26_72);
                                                                                this.sidGenerationComplete = true;
                                                                            }
                                                                            break block137;
                                                                        }
                                                                        catch (Exception var32_95) {}
                                                                        break block137;
                                                                    } else {
                                                                        this.mediaCreationComplete = false;
                                                                    }
                                                                    break block137;
                                                                }
                                                                CcMediaSourceRecord.debugOut("Unknown image type: " + var17_22.getFormat());
                                                                var5_5 = new StringBuffer("");
                                                                this.logLineToFile(new Date() + "- WARNING: Unknown image type: " + var17_22.getFormat());
                                                                this.mediaCreationComplete = false;
                                                            }
                                                            var21_37 = this.destWidth;
                                                            var22_41 = this.destHeight;
                                                            if (var9_9 && var16_21.size() > this.resIndex && var16_21.get(this.resIndex) != null && var17_22.getFormat() != 13) {
                                                                var21_37 = ((Dimension)var16_21.get((int)this.resIndex)).width;
                                                                var22_41 = ((Dimension)var16_21.get((int)this.resIndex)).height;
                                                            }
                                                            var23_47 = new CsMediaFile(this.collection, this.getDestMediaID(), var17_22.getResolutionNumber(), ImageFile.getFormatTypeToString(var17_22.getFormat()), var3_3, this.batch.getBatchID(), this.outputFilename, var21_37, var22_41);
                                                            if (this.getObjectKey() != null && this.getObjectKey().length() > 0) {
                                                                var23_47.setObjectKey(this.getObjectKey(), this.getObjectKeyFieldID());
                                                            }
                                                            this.mediaFileRecords.addElement(var23_47);
                                                            break block150;
                                                        }
                                                        CcMediaSourceRecord.debugOut("Resolution " + this.resIndex + " was not specified.");
                                                        var5_5 = new StringBuffer("");
                                                        this.logLineToFile(new Date() + "- WARNING: Resolution " + this.resIndex + " was not specified.");
                                                        this.mediaCreationComplete = false;
                                                    }
                                                    if (var5_5 != null && !var5_5.toString().equals("")) {
                                                        var5_5 = new StringBuffer("");
                                                    }
                                                    if (var17_22.getFormat() != 0 || !var9_9) {
                                                        this.logValuesToFile(var6_6);
                                                    }
                                                    --this.resIndex;
                                                }
                                                break block138;
                                            }
                                            catch (Throwable var14_17) {
                                                block153: {
                                                    block151: {
                                                        block152: {
                                                            System.runFinalization();
                                                            System.gc();
                                                            CcMediaSourceRecord.debugOut("Error occurred while creating derivative images: " + var14_17);
                                                            CcMediaSourceRecord.debugOut("Stack Trace: " + InsightUtilities.getStackTrace(var14_17));
                                                            var5_5 = new StringBuffer("");
                                                            this.logLineToFile(new Date() + "- WARNING: Caught exception while creating derivative images for " + var2_2 + ": " + var14_17);
                                                            this.logLineToFile(new Date() + "Stack Trace: " + InsightUtilities.getStackTrace(var14_17));
                                                            this.mediaCreationComplete = false;
                                                            var35_27 = null;
                                                            if (var12_12 == null) break block151;
                                                            ** try [egrp 15[TRYBLOCK] [24 : 5325->5333)] { 
lbl570:
                                                            // 1 sources

                                                            var12_12.close();
                                                            break block152;
lbl572:
                                                            // 1 sources

                                                            catch (IOException var36_32) {
                                                                CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var36_32);
                                                            }
                                                        }
                                                        var12_12 = null;
                                                    }
                                                    if (var13_13 == null) break block139;
                                                    ** try [egrp 16[TRYBLOCK] [25 : 5367->5375)] { 
lbl579:
                                                    // 1 sources

                                                    var13_13.close();
                                                    break block153;
lbl581:
                                                    // 1 sources

                                                    catch (IOException var36_32) {
                                                        CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var36_32);
                                                    }
                                                }
                                                var13_13 = null;
                                                break block139;
                                            }
                                        }
                                        catch (Throwable var34_97) {
                                            block156: {
                                                block154: {
                                                    block155: {
                                                        var35_28 = null;
                                                        if (var12_12 == null) break block154;
                                                        ** try [egrp 15[TRYBLOCK] [24 : 5325->5333)] { 
lbl591:
                                                        // 1 sources

                                                        var12_12.close();
                                                        break block155;
lbl593:
                                                        // 1 sources

                                                        catch (IOException var36_33) {
                                                            CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var36_33);
                                                        }
                                                    }
                                                    var12_12 = null;
                                                }
                                                if (var13_13 == null) throw var34_97;
                                                ** try [egrp 16[TRYBLOCK] [25 : 5367->5375)] { 
lbl600:
                                                // 1 sources

                                                var13_13.close();
                                                break block156;
lbl602:
                                                // 1 sources

                                                catch (IOException var36_33) {
                                                    CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var36_33);
                                                }
                                            }
                                            var13_13 = null;
                                            throw var34_97;
                                        }
                                    }
                                    ** try [egrp 15[TRYBLOCK] [24 : 5325->5333)] { 
lbl609:
                                    // 1 sources

                                    var12_12.close();
                                    break block157;
lbl611:
                                    // 1 sources

                                    catch (IOException var36_29) {
                                        CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var36_29);
                                    }
                                }
                                var12_12 = null;
                            }
                            if (var13_13 == null) return;
                            ** try [egrp 16[TRYBLOCK] [25 : 5367->5375)] { 
lbl618:
                            // 1 sources

                            var13_13.close();
                            return;
lbl620:
                            // 1 sources

                            catch (IOException var36_29) {
                                CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var36_29);
                            }
                            return;
                        }
                        var35_27 = null;
                        if (var12_12 == null) break block158;
                        ** try [egrp 15[TRYBLOCK] [24 : 5325->5333)] { 
lbl627:
                        // 1 sources

                        var12_12.close();
                        break block159;
lbl629:
                        // 1 sources

                        catch (IOException var36_32) {
                            CcMediaSourceRecord.debugOut("IOException closing FileOutputStream: " + var36_32);
                        }
                    }
                    var12_12 = null;
                }
                if (var13_13 == null) break block139;
                ** try [egrp 16[TRYBLOCK] [25 : 5367->5375)] { 
lbl636:
                // 1 sources

                var13_13.close();
                break block160;
lbl638:
                // 1 sources

                catch (IOException var36_32) {
                    CcMediaSourceRecord.debugOut("IOException closing BufferedOutputStream: " + var36_32);
                }
            }
            var13_13 = null;
        }
        this.source = null;
        if (var11_11 != null) {
            var11_11.flush();
            var11_11 = null;
        }
        var8_8 = null;
        var14_18 = 0;
        while (var14_18 < var7_7.size()) {
            block141: {
                var15_19 = "";
                var16_21 = null;
                try {
                    block140: {
                        try {
                            var15_19 = (String)var7_7.elementAt(var14_18);
                            var17_22 = new File((String)var15_19);
                            var18_34 = var17_22.delete();
                            if (!var18_34) {
                                var16_21 = new FileOutputStream((File)var17_22);
                                var16_21.getFD().sync();
                                var16_21.close();
                                var18_34 = var17_22.delete();
                            }
                            if (var18_34) break block140;
                            CcMediaSourceRecord.debugOut("Could not delete temporary TIFF file: '" + (String)var15_19 + "'; requesting deletion upon JVM termination.");
                            var17_22.deleteOnExit();
                        }
                        catch (Exception var17_23) {
                            CcMediaSourceRecord.debugOut("Exception trying to delete temporary TIFF file: " + (String)var15_19 + ": " + var17_23);
                            var38_98 = null;
                            try {
                                if (var16_21 != null) {
                                    var16_21.close();
                                }
                                break block141;
                            }
                            catch (IOException var39_99) {}
                            break block141;
                        }
                    }
                    var38_98 = null;
                }
                catch (Throwable var37_100) {
                    var38_98 = null;
                    ** try [egrp 19[TRYBLOCK] [30 : 5611->5624)] { 
lbl684:
                    // 1 sources

                    if (var16_21 == null) throw var37_100;
                    var16_21.close();
                    throw var37_100;
lbl687:
                    // 1 sources

                    catch (IOException var39_99) {
                        // empty catch block
                    }
                    throw var37_100;
                }
                try {}
                catch (IOException var39_99) {}
                if (var16_21 != null) {
                    var16_21.close();
                }
            }
            ++var14_18;
        }
    }

    protected List createJpegsWithoutJAI(String string, String string2, int n, int n2) {
        Vector<Dimension> vector = new Vector<Dimension>();
        StringBuffer stringBuffer = new StringBuffer("");
        String[] stringArray = new String[9];
        stringArray[0] = this.objectKey;
        stringArray[1] = this.getDestMediaID() + "";
        try {
            CcMediaSourceRecord.debugOut("------- image \"" + string + "\"-------");
            stringBuffer.append(new Date() + "- Source: " + string);
            this.mediaCreationComplete = true;
            try {
                if (this.source == null) {
                    this.setStatusMessage("Loading source file \"" + string + "\".");
                    this.source = JAI.create((String)"fileload", (Object)string2);
                    this.sourceWidth = this.source.getWidth();
                    this.sourceHeight = this.source.getHeight();
                }
            }
            catch (Exception exception) {
                CcMediaSourceRecord.debugOut("Caught exception while loading image: " + InsightUtilities.getStackTrace(exception));
                this.logLineToFile(stringBuffer.toString());
                this.logLineToFile(new Date() + "- WARNING: Caught exception while loading image: " + exception);
                this.source = null;
                return vector;
            }
            this.setStatusMessage("Calculating target resolution sizes.");
            Vector vector2 = CcMediaSourceRecord.determineActualResolutions(this.source.getWidth(), this.source.getHeight(), this.resolutions);
            String string3 = " -s \"" + string2 + "\" -o \"" + this.batch.getDestDir() + "\"";
            if (!this.preserveFilenames) {
                string3 = string3 + " -b \"" + this.batchCode + "\" -q \"" + this.sequenceCode + "\"";
            }
            this.resIndex = 0;
            while (this.resIndex < vector2.size() && (n2 < 0 || this.resIndex <= n2)) {
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)vector2.get(this.resIndex);
                this.setStatusMessage("Generating derivative image " + this.resIndex + " using " + "mbconvert" + " utility.");
                this.destWidth = 0;
                this.destHeight = 0;
                if (ccBatchProfileResolution != null) {
                    CcMediaSourceRecord.debugOut("Generating image for resolution level " + this.resIndex);
                    stringBuffer = new StringBuffer(new Date() + "- Source: " + string);
                    stringBuffer.append(", Resolution: " + this.resIndex);
                    stringArray[2] = this.resIndex + "";
                    if (ccBatchProfileResolution.getFormat() == 0) {
                        this.outputFilename = string;
                        if (this.outputFilename.lastIndexOf(46) != -1) {
                            this.outputFilename = this.outputFilename.substring(0, this.outputFilename.lastIndexOf(46));
                        }
                        if (!this.preserveFilenames) {
                            this.outputFilename = this.batchCode + ccBatchProfileResolution.getResolutionNumber() + this.sequenceCode;
                        }
                        this.outputFilename = this.outputFilename + JPEG_EXT;
                        stringBuffer.append(", filename: \"" + this.outputFilename + "\"");
                        stringArray[3] = "JPEG";
                        stringArray[4] = "1";
                        stringArray[5] = this.batchCode;
                        stringArray[6] = this.outputFilename;
                        string3 = string3 + " -r" + ccBatchProfileResolution.getResolutionNumber() + " ";
                        int n3 = ccBatchProfileResolution.getJpegSettings().jpegCompression;
                        string3 = string3 + n3 + ";";
                        int n4 = 0;
                        if (ccBatchProfileResolution.getJpegSettings().useBrightness) {
                            n4 = ccBatchProfileResolution.getJpegSettings().brightness;
                            if (n4 > 256) {
                                n4 = 256;
                            } else if (n4 < -256) {
                                n4 = -256;
                            }
                        }
                        string3 = string3 + n4 + ";";
                        int n5 = 0;
                        if (ccBatchProfileResolution.getJpegSettings().automaticTrimEdges) {
                            n5 = ccBatchProfileResolution.getJpegSettings().edgeThreshold;
                        }
                        string3 = string3 + n5 + ";";
                        float f = this.sourceWidth >= this.sourceHeight ? (float)ccBatchProfileResolution.getResolutionPixels() / (float)this.sourceWidth : (float)ccBatchProfileResolution.getResolutionPixels() / (float)this.sourceHeight;
                        if (f > 1.0f && !ccBatchProfileResolution.getJpegSettings().forceUpsize) {
                            f = 1.0f;
                        }
                        int n6 = (int)((float)this.sourceWidth * f);
                        int n7 = (int)((float)this.sourceHeight * f);
                        string3 = string3 + n6 + ";" + n7;
                        vector.insertElementAt(new Dimension(n6, n7), this.resIndex);
                        stringBuffer.append(", Scale Ratio=" + f + ", Generated width: " + n6 + ", height: " + n7);
                        stringArray[7] = n6 + "";
                        stringArray[8] = n7 + "";
                        String string4 = this.batch.getDestDir() + File.separator + ccBatchProfileResolution.getRelativeDirectoryPath(n) + File.separator + this.batch.getLpsDir().replace('/', File.separatorChar);
                        File file = new File(new File(string4).getParent());
                        file.mkdirs();
                        this.logValuesToFile(stringArray);
                    }
                }
                ++this.resIndex;
            }
            string3 = string3 + " -d \"" + this.batch.getLpsDir().replace('/', File.separatorChar) + "\"";
            MBConvertInvoker.generate(string3);
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Caught exception while creating derivative images: " + exception);
            CcMediaSourceRecord.debugOut("Stack Trace: " + InsightUtilities.getStackTrace(exception));
            stringBuffer = new StringBuffer("");
            this.logLineToFile(new Date() + "- WARNING: Caught exception while creating derivative images: " + exception);
            this.logLineToFile(new Date() + "Stack Trace: " + InsightUtilities.getStackTrace(exception));
            this.mediaCreationComplete = false;
        }
        return vector;
    }

    private RenderedOp getMogrifiedSource(String string, String string2, int n) {
        Object object;
        if (this.source == null) {
            return null;
        }
        String string3 = this.getTemporaryImageMagickFilename(string2);
        try {
            boolean bl;
            object = new File(TEMP_TIFF_DIRECTORY);
            if (!(((File)object).exists() && ((File)object).isDirectory() || (bl = ((File)object).mkdirs()))) {
                CcMediaSourceRecord.debugOut("WARNING: Could not create temporary source TIFF directory for ImageMagick utility.");
                return null;
            }
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("WARNING: Could not create temporary source TIFF directory for ImageMagick utility: " + exception);
            return null;
        }
        object = n + "x" + n;
        ImageMagickInvoker.generate(string, string3, MOGRIFY_FILTER, (String)object);
        RenderedOp renderedOp = JAI.create((String)"fileload", (Object)string3);
        return renderedOp;
    }

    private String getTemporaryImageMagickFilename(String string) {
        String string2 = "IMTEMP_" + this.batchCode + this.sequenceCode + "_" + string;
        File file = new File(TEMP_TIFF_DIRECTORY + File.separator + string2);
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean copyFile(String string, String string2) {
        boolean bl;
        BufferedInputStream bufferedInputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
                while ((n = bufferedInputStream.read()) != -1) {
                    ((BufferedOutputStream)filterOutputStream).write(n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                bl = true;
                Object var7_8 = null;
            }
            catch (IOException iOException) {
                CcMediaSourceRecord.debugOut("CcMediaSourceRecord.copyFile() Exception: " + iOException.getMessage());
                boolean bl2 = false;
                Object var7_9 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream == null) return bl2;
                    filterOutputStream.close();
                    return bl2;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (filterOutputStream == null) throw throwable;
            filterOutputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        if (bufferedInputStream != null) {
            bufferedInputStream.close();
        }
        if (filterOutputStream == null) return bl;
        filterOutputStream.close();
        return bl;
    }

    private static Vector determineActualResolutions(int n, int n2, List list) {
        int n3;
        if (list == null || list.size() == 0) {
            return new Vector();
        }
        Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>();
        int n4 = n >= n2 ? n : n2;
        CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)list.get(0);
        int n5 = 0;
        while (n5 < list.size() && ccBatchProfileResolution.getFormat() == 0 && n4 >= ccBatchProfileResolution.getMinimumPixelSize()) {
            vector.addElement(ccBatchProfileResolution.getCopy());
            if (++n5 >= list.size()) continue;
            ccBatchProfileResolution = (CcBatchProfileResolution)list.get(n5);
        }
        if (n4 < ccBatchProfileResolution.getMinimumPixelSize()) {
            return vector;
        }
        int n6 = ccBatchProfileResolution.getResolutionNumber();
        int n7 = CcBatchProfileResolution.determineResolutionForSize(n4);
        int[] nArray = new int[n7 - n6 + 1];
        int n8 = n4;
        for (n3 = n7; n3 >= n6; --n3) {
            nArray[n3 - n6] = n8;
            n8 /= 2;
        }
        n3 = 0;
        while (n5 < list.size() && n5 <= n7) {
            CcBatchProfileResolution ccBatchProfileResolution2 = ccBatchProfileResolution.getCopy();
            ccBatchProfileResolution2.setNonDefaultPixelSize(nArray[n3]);
            vector.addElement(ccBatchProfileResolution2);
            ++n3;
            if (++n5 >= list.size()) continue;
            ccBatchProfileResolution = (CcBatchProfileResolution)list.get(n5);
        }
        return vector;
    }

    private void commitMediaFileRecords() {
        if (this.collection == null || this.collection.getServer() == null) {
            CcMediaSourceRecord.debugOut("Could not write image file records, no collection server.");
            return;
        }
        if (this.mediaFileRecords == null) {
            CcMediaSourceRecord.debugOut("No image file records to write.");
            return;
        }
        CcMediaSourceRecord.debugOut("About to write " + this.mediaFileRecords.size() + " mediaFileRecords");
        this.collection.getServer().commitMediaFiles(this.mediaFileRecords);
    }

    private final byte clampByte(int n) {
        if (n > 255) {
            return -1;
        }
        if (n < 0) {
            return 0;
        }
        return (byte)n;
    }

    private int getSidZoomLevel() {
        int n = 0;
        if (this.sourceWidth <= this.sourceHeight) {
            if (this.sourceHeight > 12288 && this.sourceHeight <= 30000) {
                n = 8;
            } else if (this.sourceHeight > 6144 && this.sourceHeight <= 12288) {
                n = 7;
            } else if (this.sourceHeight > 3072 && this.sourceHeight <= 6144) {
                n = 6;
            } else if (this.sourceHeight > 1536 && this.sourceHeight <= 3072) {
                n = 5;
            } else if (this.sourceHeight > 768 && this.sourceHeight <= 1536) {
                n = 4;
            } else if (this.sourceHeight > 384 && this.sourceHeight <= 768) {
                n = 3;
            } else if (this.sourceHeight > 192 && this.sourceHeight <= 384) {
                n = 2;
            } else if (this.sourceHeight > 96 && this.sourceHeight <= 192) {
                n = 1;
            }
        } else if (this.sourceWidth > 12288 && this.sourceWidth <= 30000) {
            n = 8;
        } else if (this.sourceWidth > 6144 && this.sourceWidth <= 12288) {
            n = 7;
        } else if (this.sourceWidth > 3072 && this.sourceWidth <= 6144) {
            n = 6;
        } else if (this.sourceWidth > 1536 && this.sourceWidth <= 3072) {
            n = 5;
        } else if (this.sourceWidth > 768 && this.sourceWidth <= 1536) {
            n = 4;
        } else if (this.sourceWidth > 384 && this.sourceWidth <= 768) {
            n = 3;
        } else if (this.sourceWidth > 192 && this.sourceWidth <= 384) {
            n = 2;
        } else if (this.sourceWidth > 96 && this.sourceWidth <= 192) {
            n = 1;
        }
        return n;
    }

    private String convertFromPcdToTiff(String string) {
        CcMediaSourceRecord.debugOut("convertFromPcdToTiff is not implemented");
        return string;
    }

    private boolean needToGenerateTiff(String string) {
        try {
            File file = new File(CcMediaSourceRecord.replaceFileExtension(string, LONG_TIFF_EXT));
            File file2 = new File(CcMediaSourceRecord.replaceFileExtension(string, SHORT_TIFF_EXT));
            return !file.exists() && !file2.exists();
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Exception in needToGenerateTiff(): " + exception);
            return true;
        }
    }

    public static String replaceFileExtension(String string, String string2) {
        if (string.lastIndexOf(46) > 0) {
            return string.substring(0, string.lastIndexOf(46)) + string2;
        }
        return string + string2;
    }

    public static boolean isTiffFile(String string) {
        if (string == null) {
            return false;
        }
        return string.toUpperCase().endsWith(LONG_TIFF_EXT.toUpperCase()) || string.toUpperCase().endsWith(SHORT_TIFF_EXT.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateTemporaryTiffSourceFile(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "temporary";
        }
        String string3 = this.batchCode + "_" + CcMediaSourceRecord.replaceFileExtension(string2, SHORT_TIFF_EXT);
        String string4 = TEMP_TIFF_DIRECTORY + File.separator + string3;
        RenderedOp renderedOp = null;
        RenderedOp renderedOp2 = null;
        try {
            boolean bl;
            File file = new File(TEMP_TIFF_DIRECTORY);
            if (!(file.exists() && file.isDirectory() || (bl = file.mkdirs()))) {
                CcMediaSourceRecord.debugOut("WARNING: Could not create temporary source TIFF directory for SID generation.");
                String string5 = null;
                return string5;
            }
            File file2 = new File(file, string3);
            string4 = file2.getAbsolutePath();
            renderedOp = JAI.create((String)"fileload", (Object)string);
            renderedOp2 = JAI.create((String)"filestore", (RenderedImage)renderedOp, (Object)string4, (Object)"TIFF");
        }
        catch (Exception exception) {
            CcMediaSourceRecord.debugOut("Exception occurred while trying to create temporary source TIFF for SID generation: " + exception);
            String string6 = null;
            return string6;
        }
        finally {
            renderedOp = null;
            renderedOp2 = null;
        }
        return string4;
    }

    public static void main(String[] stringArray) {
    }

    public void debugFile(String string) {
        if (this.batch.getLogFilepath() != null && this.batch.getLogFilepath().length() > 0) {
            try {
                FileWriter fileWriter = new FileWriter(this.batch.getLogFilepath(), true);
                fileWriter.write(new Date() + "- \"" + this.getSrcFilename() + "\": " + string + "\r\n");
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void logToFile(String string) {
        if (this.batch.getLogFilepath() != null && this.batch.getLogFilepath().length() > 0) {
            try {
                FileWriter fileWriter = new FileWriter(this.batch.getLogFilepath(), true);
                fileWriter.write(string);
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void logLineToFile(String string) {
        this.logToFile(string + "\r\n");
    }

    public void logValuesToFile(String[] stringArray, char c) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].trim().equals("")) {
                    this.logToFile("N/A" + c);
                    continue;
                }
                this.logToFile(stringArray[i] + c);
            }
            this.logToFile("\r\n");
        }
    }

    public void logValuesToFile(String[] stringArray) {
        this.logValuesToFile(stringArray, '\t');
    }

    private ImageProcessor averageReductionScale(ImageProcessor imageProcessor, ImagePlus imagePlus, int n) {
        int n2 = imageProcessor.getWidth() > imageProcessor.getHeight() ? imageProcessor.getWidth() : imageProcessor.getHeight();
        double d = (double)n2 / (double)n;
        int n3 = (int)d;
        double d2 = n3 * n3;
        if (imagePlus.getBitDepth() == 32) {
            return null;
        }
        int n4 = imageProcessor instanceof ColorProcessor ? 3 : 1;
        int n5 = (int)((double)imageProcessor.getWidth() / d);
        int n6 = (int)((double)imageProcessor.getHeight() / d);
        ImageProcessor imageProcessor2 = imageProcessor.createProcessor(n5, n6);
        for (int i = 0; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                imageProcessor2.putPixel(j, i, this.getAverage(imageProcessor, j, i, n3, d2, n4));
            }
        }
        imageProcessor2.resetMinAndMax();
        return imageProcessor2;
    }

    private int[] getAverage(ImageProcessor imageProcessor, int n, int n2, int n3, double d, int n4) {
        int n5;
        int[] nArray = new int[n4];
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = 0;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            for (int i = 0; i < n3; ++i) {
                this.pixel = imageProcessor.getPixel(n * n3 + i, n2 * n3 + n5, this.pixel);
                for (int j = 0; j < n4; ++j) {
                    int n6 = j;
                    nArray[n6] = nArray[n6] + this.pixel[j];
                }
            }
        }
        for (n5 = 0; n5 < n4; ++n5) {
            nArray[n5] = (int)((double)nArray[n5] / d + 0.5);
        }
        return nArray;
    }
}

