/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdminDesktopPane;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.config.CollectionServerConfiguration;
import com.luna.insight.admin.collserver.lps.CcLpsData;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaCreationProgressDisplay;
import com.luna.insight.admin.collserver.mediacreation.CcMediaSourceRecord;
import com.luna.insight.admin.collserver.mediacreation.ImageRecordCommitFailedException;
import com.luna.insight.admin.collserver.sps.CcSpsData;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.ImageFile;
import com.luna.insight.server.InsightUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class CcMediaCreator
extends JInternalFrame {
    public static final String SAMPLE_URL = "http://<insert url here>/";
    public static final String A_BUNCH_OF_ZEROS = "000000000000000000000000000000";
    public static final String BATCH_PREFIX = "Batch";
    public static int BATCH_NUM_LENGTH = 4;
    public static int SEQ_NUM_LENGTH = 3;
    protected CollectionServer server;
    protected CcMediaBatch batch;
    protected List batchElements;
    protected List resolutions;
    protected boolean resampleDuringResize = true;
    protected int progressIndex = 0;
    protected int completedImages = 0;
    protected boolean paused = false;
    protected boolean stopped = false;
    protected JScrollPane displayPane = null;
    protected JPanel buttonPanel = null;
    protected JButton pauseButton = null;
    protected JButton cancelButton = null;
    protected Thread imageCreationThread;
    protected CcMediaCreationProgressDisplay mediaProgress = null;
    protected CcTaskItem imageCreationTaskItem = null;

    public static void debugOut(String string) {
        CcMediaCreator.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaCreator: " + string, n);
    }

    public CcMediaCreator(CollectionServer collectionServer, CcMediaBatch ccMediaBatch) {
        super("Media Creation", true, true, true, true);
        this.server = collectionServer;
        this.batch = ccMediaBatch;
        this.resolutions = ccMediaBatch.getResolutions();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                CcMediaCreator.this.cancel();
            }
        });
        ImageIcon imageIcon = IconMaker.createImage("images/collection-creation-image-creation-icon.gif");
        if (imageIcon != null) {
            this.setFrameIcon(imageIcon);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.displayPane = new JScrollPane();
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        Dimension dimension = new Dimension(100, 29);
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcMediaCreator.this.pause();
            }
        });
        this.pauseButton.setPreferredSize(dimension);
        this.cancelButton = new JButton("Close");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcMediaCreator.this.cancel();
            }
        });
        this.cancelButton.setPreferredSize(dimension);
        this.buttonPanel.add(this.pauseButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.displayPane, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.mediaProgress = new CcMediaCreationProgressDisplay(this);
        this.displayPane.setViewportView(this.mediaProgress);
        ColorUIResource colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
            colorUIResource = MetalLookAndFeel.getControlDarkShadow();
        }
        this.displayPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, colorUIResource));
        this.pack();
        Dimension dimension2 = this.getPreferredSize();
        int n = new JScrollBar().getPreferredSize().width;
        this.setPreferredSize(new Dimension(dimension2.width + n, dimension2.height + n));
    }

    public void setTaskItem(CcTaskItem ccTaskItem) {
        this.imageCreationTaskItem = ccTaskItem;
    }

    public void start() {
        CcMediaCreator.debugOut("in start()");
        if (this.pauseButton != null) {
            this.pauseButton.setEnabled(true);
        }
        if (this.imageCreationThread == null || !this.imageCreationThread.isAlive()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        CcMediaCreator.this.createDerivativeImages();
                    }
                    catch (InvalidParameterException invalidParameterException) {
                        InsightAdministrator.getInsightAdministrator().showWarningDialog(invalidParameterException.getMessage(), "Image Creation Failure");
                        CcMediaCreator.this.cancel();
                    }
                    catch (ImageRecordCommitFailedException imageRecordCommitFailedException) {
                        InsightAdministrator.getInsightAdministrator().showWarningDialog(imageRecordCommitFailedException.getWarningMessage(), imageRecordCommitFailedException.getWarningTitle());
                        CcMediaCreator.this.cancel();
                    }
                }
            };
            this.imageCreationThread = new Thread(runnable);
            this.imageCreationThread.start();
        }
    }

    public void pause() {
        CcMediaCreator.debugOut("in pause()");
        this.paused = !this.paused;
    }

    public void cancel() {
        CcMediaCreator.debugOut("in cancel()");
        this.stopped = true;
        this.closeDialog(null);
        if (this.imageCreationTaskItem != null) {
            this.imageCreationTaskItem.setTaskItemCancelled();
        }
    }

    public void done() {
        if (this.mediaProgress != null) {
            this.mediaProgress.batchProcessComplete();
        }
        if (this.pauseButton != null) {
            this.pauseButton.setEnabled(false);
        }
        if (this.imageCreationTaskItem != null) {
            this.imageCreationTaskItem.setTaskItemComplete();
        }
    }

    public int getProgressMin() {
        return 0;
    }

    public int getProgressMax() {
        if (this.batchElements != null) {
            return this.batchElements.size();
        }
        return 0;
    }

    public int getProgressCurrent() {
        return this.progressIndex;
    }

    public int getCompletedImageCount() {
        return this.completedImages;
    }

    public int getRemainingImageCount() {
        if (this.batchElements != null) {
            return this.batchElements.size() - this.getCompletedImageCount();
        }
        return 0;
    }

    public void show() {
        try {
            AdminDesktopPane adminDesktopPane = InsightAdministrator.getInsightAdministrator().getDesktop();
            adminDesktopPane.add(this);
        }
        catch (Exception exception) {
            CcMediaCreator.debugOut("Exception while adding to desktop pane.  We must not have a valid reference.");
        }
        super.show();
        this.start();
    }

    protected void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    protected long getNextMediaID() {
        return this.server.getCollectionServerConnector().getNextMediaID();
    }

    protected long getNextAvailableMediaID(long l) {
        return this.server.getCollectionServerConnector().getNextAvailableMediaID(l);
    }

    private boolean createLpsEntry(int n, String string) {
        CcLpsData ccLpsData = new CcLpsData(this.server, n, string);
        return this.server.commitLpsRecord(ccLpsData);
    }

    private Vector findMatchingSpsRecords(Vector vector) {
        Vector<CcSpsData> vector2 = new Vector<CcSpsData>();
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                CcSpsData ccSpsData = (CcSpsData)iterator.next();
                if (ccSpsData.resolutionSize < 0 || ccSpsData.resolutionSize >= this.resolutions.size()) continue;
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)this.resolutions.get(ccSpsData.resolutionSize);
                if (ccBatchProfileResolution != null && ccSpsData.mediaType == 1 && ccBatchProfileResolution.getFormat() == ccSpsData.getFormat() && ccSpsData.url.equalsIgnoreCase(this.getBaseUrl(ccBatchProfileResolution))) {
                    vector2.addElement(ccSpsData);
                    continue;
                }
                return new Vector();
            }
        }
        catch (Exception exception) {
            CcMediaCreator.debugOut("Exception in findMatchingSpsRecords():\n" + InsightUtilities.getStackTrace(exception));
        }
        return vector2;
    }

    private boolean createSpsEntries() {
        Vector<CcSpsData> vector;
        Vector vector2 = this.server.getSpsDataBySpsNum();
        Vector<CcSpsData> vector3 = new Vector<CcSpsData>();
        Object object = vector2.iterator();
        while (object.hasNext()) {
            Vector vector4 = (Vector)object.next();
            vector = this.findMatchingSpsRecords(vector4);
            if (vector.size() <= 0 || vector.size() < vector3.size()) continue;
            vector3 = vector;
        }
        if (vector3 == null || vector3.size() == 0) {
            int n = this.server.getCollectionServerConnector().getNextValidSpsDataID();
            int n2 = -1;
            try {
                vector = this.server.getConfigurations(this.batch.getUniqueCollectionID(), false);
                n2 = Integer.parseInt(((CollectionServerConfiguration)vector.firstElement()).getCollectionID());
            }
            catch (Exception exception) {
                CcMediaCreator.debugOut("Exception while retreiving a valid collection ID:\n" + InsightUtilities.getStackTrace(exception));
                n2 = -1;
            }
            vector = new Vector<CcSpsData>();
            for (int i = 0; i < this.resolutions.size(); ++i) {
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)this.resolutions.get(i);
                CcSpsData ccSpsData = new CcSpsData(this.server, n, i, n2, ccBatchProfileResolution.getMediaType(), ImageFile.getFormatTypeToString(ccBatchProfileResolution.getFormat()), this.getBaseUrl(ccBatchProfileResolution));
                vector.addElement(ccSpsData);
            }
            return this.server.commitSpsRecords(vector);
        }
        if (vector3.size() < this.resolutions.size()) {
            object = (CcSpsData)vector3.firstElement();
            int n = ((CcSpsData)object).spsNumber;
            int n3 = ((CcSpsData)object).collectionID;
            Vector<CcSpsData> vector5 = new Vector<CcSpsData>();
            for (int i = 0; i < this.resolutions.size(); ++i) {
                CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)this.resolutions.get(i);
                boolean bl = false;
                for (int j = 0; j < vector3.size(); ++j) {
                    CcSpsData ccSpsData = (CcSpsData)vector3.elementAt(j);
                    if (ccSpsData.resolutionSize != ccBatchProfileResolution.getResolutionNumber()) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                CcSpsData ccSpsData = new CcSpsData(this.server, n, ccBatchProfileResolution.getResolutionNumber(), n3, ccBatchProfileResolution.getMediaType(), ImageFile.getFormatTypeToString(ccBatchProfileResolution.getFormat()), this.getBaseUrl(ccBatchProfileResolution));
                vector5.addElement(ccSpsData);
            }
            return this.server.commitSpsRecords(vector5);
        }
        return true;
    }

    protected String getBaseUrl(CcBatchProfileResolution ccBatchProfileResolution) {
        if (ccBatchProfileResolution.getMediaType() == 1) {
            if (ccBatchProfileResolution.getFormat() == 1) {
                return this.batch.getUltimateSidUrlPrefix();
            }
            return InsightUtilities.concatUrl(this.batch.getUltimateUrlPrefix(), ccBatchProfileResolution.getRelativeDirectoryPath());
        }
        return "";
    }

    private String generateBatchCode(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + "");
        if (BATCH_NUM_LENGTH < (stringBuffer = stringBuffer.reverse()).length()) {
            BATCH_NUM_LENGTH = stringBuffer.length();
        }
        stringBuffer.append(A_BUNCH_OF_ZEROS.toCharArray(), 0, BATCH_NUM_LENGTH - stringBuffer.length());
        stringBuffer = stringBuffer.reverse();
        return stringBuffer.toString();
    }

    private String generateSequenceCode(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + "");
        if (SEQ_NUM_LENGTH < (stringBuffer = stringBuffer.reverse()).length()) {
            SEQ_NUM_LENGTH = stringBuffer.length();
        }
        stringBuffer.append(A_BUNCH_OF_ZEROS.toCharArray(), 0, SEQ_NUM_LENGTH - stringBuffer.length());
        stringBuffer = stringBuffer.reverse();
        return stringBuffer.toString();
    }

    private void updateObjectImageMappings() {
        this.server.getCollectionServerConnector().updateObjectImageMappings(this.batch);
    }

    public void createDerivativeImages() throws InvalidParameterException, ImageRecordCommitFailedException {
        if (this.batch != null) {
            CcMediaSourceRecord ccMediaSourceRecord = null;
            String string = this.generateBatchCode(this.batch.getBatchID());
            this.batchElements = this.batch.getBatchElements();
            if (this.batch.getDestDir() != null && this.resolutions != null && this.resolutions.size() > 0 && this.batchElements != null && this.batchElements.size() > 0) {
                if (!(this.batch.getUltimateUrlPrefix() == null || this.batch.getUltimateUrlPrefix().trim().equals("") || this.batch.getUltimateSidUrlPrefix() == null || this.batch.getUltimateSidUrlPrefix().trim().equals("") || this.createSpsEntries())) {
                    throw new InvalidParameterException("Could not create SPS entry.  Check to make sure you have write permission to the database.");
                }
                if (!this.createLpsEntry(this.batch.getBatchID(), this.batch.getLpsDir())) {
                    throw new InvalidParameterException("Could not create LPS entry.  Check to make sure you have write permission to the database.");
                }
                Vector<CcMediaSourceRecord> vector = new Vector<CcMediaSourceRecord>();
                for (int i = 0; this.batchElements != null && i < this.batchElements.size(); ++i) {
                    if (this.stopped) {
                        return;
                    }
                    while (this.paused) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception exception) {
                            CcMediaCreator.debugOut("Interrupted while trying to sleep: " + exception);
                        }
                    }
                    ccMediaSourceRecord = (CcMediaSourceRecord)this.batchElements.get(i);
                    this.mediaProgress.setCurrentMedia(ccMediaSourceRecord);
                    ccMediaSourceRecord.setMediaProgressListener(this.mediaProgress);
                    this.mediaProgress.setStatusMessage("Processing...");
                    if (ccMediaSourceRecord.getStatus() == 0) {
                        if (this.batch.getStartingMediaID() > 0L) {
                            ccMediaSourceRecord.setDestMediaID(this.getNextAvailableMediaID(this.batch.getStartingMediaID()));
                        } else {
                            ccMediaSourceRecord.setDestMediaID(this.getNextMediaID());
                        }
                        ccMediaSourceRecord.setResolutions(this.resolutions);
                        ccMediaSourceRecord.setBatchCode(string);
                        ccMediaSourceRecord.setPreserveFilenames(this.batch.getBatchProfile().preserveFilenames);
                        ccMediaSourceRecord.setSequenceCode(this.generateSequenceCode(i));
                        ccMediaSourceRecord.setResampleDuringResize(this.resampleDuringResize);
                        ccMediaSourceRecord.generateMedia();
                        vector.add(ccMediaSourceRecord);
                    } else {
                        this.mediaProgress.setStatusMessage("Media already processed.");
                    }
                    ++this.progressIndex;
                    ++this.completedImages;
                    this.mediaProgress.updateProgress();
                }
                this.mediaProgress.setStatusMessage("Verifying database records...");
                if (!this.verifyBatchDatabaseEntries(vector)) {
                    throw new ImageRecordCommitFailedException("Could not create all media records in database.");
                }
                this.updateObjectImageMappings();
                this.done();
                System.gc();
            } else {
                if (this.batch.getDestDir() == null) {
                    throw new InvalidParameterException("Destination directory was not specified for batch " + this.batch.toString());
                }
                if (this.resolutions == null || this.resolutions.size() == 0) {
                    throw new InvalidParameterException("No resolutions were specified for batch " + this.batch.toString());
                }
            }
        } else {
            throw new InvalidParameterException("The image batch was not defined. batch: " + this.batch);
        }
    }

    protected boolean verifyBatchDatabaseEntries(List list) {
        return this.server.verifyBatchDatabaseEntries(list);
    }

    public void setResampleDuringResize(boolean bl) {
        this.resampleDuringResize = bl;
    }

    public static void main(String[] stringArray) {
    }
}

