/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchLpsDirStructureEditComponent;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.io.File;
import javax.swing.ImageIcon;

public class CcMediaBatchLpsDirStructure
extends EditableDataObject {
    protected CollectionServer collectionServer;
    protected CcMediaBatch batch;
    protected String startPath = "";
    protected String endPath = "";
    protected CcMediaBatchLpsDirStructureEditComponent editComponent = null;

    public CcMediaBatchLpsDirStructure(CollectionServer collectionServer, CcMediaBatch ccMediaBatch, String string, String string2) {
        this.collectionServer = collectionServer;
        this.batch = ccMediaBatch;
        this.startPath = string == null ? "" : string;
        this.endPath = string2 == null ? "" : string2;
    }

    public String toString() {
        return CcMediaBatchLpsDirStructure.subtractFilePaths(this.startPath, this.endPath);
    }

    public String getStartPath() {
        return this.startPath;
    }

    public String getEndPath() {
        return this.endPath;
    }

    public static String subtractFilePaths(String string, String string2) {
        String string3 = string2;
        if (!string2.toUpperCase().startsWith(string.toUpperCase())) {
            return string3;
        }
        try {
            int n = string.length();
            string3 = string2.substring(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (string3.startsWith("" + File.separator) && string3.length() > 1) {
            string3 = string3.substring(1);
        }
        while (string3.endsWith("" + File.separator) && string3.length() > 1) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        string3 = string3.replace(File.separatorChar, '/');
        return string3;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcMediaBatchLpsDirStructureEditComponent();
        this.editComponent.getStartPathField().setText(this.startPath.replace('/', File.separatorChar));
        this.editComponent.getEndPathField().setText(this.endPath.replace('/', File.separatorChar));
        this.editComponent.getStartPathField().selectAll();
        this.editComponent.getStartPathField().requestFocus();
        return this.editComponent;
    }

    public void save() {
        CcMediaBatchLpsDirStructure.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.startPath, this.editComponent.getStartPathField().getText())) {
            this.startPath = this.editComponent.getStartPathField().getText();
        }
        if (this.hasChanged(this.endPath, this.editComponent.getEndPathField().getText())) {
            this.endPath = this.editComponent.getEndPathField().getText();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.batch.lpsDir = this.toString();
            this.batch.updateEditComponentLpsDir();
        }
        this.collectionServer.cancelEdit(this);
    }

    public void cancel() {
        CcMediaBatchLpsDirStructure.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "LPS Directory Structure";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return this.batch.getUniqueIdentifier() + "-LPSDIR";
    }

    public static void debugOut(String string) {
        CcMediaBatchLpsDirStructure.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatchLpsDirStructure: " + string, n);
    }
}

