/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatch;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchProcessListItem;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.io.File;

public abstract class CcMediaBatchElement
implements IndexedObject,
DatabaseRecord {
    public static final int NOT_PROCESSED = 0;
    public static final int PROCESSED_SUCCESS = 1;
    public static final int PROCESSED_ERROR = 2;
    public static final int PUBLISHED = 3;
    protected CcMediaBatch batch;
    protected long batchElementID = -1L;
    protected int status = 0;
    protected String srcFilepath = "";
    protected String srcFilename = "";
    protected String fullSrcFilepath = null;
    protected long destMediaID = -1L;
    protected String objectKey = "";
    protected int objectKeyFieldID = -1;
    protected String processedTimestamp = "";
    protected String lastPublishedTimestamp = "";

    public static void debugOut(String string) {
        CcMediaBatchElement.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatchElement: " + string, n);
    }

    public static String getStatusToString(int n) {
        if (n == 0) {
            return "PENDING";
        }
        if (n == 1) {
            return "PROCESSED-SUCCESS";
        }
        if (n == 2) {
            return "PROCESSED-ERROR";
        }
        if (n == 3) {
            return "PUBLISHED";
        }
        return "STATUS UKNOWN";
    }

    public CcMediaBatchElement(CcMediaBatch ccMediaBatch, long l, int n, String string, String string2, long l2, int n2, String string3, String string4, String string5) {
        this.batch = ccMediaBatch;
        this.batchElementID = l;
        this.status = n;
        this.srcFilepath = string == null ? "" : InsightUtilities.rightTrimSlashes(string);
        this.srcFilename = string2 == null ? "" : InsightUtilities.leftTrimSlashes(string2);
        this.destMediaID = l2;
        this.objectKeyFieldID = n2;
        this.objectKey = string3;
        String string6 = "";
        this.processedTimestamp = string4 == null ? string6 : string4;
        this.lastPublishedTimestamp = string5 == null ? string6 : string5;
    }

    public CcMediaBatchElement(CcMediaBatchProcessListItem ccMediaBatchProcessListItem) {
        if (ccMediaBatchProcessListItem != null) {
            this.batch = ccMediaBatchProcessListItem.getBatch();
            this.batchElementID = ccMediaBatchProcessListItem.getBatchElementID();
            this.status = ccMediaBatchProcessListItem.getBatchElementStatus();
            this.srcFilepath = InsightUtilities.rightTrimSlashes(ccMediaBatchProcessListItem.getSourceFileItem().getFileParent());
            this.srcFilename = InsightUtilities.leftTrimSlashes(ccMediaBatchProcessListItem.getSourceFileItem().getFileName());
            this.destMediaID = ccMediaBatchProcessListItem.getDestMediaID();
            this.objectKeyFieldID = ccMediaBatchProcessListItem.getBatch().getMappingFieldID();
            this.objectKey = ccMediaBatchProcessListItem.getObjectLinkItem().getObjectLink();
            this.processedTimestamp = ccMediaBatchProcessListItem.getProcessedTimestamp();
            this.lastPublishedTimestamp = ccMediaBatchProcessListItem.getLastPublishedTimestamp();
        }
    }

    public void setBatchElementID(long l) {
        this.batchElementID = l;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setSrcFilepath(String string) {
        this.srcFilepath = string;
    }

    public void setSrcFilename(String string) {
        this.srcFilename = string;
    }

    public void setDestMediaID(long l) {
        this.destMediaID = l;
    }

    public void setObjectKeyFieldID(int n) {
        this.objectKeyFieldID = n;
    }

    public void setObjectKey(String string) {
        this.objectKey = string;
    }

    public void setProcessedTimestamp(String string) {
        this.processedTimestamp = string;
    }

    public void setLastPublishedTimestamp(String string) {
        this.lastPublishedTimestamp = string;
    }

    public int getBatchID() {
        return this.batch.getBatchID();
    }

    public CcMediaBatch getBatch() {
        return this.batch;
    }

    public long getBatchElementID() {
        return this.batchElementID;
    }

    public int getStatus() {
        return this.status;
    }

    public String getSrcFilepath() {
        return this.srcFilepath;
    }

    public String getSrcFilename() {
        return this.srcFilename;
    }

    public long getDestMediaID() {
        return this.destMediaID;
    }

    public int getObjectKeyFieldID() {
        return this.objectKeyFieldID;
    }

    public String getObjectKey() {
        return this.objectKey;
    }

    public String getProcessedTimestamp() {
        return this.processedTimestamp;
    }

    public String getLastPublishedTimestamp() {
        return this.lastPublishedTimestamp;
    }

    public String getFullSrcFilepath() {
        if (this.fullSrcFilepath == null || this.fullSrcFilepath.length() == 0) {
            this.fullSrcFilepath = this.getSrcFilepath() + File.separator + this.getSrcFilename();
        }
        return this.fullSrcFilepath;
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseRecord) {
            return this.equalsRecord((DatabaseRecord)object);
        }
        return super.equals(object);
    }

    public int getIndex() {
        return (int)this.getBatchElementID();
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMediaBatchElement) {
            return this.getBatchElementID() == ((CcMediaBatchElement)databaseRecord).getBatchElementID() && this.getBatchID() == ((CcMediaBatchElement)databaseRecord).getBatchID();
        }
        return false;
    }
}

