/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.field.CollectionServerField;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchEditComponent;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchElement;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchLpsDirStructure;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchProcessListItem;
import com.luna.insight.admin.collserver.mediacreation.CcMediaBatchProcessListManager;
import com.luna.insight.admin.collserver.mediacreation.CcMediaCreator;
import com.luna.insight.admin.collserver.mediacreation.CcMediaSourceRecord;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import com.luna.insight.server.InsightUtilities;
import java.awt.Container;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;

public class CcMediaBatch
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public static String PRECOMPUTED_LPS_DIR_PREFIX = "D";
    public static int PRECOMPUTED_LPS_DIR_DIGITS = 4;
    protected Integer uniqueCollectionID;
    protected Collection collection;
    protected int batchID;
    protected String batchName;
    protected int batchStatus;
    protected int resProfileID;
    protected String destDir;
    protected String lpsDir;
    protected String logFilepath;
    protected String mappingFilepath;
    protected int mappingFieldID;
    protected CcMediaBatchEditComponent editComponent = null;
    protected CcTaskItem taskItem;
    protected List batchElements = null;
    protected CcBatchProfile batchProfile = null;
    protected List resolutions = null;
    protected CcMediaBatchProcessListManager processListManager = new CcMediaBatchProcessListManager(this);
    protected long startingMediaID = -1L;

    public static void debugOut(String string) {
        CcMediaBatch.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMediaBatch: " + string, n);
    }

    public CcMediaBatch(Integer n, int n2, Collection collection) {
        this.uniqueCollectionID = n;
        this.batchID = n2;
        this.collection = collection;
        this.lpsDir = this.getPrecomputedLpsDir();
    }

    public CcMediaBatch(Integer n, Collection collection, int n2, String string, int n3, int n4, String string2, String string3, String string4, String string5, int n5, long l) {
        this.uniqueCollectionID = n;
        this.collection = collection;
        this.batchID = n2;
        this.batchName = string == null ? "" : string;
        this.batchStatus = n3;
        this.resProfileID = n4;
        this.destDir = InsightUtilities.rightTrimSlashes(string2 == null ? "" : string2);
        this.lpsDir = string3 == null ? "" : string3;
        this.logFilepath = string4 == null ? "" : string4;
        this.mappingFilepath = string5 == null ? "" : string5;
        this.mappingFieldID = n5;
        this.startingMediaID = l;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public CollectionServer getServer() {
        return this.collection.getServer();
    }

    public int getBatchID() {
        return this.batchID;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public int getBatchStatus() {
        return this.batchStatus;
    }

    public int getBatchProfileID() {
        return this.resProfileID;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public String getLpsDir() {
        return this.lpsDir;
    }

    public String getLogFilepath() {
        return this.logFilepath;
    }

    public String getMappingFilepath() {
        return this.mappingFilepath;
    }

    public int getMappingFieldID() {
        return this.mappingFieldID;
    }

    public long getStartingMediaID() {
        return this.startingMediaID;
    }

    public void setBatchStatus(int n) {
        this.batchStatus = n;
    }

    public void setTaskItem(CcTaskItem ccTaskItem) {
        this.taskItem = ccTaskItem;
    }

    public String getUltimateUrlPrefix() {
        if (this.getBatchProfile() == null) {
            return null;
        }
        return this.getBatchProfile().urlPrefix;
    }

    public String getUltimateSidUrlPrefix() {
        if (this.getBatchProfile() == null) {
            return null;
        }
        return this.getBatchProfile().sidUrlPrefix;
    }

    public String getPrecomputedLpsDir() {
        StringBuffer stringBuffer = new StringBuffer("" + this.batchID);
        while (stringBuffer.length() < PRECOMPUTED_LPS_DIR_DIGITS) {
            stringBuffer.insert(0, '0');
        }
        stringBuffer.insert(0, PRECOMPUTED_LPS_DIR_PREFIX);
        return stringBuffer.toString();
    }

    public CcMediaBatchElement getBatchElement(long l) {
        this.getBatchElements();
        Iterator iterator = this.batchElements.iterator();
        while (iterator.hasNext()) {
            CcMediaBatchElement ccMediaBatchElement = (CcMediaBatchElement)iterator.next();
            if (ccMediaBatchElement.getDestMediaID() != l) continue;
            return ccMediaBatchElement;
        }
        return null;
    }

    public List getBatchElements() {
        if (this.batchElements == null) {
            this.batchElements = this.collection.getServer().getCollectionServerConnector().getMediaBatchElements(this);
        }
        return this.batchElements;
    }

    public CcBatchProfile getBatchProfile() {
        if (this.batchProfile == null) {
            this.batchProfile = CcBatchProfile.isDefaultProfile(this.getBatchProfileID()) ? CcBatchProfile.getDefaultProfile(this.collection.getServer(), this.getBatchProfileID()) : this.collection.getServer().getCollectionServerConnector().getBatchProfileRecord(this.getBatchProfileID());
        }
        return this.batchProfile;
    }

    public List getResolutions() {
        if (this.resolutions == null) {
            this.resolutions = CcBatchProfile.isDefaultProfile(this.getBatchProfileID()) ? CcBatchProfile.getDefaultProfile((CollectionServer)this.collection.getServer(), (int)this.getBatchProfileID()).resolutions : this.collection.getServer().getCollectionServerConnector().getResolutionRecords(this.getBatchProfileID());
        }
        return this.resolutions;
    }

    public CcMediaBatchLpsDirStructure getLpsDirStructure() {
        return new CcMediaBatchLpsDirStructure(this.collection.getServer(), this, "", this.lpsDir);
    }

    public String toString() {
        return this.getBatchName();
    }

    public int getIndex() {
        return this.batchID;
    }

    public EditComponent getEditComponent() {
        EditableDataObject editableDataObject;
        this.editComponent = new CcMediaBatchEditComponent(this);
        this.processListManager = new CcMediaBatchProcessListManager(this);
        Vector vector = this.collection.getServer().getBatchProfiles();
        vector.insertElementAt(CcBatchProfile.getDefaultProfile(this.collection.getServer(), -1), 0);
        vector.insertElementAt(CcBatchProfile.getDefaultProfile(this.collection.getServer(), -2), 0);
        CcBatchProfile ccBatchProfile = null;
        for (int i = 0; i < vector.size(); ++i) {
            editableDataObject = (CcBatchProfile)vector.get(i);
            if (editableDataObject == null) continue;
            this.editComponent.getProfileComboBox().addItem(editableDataObject);
            if (this.resProfileID != ((CcBatchProfile)editableDataObject).getIndex()) continue;
            this.editComponent.getProfileComboBox().setSelectedItem(editableDataObject);
            ccBatchProfile = editableDataObject;
        }
        this.editComponent.getBatchNameField().setText(this.batchName);
        this.editComponent.getDestinationField().setText(this.destDir);
        this.editComponent.getLpsDirectoryField().setText(this.lpsDir);
        this.editComponent.getLogFileField().setText(this.logFilepath);
        if (this.startingMediaID > 0L) {
            this.editComponent.getStartingMediaIdField().setText(this.startingMediaID + "");
        }
        this.editComponent.getMappingFileField().setText(this.mappingFilepath);
        if (ccBatchProfile != null && ccBatchProfile.preserveDirStructure) {
            this.editComponent.getLpsDirStructureButton().setVisible(true);
        } else {
            this.editComponent.getLpsDirStructureButton().setVisible(false);
        }
        Vector vector2 = this.collection.getServer().getFields(this.collection.getTemplateID());
        for (int i = 0; i < vector2.size(); ++i) {
            editableDataObject = (CollectionServerField)vector2.elementAt(i);
            this.editComponent.getFieldComboBox().addItem(editableDataObject);
            if (this.mappingFieldID != ((CollectionServerField)editableDataObject).getIndex()) continue;
            this.editComponent.getFieldComboBox().setSelectedItem(editableDataObject);
        }
        this.getBatchElements();
        for (int i = 0; i < this.batchElements.size(); ++i) {
            CcMediaBatchElement ccMediaBatchElement = (CcMediaBatchElement)this.batchElements.get(i);
            if (ccMediaBatchElement == null) continue;
            this.processListManager.addItemToProcessList(new CcMediaBatchProcessListItem(ccMediaBatchElement));
        }
        return this.editComponent;
    }

    public void save() {
        String string;
        CcMediaBatch.debugOut("Save.", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.batchName, this.editComponent.getBatchNameField().getText())) {
            this.batchName = this.editComponent.getBatchNameField().getText();
        }
        if (this.hasChanged(this.destDir, this.editComponent.getDestinationField().getText())) {
            this.destDir = this.editComponent.getDestinationField().getText();
        }
        if (this.hasChanged(this.lpsDir, this.editComponent.getLpsDirectoryField().getText())) {
            this.lpsDir = this.editComponent.getLpsDirectoryField().getText();
        }
        if (this.hasChanged(this.logFilepath, this.editComponent.getLogFileField().getText())) {
            this.logFilepath = this.editComponent.getLogFileField().getText();
        }
        if ((string = this.editComponent.getStartingMediaIdField().getText()) == null || string.trim().equals("")) {
            string = "-1";
        }
        try {
            if (this.hasChanged(this.startingMediaID + "", string)) {
                this.startingMediaID = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.mappingFilepath, this.editComponent.getMappingFileField().getText())) {
            this.mappingFilepath = this.editComponent.getMappingFileField().getText();
        }
        try {
            int n = ((CollectionServerField)this.editComponent.getFieldComboBox().getSelectedItem()).getIndex();
            if (this.hasChanged(this.mappingFieldID, n)) {
                this.mappingFieldID = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n = ((CcBatchProfile)this.editComponent.getProfileComboBox().getSelectedItem()).getIndex();
            if (this.hasChanged(this.resProfileID, n)) {
                this.resProfileID = n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Vector vector = this.getUpdatedElementsFromEditComponent();
        if (this.haveBatchElementsChanged(this.batchElements, vector)) {
            this.batchElements = vector;
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collection.getServer().commitDataObject(this);
        } else {
            this.cancelEdit();
        }
    }

    public void cancel() {
        CcMediaBatch.debugOut("Cancel.", 3);
        this.editComponent = null;
        this.cancelEdit();
    }

    private void cancelEdit() {
        this.collection.getServer().cancelEdit(this);
        if (this.taskItem != null) {
            this.taskItem.setTaskItemCancelled();
        }
    }

    public String getEditWindowTitle() {
        String string = "Media Batch";
        if (this.getBatchName() != null && !this.getBatchName().trim().equals("")) {
            string = string + " - " + this.getBatchName();
        }
        return string;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseRecord) {
            return this.equalsRecord((DatabaseRecord)object);
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMediaBatch) {
            return this.getBatchID() == ((CcMediaBatch)databaseRecord).getBatchID();
        }
        return false;
    }

    public void startBatchProcessing() {
        CcMediaBatch.debugOut("Start batch processing.");
        this.save();
        EditDialog editDialog = this.getParentEditDialog();
        if (editDialog != null) {
            editDialog.closeDialog(null);
        }
        CcMediaCreator ccMediaCreator = new CcMediaCreator(this.collection.getServer(), this);
        ccMediaCreator.setTaskItem(this.taskItem);
        ccMediaCreator.setResampleDuringResize(this.collection.getServer().getInsightAdministrator().readResampleDuringResize());
        ccMediaCreator.show();
    }

    protected EditDialog getParentEditDialog() {
        if (this.editComponent == null) {
            return null;
        }
        for (Container container = this.editComponent.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof EditDialog)) continue;
            return (EditDialog)container;
        }
        return null;
    }

    public boolean haveBatchElementsChanged(List list, List list2) {
        boolean bl = false;
        List list3 = list;
        List list4 = list2;
        if (this.requiresCommit || list3.size() != list4.size()) {
            bl = true;
        } else {
            for (int i = 0; !bl && i < list4.size(); ++i) {
                if (list3.contains((CcMediaBatchElement)list4.get(i))) continue;
                bl = true;
            }
        }
        if (bl) {
            this.requiresCommit = true;
        }
        return bl;
    }

    protected Vector getUpdatedElementsFromEditComponent() {
        Vector<CcMediaSourceRecord> vector = new Vector<CcMediaSourceRecord>();
        DefaultListModel defaultListModel = (DefaultListModel)this.editComponent.getProcessList().getModel();
        Enumeration enumeration = defaultListModel.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(new CcMediaSourceRecord(this.collection, (CcMediaBatchProcessListItem)enumeration.nextElement()));
        }
        return vector;
    }

    public void updateEditComponentLpsDir() {
        this.editComponent.getLpsDirectoryField().setText(this.lpsDir != null ? this.lpsDir : "");
    }

    public void loadMappingFileIntoEditComponent() {
        if (this.processListManager != null) {
            this.processListManager.loadMappingFileIntoEditComponent();
        }
    }

    public void addMatchToProcessList() {
        if (this.processListManager != null) {
            this.processListManager.addMatchToProcessList();
        }
    }

    public void removeFromProcessList() {
        if (this.processListManager != null) {
            this.processListManager.removeFromProcessList();
        }
    }

    public void addSourceFiles(File[] fileArray) {
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            this.addSourceFile(fileArray[i]);
        }
    }

    public void addSourceFile(File file) {
        if (this.processListManager != null) {
            this.processListManager.addSourceFiles(file);
        }
    }

    public void matchObjectsAndMedia() {
        if (this.processListManager != null) {
            this.processListManager.matchObjectsAndMedia();
        }
    }
}

