/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcImageCreationSpecialSettingsJpeg;
import com.luna.insight.admin.collserver.mediacreation.CcImageCreationSpecialSettingsSid;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class CcBatchProfileResolutionRecordHandler
extends DatabaseRecordHandler {
    public CcBatchProfileResolutionRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcBatchProfileResolutionRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionSetID", 2, stringBuffer2, ccBatchProfileResolution.getProfileID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionSize", 2, stringBuffer2, ccBatchProfileResolution.getResolutionNumber() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "MediaType", 2, stringBuffer2, ccBatchProfileResolution.getFormat() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "ResolutionPixelsIndex", 2, stringBuffer2, "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "DirectoryName", 1, stringBuffer2, "");
            if (ccBatchProfileResolution.getFormat() == 0) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JpegCompression", 2, stringBuffer2, ccBatchProfileResolution.getJpegSettings().jpegCompression + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JpegBrightnessEnabled", 2, stringBuffer2, ccBatchProfileResolution.getJpegSettings().useBrightness ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JpegEdgeTrimEnabled", 2, stringBuffer2, ccBatchProfileResolution.getJpegSettings().automaticTrimEdges ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JpegForceUpsize", 2, stringBuffer2, ccBatchProfileResolution.getJpegSettings().forceUpsize ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JpegBrightness", 2, stringBuffer2, ccBatchProfileResolution.getJpegSettings().brightness + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JpegEdgeTrim", 2, stringBuffer2, ccBatchProfileResolution.getJpegSettings().edgeThreshold + "");
            } else if (ccBatchProfileResolution.getFormat() == 1) {
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidCompressionEnabled", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().nonDefaultSidCompressionRatio ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidCompression", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().sidCompressionRatio + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidZoomLevelsEnabled", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().nonDefaultSidZoomLevels ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidZoomLevels", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().sidZoomLevels + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidGammaEnabled", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().nonDefaultSidGamma ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidGamma", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().sidGamma + "");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidWeightEnabled", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().nonDefaultSidWeight ? "1" : "0");
                sqlQueryGenerator.appendFieldAndValue(stringBuffer, "SidWeight", 2, stringBuffer2, ccBatchProfileResolution.getSidSettings().sidWeight + "");
            }
            databaseConnector.setQuery("INSERT INTO CCIMAGECREATIONRESOLUTIONS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert profile resolution query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CCIMAGECREATIONRESOLUTIONS WHERE ResolutionSetID = " + ((CcBatchProfileResolution)databaseRecord).getProfileID() + " AND ResolutionSize = " + ((CcBatchProfileResolution)databaseRecord).getResolutionNumber();
            databaseConnector.setQuery(string);
            this.debugOut("deleteResolutionQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public void clearRecords(int n) {
        this.debugOut("in clearRecords()");
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM CCIMAGECREATIONRESOLUTIONS WHERE ResolutionSetID = " + n;
            databaseConnector.setQuery(string);
            this.debugOut("deleteResolutionsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCIMAGECREATIONRESOLUTIONS", null, "*");
            sqlQueryGenerator.addOrderBy("CCIMAGECREATIONRESOLUTIONS", "ResolutionSetID");
            sqlQueryGenerator.addOrderBy("CCIMAGECREATIONRESOLUTIONS", "ResolutionSize");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Resolutions query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CcBatchProfileResolution ccBatchProfileResolution = new CcBatchProfileResolution((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("MediaType"), databaseConnector.getIntegerFieldByName("ResolutionSize"));
                    if (ccBatchProfileResolution.getFormat() == 0) {
                        ccBatchProfileResolution.setJpegSettings(new CcImageCreationSpecialSettingsJpeg(ccBatchProfileResolution, databaseConnector.getIntegerFieldByName("JpegCompression"), databaseConnector.getIntegerFieldByName("JpegBrightnessEnabled") == 1, databaseConnector.getIntegerFieldByName("JpegEdgeTrimEnabled") == 1, databaseConnector.getIntegerFieldByName("JpegForceUpsize") == 1, databaseConnector.getIntegerFieldByName("JpegBrightness"), databaseConnector.getIntegerFieldByName("JpegEdgeTrim")));
                    } else if (ccBatchProfileResolution.getFormat() == 1) {
                        ccBatchProfileResolution.setSidSettings(new CcImageCreationSpecialSettingsSid(ccBatchProfileResolution, databaseConnector.getIntegerFieldByName("SidCompressionEnabled") == 1, databaseConnector.getIntegerFieldByName("SidCompression"), databaseConnector.getIntegerFieldByName("SidZoomLevelsEnabled") == 1, databaseConnector.getIntegerFieldByName("SidZoomLevels"), databaseConnector.getIntegerFieldByName("SidGammaEnabled") == 1, databaseConnector.getIntegerFieldByName("SidGamma"), databaseConnector.getIntegerFieldByName("SidWeightEnabled") == 1, databaseConnector.getIntegerFieldByName("SidWeight")));
                    }
                    vector.addElement(ccBatchProfileResolution);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public Vector getRecordsForProfile(int n) {
        this.debugOut("in getRecords()");
        Vector<CcBatchProfileResolution> vector = new Vector<CcBatchProfileResolution>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCIMAGECREATIONRESOLUTIONS", null, "*");
            sqlQueryGenerator.addOrderBy("CCIMAGECREATIONRESOLUTIONS", "ResolutionSetID");
            sqlQueryGenerator.addOrderBy("CCIMAGECREATIONRESOLUTIONS", "ResolutionSize");
            sqlQueryGenerator.appendToWhere("ResolutionSetID=" + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Resolutions query: \n" + databaseConnector.getQuery());
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CcBatchProfileResolution ccBatchProfileResolution = new CcBatchProfileResolution((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("MediaType"), databaseConnector.getIntegerFieldByName("ResolutionSize"));
                    ccBatchProfileResolution.setBatchProfileParent(new CcBatchProfile(n, null));
                    if (ccBatchProfileResolution.getFormat() == 0) {
                        ccBatchProfileResolution.setJpegSettings(new CcImageCreationSpecialSettingsJpeg(ccBatchProfileResolution, databaseConnector.getIntegerFieldByName("JpegCompression"), databaseConnector.getIntegerFieldByName("JpegBrightnessEnabled") == 1, databaseConnector.getIntegerFieldByName("JpegEdgeTrimEnabled") == 1, databaseConnector.getIntegerFieldByName("JpegForceUpsize") == 1, databaseConnector.getIntegerFieldByName("JpegBrightness"), databaseConnector.getIntegerFieldByName("JpegEdgeTrim")));
                    } else if (ccBatchProfileResolution.getFormat() == 1) {
                        ccBatchProfileResolution.setSidSettings(new CcImageCreationSpecialSettingsSid(ccBatchProfileResolution, databaseConnector.getIntegerFieldByName("SidCompressionEnabled") == 1, databaseConnector.getIntegerFieldByName("SidCompression"), databaseConnector.getIntegerFieldByName("SidZoomLevelsEnabled") == 1, databaseConnector.getIntegerFieldByName("SidZoomLevels"), databaseConnector.getIntegerFieldByName("SidGammaEnabled") == 1, databaseConnector.getIntegerFieldByName("SidGamma"), databaseConnector.getIntegerFieldByName("SidWeightEnabled") == 1, databaseConnector.getIntegerFieldByName("SidWeight")));
                    }
                    if (ccBatchProfileResolution.getFormat() != 13 || InsightAdministrator.LICENSED_JP2K_ENCODER) {
                        vector.addElement(ccBatchProfileResolution);
                    }
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcBatchProfileResolution ccBatchProfileResolution = null;
        int n = ((CcBatchProfileResolution)databaseRecord).getProfileID();
        int n2 = ((CcBatchProfileResolution)databaseRecord).getResolutionNumber();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("CCIMAGECREATIONRESOLUTIONS", null, "*");
            sqlQueryGenerator.appendToWhere("ResolutionSetID = " + n + " AND ResolutionSize = " + n2);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Resolution query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccBatchProfileResolution = new CcBatchProfileResolution((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("MediaType"), databaseConnector.getIntegerFieldByName("ResolutionSize"));
                if (ccBatchProfileResolution.getFormat() == 0) {
                    ccBatchProfileResolution.setJpegSettings(new CcImageCreationSpecialSettingsJpeg(ccBatchProfileResolution, databaseConnector.getIntegerFieldByName("JpegCompression"), databaseConnector.getIntegerFieldByName("JpegBrightnessEnabled") == 1, databaseConnector.getIntegerFieldByName("JpegEdgeTrimEnabled") == 1, databaseConnector.getIntegerFieldByName("JpegForceUpsize") == 1, databaseConnector.getIntegerFieldByName("JpegBrightness"), databaseConnector.getIntegerFieldByName("JpegEdgeTrim")));
                } else if (ccBatchProfileResolution.getFormat() == 1) {
                    ccBatchProfileResolution.setSidSettings(new CcImageCreationSpecialSettingsSid(ccBatchProfileResolution, databaseConnector.getIntegerFieldByName("SidCompressionEnabled") == 1, databaseConnector.getIntegerFieldByName("SidCompression"), databaseConnector.getIntegerFieldByName("SidZoomLevelsEnabled") == 1, databaseConnector.getIntegerFieldByName("SidZoomLevels"), databaseConnector.getIntegerFieldByName("SidGammaEnabled") == 1, databaseConnector.getIntegerFieldByName("SidGamma"), databaseConnector.getIntegerFieldByName("SidWeightEnabled") == 1, databaseConnector.getIntegerFieldByName("SidWeight")));
                }
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return ccBatchProfileResolution;
    }

    public String getNextValidIDQuery() {
        return "SELECT ResolutionSetID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "CCIMAGECREATIONRESOLUTIONS" + " ORDER BY ResolutionSetID";
    }

    public void updateMaxIDValue(long l) {
    }
}

