/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditDialog;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolutionEditComponent;
import com.luna.insight.admin.collserver.mediacreation.CcImageCreationSpecialSettingsJpeg;
import com.luna.insight.admin.collserver.mediacreation.CcImageCreationSpecialSettingsSid;
import com.luna.insight.client.IconMaker;
import com.luna.insight.client.media.MediaFileMetadata;
import com.luna.insight.server.Debug;
import com.luna.insight.server.mediacreation.IMediaBatchProfileResolution;
import com.luna.insight.server.mediacreation.MediaBatchProfileResolution;
import java.io.File;
import java.security.InvalidParameterException;
import javax.swing.ImageIcon;

public class CcBatchProfileResolution
extends EditableDataObject
implements DatabaseRecord {
    public static final int[] PIXEL_SIZES = IMediaBatchProfileResolution.PIXEL_SIZES;
    public static final int[] DEFAULT_RESOLUTION_TYPES_JP2_UNLICENSED = new int[]{0, 0, 0, 0, 0};
    public static final int[] DEFAULT_RESOLUTION_TYPES_JP2 = new int[]{0, 0, 0, 0, 0, 13, 13, 13, 13};
    public static final int[] DEFAULT_RESOLUTION_TYPES_SID = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1};
    private int mediaType = 1;
    private int format = 0;
    private int resolutionNumber;
    private int pixelSize = -1;
    protected CcImageCreationSpecialSettingsSid sidSettings = new CcImageCreationSpecialSettingsSid(this);
    protected CcImageCreationSpecialSettingsJpeg jpegSettings = new CcImageCreationSpecialSettingsJpeg(this);
    protected CcBatchProfile ccBatchProfile = null;
    protected CollectionServer collectionServer = null;
    protected CcBatchProfileResolutionEditComponent editComponent = null;
    protected EditDialog specialSettingsEditDialog = null;

    public CcBatchProfileResolution(CollectionServer collectionServer, int n, int n2) throws InvalidParameterException {
        this.collectionServer = collectionServer;
        if (n == 100) {
            n = 0;
        } else if (n == 200) {
            n = 1;
        }
        if (n != 0 && n != 1 && n != 13) {
            throw new InvalidParameterException("ImageType parm must be a valid image type.");
        }
        this.format = n;
        if (n2 < 0) {
            throw new InvalidParameterException("Resolution number must be non-negative.");
        }
        this.resolutionNumber = n2;
        this.jpegSettings = new CcImageCreationSpecialSettingsJpeg(this);
    }

    public CcBatchProfileResolution getCopy() {
        CcBatchProfileResolution ccBatchProfileResolution = new CcBatchProfileResolution(this.collectionServer, this.format, this.resolutionNumber);
        ccBatchProfileResolution.pixelSize = this.pixelSize;
        ccBatchProfileResolution.setBatchProfileParent(this.ccBatchProfile);
        ccBatchProfileResolution.editComponent = this.editComponent;
        ccBatchProfileResolution.setJpegSettings(this.jpegSettings);
        ccBatchProfileResolution.setSidSettings(this.sidSettings);
        return ccBatchProfileResolution;
    }

    public void setJpegSettings(CcImageCreationSpecialSettingsJpeg ccImageCreationSpecialSettingsJpeg) {
        this.jpegSettings = ccImageCreationSpecialSettingsJpeg;
    }

    public void setSidSettings(CcImageCreationSpecialSettingsSid ccImageCreationSpecialSettingsSid) {
        this.sidSettings = ccImageCreationSpecialSettingsSid;
    }

    public CcImageCreationSpecialSettingsJpeg getJpegSettings() {
        if (this.jpegSettings == null) {
            this.jpegSettings = new CcImageCreationSpecialSettingsJpeg(this);
        }
        return this.jpegSettings;
    }

    public CcImageCreationSpecialSettingsSid getSidSettings() {
        if (this.sidSettings == null) {
            this.sidSettings = new CcImageCreationSpecialSettingsSid(this);
        }
        return this.sidSettings;
    }

    public int getResolutionNumber() {
        return this.resolutionNumber;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public int getFormat() {
        return this.format;
    }

    public int getProfileID() {
        int n = 0;
        if (this.ccBatchProfile != null) {
            n = this.ccBatchProfile.profileID;
        }
        return n;
    }

    public int getResolutionPixels() {
        if (this.pixelSize != -1) {
            return this.pixelSize;
        }
        return PIXEL_SIZES[this.resolutionNumber];
    }

    public int getDefaultResolutionPixels() {
        return PIXEL_SIZES[this.resolutionNumber];
    }

    public int getMinimumPixelSize() {
        if (this.resolutionNumber == 0) {
            return 0;
        }
        return PIXEL_SIZES[this.resolutionNumber - 1] + 1;
    }

    public static int determineResolutionForSize(int n) {
        return MediaBatchProfileResolution.determineResolutionForSize(n);
    }

    public String getRelativeDirectoryPath() {
        return this.getRelativeDirectoryPath(this.mediaType);
    }

    public String getRelativeDirectoryPath(int n) {
        return CcBatchProfileResolution.getRelativeDirectoryPath(n, this.resolutionNumber, this.format);
    }

    public static String getRelativeDirectoryPath(int n, int n2, int n3) {
        if (n == 1) {
            if (n3 == 13) {
                return "JP2K";
            }
            if (n3 == 1) {
                return "SIDS";
            }
            return "Size" + n2;
        }
        if (n2 == 2) {
            return MediaFileMetadata.getMediaTypeName(n);
        }
        return MediaFileMetadata.getMediaTypeName(n) + File.separator + "Size" + n2;
    }

    public String getUniqueIdentifier() {
        if (this.ccBatchProfile != null) {
            return this.ccBatchProfile.getUniqueIdentifier() + "-Res" + this.resolutionNumber;
        }
        return "";
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcBatchProfileResolutionEditComponent(this);
        this.editComponent.getResolutionNumberLabel().setText("" + this.resolutionNumber);
        if (this.format == 13 && InsightAdministrator.LICENSED_JP2K_ENCODER) {
            this.editComponent.getJp2RadioButton().setSelected(true);
            this.editComponent.getSettingsButton().setEnabled(false);
        } else if (this.format == 13 && !InsightAdministrator.LICENSED_JP2K_ENCODER) {
            this.editComponent.getJp2RadioButton().setSelected(true);
            this.editComponent.getSettingsButton().setEnabled(false);
        } else if (this.format == 1) {
            this.editComponent.getSidRadioButton().setSelected(true);
            this.editComponent.getSettingsButton().setEnabled(true);
        } else {
            this.editComponent.getJpegRadioButton().setSelected(true);
            this.editComponent.getSettingsButton().setEnabled(true);
        }
        return this.editComponent;
    }

    public void save() {
        this.requiresCommit = false;
        this.creationCompleted = true;
    }

    public void cancel() {
        this.editComponent = null;
    }

    public String getEditWindowTitle() {
        return "Image Creation Profile";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-field-groups-node-icon.gif");
    }

    public int getIndex() {
        return this.resolutionNumber;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcBatchProfileResolution) {
            CcBatchProfileResolution ccBatchProfileResolution = (CcBatchProfileResolution)databaseRecord;
            return this.getResolutionNumber() == ccBatchProfileResolution.getResolutionNumber() && this.getMediaType() == ccBatchProfileResolution.getMediaType() && this.getFormat() == ccBatchProfileResolution.getFormat() && (this.getFormat() == 0 && this.jpegSettings.equalsRecord(ccBatchProfileResolution.getJpegSettings()) || this.getFormat() == 1 && this.sidSettings.equalsRecord(ccBatchProfileResolution.getSidSettings()) || this.getFormat() == 13);
        }
        return false;
    }

    public void setNonDefaultPixelSize(int n) {
        this.pixelSize = n;
    }

    public void editJpegSettings() {
        if (this.specialSettingsEditDialog == null) {
            if (this.jpegSettings != null) {
                this.specialSettingsEditDialog = new EditDialog(InsightAdministrator.getInsightAdministrator().getFrame(), true, this.jpegSettings);
                this.specialSettingsEditDialog.show();
            }
        } else {
            InsightAdministrator.getInsightAdministrator().setSelectedFrame(this.specialSettingsEditDialog);
        }
    }

    public void editSidSettings() {
        if (this.specialSettingsEditDialog == null) {
            if (this.sidSettings != null) {
                this.specialSettingsEditDialog = new EditDialog(InsightAdministrator.getInsightAdministrator().getFrame(), true, this.sidSettings);
                this.specialSettingsEditDialog.show();
            }
        } else {
            InsightAdministrator.getInsightAdministrator().setSelectedFrame(this.specialSettingsEditDialog);
        }
    }

    public void clearSpecialSettingsEditDialog() {
        this.specialSettingsEditDialog = null;
    }

    public void updateFromEditComponent() {
        if (this.editComponent == null) {
            this.editComponent = (CcBatchProfileResolutionEditComponent)this.getEditComponent();
        }
        this.format = this.editComponent.getJp2RadioButton().isSelected() ? 13 : (this.editComponent.getSidRadioButton().isSelected() ? 1 : 0);
    }

    public String toString() {
        return "[CcBatchProfileResolution: resolution=" + this.resolutionNumber + ", format=" + this.format + "]";
    }

    public void setBatchProfileParent(CcBatchProfile ccBatchProfile) {
        this.ccBatchProfile = ccBatchProfile;
        if (ccBatchProfile != null) {
            this.collectionServer = ccBatchProfile.collectionServer;
        }
    }

    public static void debugOut(String string) {
        CcBatchProfileResolution.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcBatchProfileResolution: " + string, n);
    }
}

