/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.mediacreation;

import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfile;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolution;
import com.luna.insight.admin.collserver.mediacreation.CcBatchProfileResolutionEditComponent;
import com.luna.insight.admin.verifier.NonDuplicateJTextComponentVerifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class CcBatchProfileEditComponent
extends EditComponent {
    private CcBatchProfile ccBatchProfile = null;
    private int resolutionCount = 0;
    private JLabel profileNameLabel;
    private JTextField profileNameField;
    private JButton copyButton;
    private JButton newButton;
    private JLabel urlPrefixLabel;
    private JTextField urlPrefixField;
    private JLabel sidUrlPrefixLabel;
    private JTextField sidUrlPrefixField;
    private JLabel imageTypesLabel;
    private JScrollPane imageTypesScrollPane;
    private JPanel imageTypesPanel;
    private JButton addImageTypeButton;
    private JButton removeImageTypeButton;
    private JButton deleteButton;
    private JLabel spacerLabel;
    private JCheckBox preserveFilenamesCheckBox;
    private JCheckBox preserveDirectoriesCheckBox;

    public CcBatchProfileEditComponent(CcBatchProfile ccBatchProfile) {
        this.ccBatchProfile = ccBatchProfile;
        this.initComponents();
        if (ccBatchProfile != null && ccBatchProfile.resolutions != null) {
            this.resolutionCount = ccBatchProfile.resolutions.size();
        }
    }

    private void initComponents() {
        this.profileNameLabel = new JLabel();
        this.profileNameField = new JTextField();
        this.copyButton = new JButton();
        this.newButton = new JButton();
        this.urlPrefixLabel = new JLabel();
        this.urlPrefixField = new JTextField();
        this.sidUrlPrefixLabel = new JLabel();
        this.sidUrlPrefixField = new JTextField();
        this.imageTypesLabel = new JLabel();
        this.imageTypesScrollPane = new JScrollPane();
        this.imageTypesPanel = new JPanel();
        this.addImageTypeButton = new JButton();
        this.removeImageTypeButton = new JButton();
        this.deleteButton = new JButton();
        this.spacerLabel = new JLabel();
        this.preserveFilenamesCheckBox = new JCheckBox();
        this.preserveDirectoriesCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.profileNameLabel.setText("Profile Name:");
        this.profileNameLabel.setPreferredSize(new Dimension(80, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.profileNameLabel, gridBagConstraints);
        this.profileNameField.setPreferredSize(new Dimension(230, 22));
        this.profileNameField.setInputVerifier(new NonDuplicateJTextComponentVerifier(this.getOtherExistingProfileNames()));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.profileNameField, gridBagConstraints);
        this.copyButton.setText("Copy");
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcBatchProfileEditComponent.this.copyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.copyButton, gridBagConstraints);
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcBatchProfileEditComponent.this.newButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.add((Component)this.newButton, gridBagConstraints);
        this.urlPrefixLabel.setText("URL Prefix:");
        this.urlPrefixLabel.setPreferredSize(new Dimension(80, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.add((Component)this.urlPrefixLabel, gridBagConstraints);
        this.urlPrefixField.setPreferredSize(new Dimension(230, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.add((Component)this.urlPrefixField, gridBagConstraints);
        this.sidUrlPrefixLabel.setText("SID URL Prefix:");
        this.sidUrlPrefixLabel.setPreferredSize(new Dimension(90, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.add((Component)this.sidUrlPrefixLabel, gridBagConstraints);
        this.sidUrlPrefixField.setPreferredSize(new Dimension(230, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        this.add((Component)this.sidUrlPrefixField, gridBagConstraints);
        this.imageTypesLabel.setText("Image Types:");
        this.imageTypesLabel.setPreferredSize(new Dimension(75, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 180, 3);
        this.add((Component)this.imageTypesLabel, gridBagConstraints);
        this.imageTypesScrollPane.setPreferredSize(new Dimension(350, 200));
        this.imageTypesPanel.setLayout(new BoxLayout(this.imageTypesPanel, 1));
        this.imageTypesScrollPane.setViewportView(this.imageTypesPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 3, 3, 10);
        this.add((Component)this.imageTypesScrollPane, gridBagConstraints);
        this.addImageTypeButton.setText("   Add   ");
        this.addImageTypeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcBatchProfileEditComponent.this.addImageTypeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.addImageTypeButton, gridBagConstraints);
        this.removeImageTypeButton.setText("Remove");
        this.removeImageTypeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcBatchProfileEditComponent.this.removeImageTypeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.removeImageTypeButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CcBatchProfileEditComponent.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 15, 0, 3);
        this.add((Component)this.deleteButton, gridBagConstraints);
        this.spacerLabel.setText("                       ");
        this.spacerLabel.setPreferredSize(new Dimension(80, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add((Component)this.spacerLabel, gridBagConstraints);
        this.preserveFilenamesCheckBox.setText("Preserve Filenames");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.preserveFilenamesCheckBox, gridBagConstraints);
        this.preserveDirectoriesCheckBox.setText("Preserve Directory Structure");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(10, 3, 3, 3);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.preserveDirectoriesCheckBox, gridBagConstraints);
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        if (this.ccBatchProfile != null) {
            this.ccBatchProfile.deleteProfile();
        }
    }

    private void copyButtonActionPerformed(ActionEvent actionEvent) {
        CcBatchProfile ccBatchProfile = this.ccBatchProfile.collectionServer.getCollectionServerConnector().createNewBatchProfile();
        ccBatchProfile.setProfileName("Copy of " + this.profileNameField.getText());
        ccBatchProfile.setUrlPrefix(this.urlPrefixField.getText());
        Vector vector = this.ccBatchProfile.getUpdatedResolutionsFromEditComponent();
        ccBatchProfile.setResolutions(vector, true);
        ccBatchProfile.setCurrentReferencingBatch(this.ccBatchProfile.getCurrentReferencingBatch());
        this.ccBatchProfile.collectionServer.editDataObject(ccBatchProfile);
        this.ccBatchProfile.cancelEditDialogExplicit();
    }

    private void newButtonActionPerformed(ActionEvent actionEvent) {
        CcBatchProfile ccBatchProfile = this.ccBatchProfile.collectionServer.getCollectionServerConnector().createNewBatchProfile();
        ccBatchProfile.setCurrentReferencingBatch(this.ccBatchProfile.getCurrentReferencingBatch());
        this.ccBatchProfile.collectionServer.editDataObject(ccBatchProfile);
        this.ccBatchProfile.cancelEditDialogExplicit();
    }

    private void removeImageTypeButtonActionPerformed(ActionEvent actionEvent) {
        CcBatchProfileResolutionEditComponent ccBatchProfileResolutionEditComponent;
        CcBatchProfileResolution ccBatchProfileResolution = this.ccBatchProfile.getResolutionToRemove();
        if (ccBatchProfileResolution != null && (ccBatchProfileResolutionEditComponent = ccBatchProfileResolution.editComponent) != null) {
            this.imageTypesPanel.remove(ccBatchProfileResolutionEditComponent);
            this.imageTypesScrollPane.invalidate();
            this.imageTypesScrollPane.validate();
            this.imageTypesScrollPane.doLayout();
            this.imageTypesScrollPane.repaint();
            if (this.resolutionCount > 0) {
                --this.resolutionCount;
            }
        }
    }

    private void addImageTypeButtonActionPerformed(ActionEvent actionEvent) {
        if (this.resolutionCount < CcBatchProfile.MAXIMUM_RESOLUTIONS) {
            CcBatchProfileResolutionEditComponent ccBatchProfileResolutionEditComponent = (CcBatchProfileResolutionEditComponent)this.ccBatchProfile.createNewResolution().getEditComponent();
            if (ccBatchProfileResolutionEditComponent != null) {
                this.imageTypesPanel.add(ccBatchProfileResolutionEditComponent);
                this.imageTypesScrollPane.invalidate();
                this.imageTypesScrollPane.validate();
                this.imageTypesScrollPane.doLayout();
                this.imageTypesScrollPane.repaint();
            }
            ++this.resolutionCount;
        }
    }

    private Vector getOtherExistingProfileNames() {
        Vector<String> vector = new Vector<String>();
        try {
            Vector vector2 = this.ccBatchProfile.collectionServer.getBatchProfiles();
            for (int i = 0; i < vector2.size(); ++i) {
                CcBatchProfile ccBatchProfile = (CcBatchProfile)vector2.elementAt(i);
                if (ccBatchProfile.profileID == this.ccBatchProfile.profileID) continue;
                vector.addElement(ccBatchProfile.profileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vector;
    }

    protected JTextField getProfileNameField() {
        return this.profileNameField;
    }

    protected JButton getCopyButton() {
        return this.copyButton;
    }

    protected JButton getNewButton() {
        return this.newButton;
    }

    protected JButton getDeleteButton() {
        return this.deleteButton;
    }

    protected JButton getAddImageTypeButton() {
        return this.addImageTypeButton;
    }

    protected JButton getRemoveImageTypeButton() {
        return this.removeImageTypeButton;
    }

    protected JTextField getUrlPrefixField() {
        return this.urlPrefixField;
    }

    protected JTextField getSidUrlPrefixField() {
        return this.sidUrlPrefixField;
    }

    protected JCheckBox getPreserveFilenamesCheckBox() {
        return this.preserveFilenamesCheckBox;
    }

    protected JCheckBox getPreserveDirectoriesCheckBox() {
        return this.preserveDirectoriesCheckBox;
    }

    protected JPanel getImageTypesPanel() {
        return this.imageTypesPanel;
    }
}

