/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.measurement;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.measurement.CsMeasurementToolSettings;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsMeasurementToolSettingsNode
extends TableDisplayControlPanelNode {
    protected CollectionNode collectionNode = null;

    public CsMeasurementToolSettingsNode(CollectionNode collectionNode) {
        super(collectionNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Measurement Tool", false);
        this.collectionNode = collectionNode;
        this.columnNames = new Object[]{"Width Field ID", "Width Qualifier Field ID", "Width Qualifier Value", "Width Metric Field ID", "Height Field ID", "Height Qualifier Field ID", "Height Qualifier Value", "Height Metric Field ID", "Metric", "Metric Name Map"};
    }

    public void updateInformationDisplay() {
        Integer n = this.collectionNode.getCollection().getUniqueCollectionID();
        this.tableModel.setDataVector(this.getTableData(this.collectionNode.getCollectionServerNode().getCollectionServer().getMeasurementToolSettings(n)), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CsMeasurementToolSettings csMeasurementToolSettings = (CsMeasurementToolSettings)vector.elementAt(i);
            objectArray[i][0] = csMeasurementToolSettings;
            objectArray[i][1] = csMeasurementToolSettings.widthQualifierFieldID + "";
            objectArray[i][2] = csMeasurementToolSettings.widthQualifierValue;
            objectArray[i][3] = csMeasurementToolSettings.widthMetricFieldID + "";
            objectArray[i][4] = csMeasurementToolSettings.heightFieldID + "";
            objectArray[i][5] = csMeasurementToolSettings.heightQualifierFieldID + "";
            objectArray[i][6] = csMeasurementToolSettings.heightQualifierValue;
            objectArray[i][7] = csMeasurementToolSettings.heightMetricFieldID + "";
            objectArray[i][8] = csMeasurementToolSettings.metric + "";
            objectArray[i][9] = csMeasurementToolSettings.metricNameMap;
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.collectionNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.collectionNode.getCollectionServerNode().getAdminAccount(), null, "Edit-measurement-tool-settings", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit-measurement-tool-settings") && vector != null && vector.size() == 1) {
            this.collectionNode.getCollectionServerNode().editMeasurementToolSettings((CsMeasurementToolSettings)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionNode.getCollectionServerNode().editMeasurementToolSettings((CsMeasurementToolSettings)object);
        }
    }

    public static void debugOut(String string) {
        CsMeasurementToolSettingsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsMeasurementToolSettingsNode: " + string, n);
    }
}

