/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.maxid;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.maxid.CsMaxIDs;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CsMaxIDsNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode collectionServerNode = null;

    public CsMaxIDsNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "Maximum IDs", false);
        this.collectionServerNode = collectionServerNode;
        this.columnNames = new Object[]{"Max Group ID", "Max Batch ID", "Max Media ID", "Max User ID", "Max Change ID", "Max Search Query ID", "Max LPS ID", "Max Entity ID"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getMaxIDs()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CsMaxIDs csMaxIDs = (CsMaxIDs)vector.elementAt(i);
            objectArray[i][0] = csMaxIDs;
            objectArray[i][1] = csMaxIDs.maxBatchID + "";
            objectArray[i][2] = csMaxIDs.maxMediaID + "";
            objectArray[i][3] = csMaxIDs.maxUserID + "";
            objectArray[i][4] = csMaxIDs.maxChangeID + "";
            objectArray[i][5] = csMaxIDs.maxSearchQueryID + "";
            objectArray[i][6] = csMaxIDs.maxLpsID + "";
            objectArray[i][7] = csMaxIDs.maxEntityID + "";
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        return null;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), null, "Edit-max-ids", null);
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("Edit-max-ids") && vector != null && vector.size() == 1) {
            this.collectionServerNode.editMaxIDs((CsMaxIDs)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionServerNode.editMaxIDs((CsMaxIDs)object);
        }
    }

    public static void debugOut(String string) {
        CsMaxIDsNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsMaxIDsNode: " + string, n);
    }
}

