/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.lps;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerTableNames;
import com.luna.insight.admin.collserver.lps.CcLpsData;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.Vector;

public class CcLpsDataRecordHandler
extends DatabaseRecordHandler
implements CollectionServerTableNames {
    public CcLpsDataRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcLpsDataRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CcLpsData ccLpsData = (CcLpsData)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "INSERT INTO IRLPS (LPSid, LPS) VALUES (" + ccLpsData.lpsID + ", " + this.prepForInsertQuery(ccLpsData.lpsName) + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertLpsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            CcLpsData ccLpsData = (CcLpsData)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            String string = "DELETE FROM IRLPS WHERE LPSid = " + ccLpsData.originalLpsID;
            databaseConnector.setQuery(string);
            this.debugOut("deleteLpsQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
    }

    public Vector getRecords() {
        this.debugOut("in getRecords()");
        Vector<CcLpsData> vector = new Vector<CcLpsData>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRLPS", null, "*");
            sqlQueryGenerator.addOrderBy("IRLPS", "LPSid");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("LPS query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CcLpsData ccLpsData = new CcLpsData((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("LPSid"), databaseConnector.getFieldByName("LPS"));
                    vector.addElement(ccLpsData);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        int n = ((CcLpsData)databaseRecord).originalLpsID;
        return this.getTheRecord(n);
    }

    public DatabaseRecord getUpdatedRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getUpdatedRecord()");
        int n = ((CcLpsData)databaseRecord).lpsID;
        return this.getTheRecord(n);
    }

    public DatabaseRecord getTheRecord(int n) {
        this.debugOut("in getTheRecord()");
        CcLpsData ccLpsData = null;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRLPS", null, "*");
            sqlQueryGenerator.appendToWhere("LPSid = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("LPS query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccLpsData = new CcLpsData((CollectionServer)this.serverConnector.getAdministeredServer(), databaseConnector.getIntegerFieldByName("LPSid"), databaseConnector.getFieldByName("LPS"));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getTheRecord(): " + exception);
        }
        return ccLpsData;
    }

    public String getNextValidIDQuery() {
        return "SELECT LPSid AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRLPS" + " ORDER BY LPSid";
    }

    public long getMaxID() {
        long l = 0L;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT MAX(LPSid) AS MaxID FROM IRLPS");
            this.debugOut("Get max ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("MaxID");
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxID(): " + InsightUtilities.getStackTrace(exception));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxIDValue(long l) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRMAXIDS", null, new String[]{"MaxLpsID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("MaxLpsID", 0);
            }
            databaseConnector.close();
            if (l > (long)n && n != 0) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxLpsID = " + l);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateMaxIDValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }
}

