/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.lps;

import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.collserver.CollectionServerNode;
import com.luna.insight.admin.collserver.lps.CcLpsData;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CcLpsDataNode
extends TableDisplayControlPanelNode {
    protected CollectionServerNode collectionServerNode = null;

    public CcLpsDataNode(CollectionServerNode collectionServerNode) {
        super(collectionServerNode.getCollectionServer().getInsightAdministrator(), "LPS Data", false);
        this.collectionServerNode = collectionServerNode;
        this.columnNames = new Object[]{"LPS ID", "LPS"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.collectionServerNode.getCollectionServer().getLpsData()), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        for (int i = 0; i < vector.size(); ++i) {
            CcLpsData ccLpsData = (CcLpsData)vector.elementAt(i);
            objectArray[i][0] = ccLpsData;
            objectArray[i][1] = ccLpsData.getName();
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServerNode.getAdminAccount().createPermittedServerMenuItem("New...", "New LPS Data Command", this.collectionServerNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.collectionServerNode.getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-lps-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return CollectionServerNode.createServerNodePopupMenu(actionListener, n, this.collectionServerNode.getAdminAccount(), "New LPS Data Command", "Edit LPS Data Command", "Delete LPS Data Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New LPS Data Command")) {
            this.collectionServerNode.createNewLpsData();
        } else if (string.equals("Delete LPS Data Command")) {
            if (vector != null && vector.size() > 0) {
                this.collectionServerNode.removeLpsData(vector);
            }
        } else if (string.equals("Edit LPS Data Command") && vector != null && vector.size() == 1) {
            this.collectionServerNode.editLpsData((CcLpsData)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.collectionServerNode.editLpsData((CcLpsData)object);
        }
    }

    public static void debugOut(String string) {
        CcLpsDataNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcLpsDataNode: " + string, n);
    }
}

