/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.lps;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.lps.CcLpsDataEditComponent;
import com.luna.insight.admin.verifier.CustomJTextComponentVerifier;
import com.luna.insight.admin.verifier.CustomVerificationChecker;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.util.Vector;
import javax.swing.ImageIcon;

public class CcLpsData
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    protected int lpsID;
    protected int originalLpsID;
    protected CollectionServer collectionServer;
    protected String lpsName = "";
    protected CcLpsDataEditComponent editComponent = null;

    public CcLpsData(CollectionServer collectionServer, int n, String string) {
        this.collectionServer = collectionServer;
        this.lpsID = n;
        this.originalLpsID = n;
        this.lpsName = string == null ? "" : string;
    }

    public CcLpsData(CollectionServer collectionServer, int n) {
        this.collectionServer = collectionServer;
        this.lpsID = n;
    }

    public String toString() {
        return "" + this.getIndex();
    }

    public String getName() {
        return this.lpsName;
    }

    public int getIndex() {
        return this.lpsID;
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcLpsDataEditComponent();
        this.editComponent.getLpsIDField().setText("" + this.lpsID);
        this.editComponent.getLpsField().setText(this.lpsName);
        this.editComponent.getLpsField().selectAll();
        this.editComponent.getLpsField().requestFocus();
        CustomVerificationChecker customVerificationChecker = new CustomVerificationChecker(){

            public boolean verify(String string) {
                Vector vector = CcLpsData.this.collectionServer.getLpsData();
                if (vector == null || vector.size() == 0) {
                    return true;
                }
                for (int i = 0; i < vector.size(); ++i) {
                    CcLpsData ccLpsData = (CcLpsData)vector.get(i);
                    if (ccLpsData.lpsID == CcLpsData.this.lpsID || !string.equals(ccLpsData.lpsID + "")) continue;
                    return false;
                }
                return true;
            }

            public String getFailedMessage() {
                return "The entered LPS ID is already taken.";
            }
        };
        this.editComponent.getLpsIDField().setInputVerifier(new CustomJTextComponentVerifier(customVerificationChecker, 1));
        return this.editComponent;
    }

    public void save() {
        CcLpsData.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (this.hasChanged(this.lpsName, this.editComponent.getLpsField().getText())) {
            this.lpsName = this.editComponent.getLpsField().getText();
        }
        if (this.hasChanged(this.lpsID + "", this.editComponent.getLpsIDField().getText())) {
            try {
                this.lpsID = Integer.parseInt(this.editComponent.getLpsIDField().getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public void cancel() {
        CcLpsData.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.collectionServer.cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit LPS Data";
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-user-groups-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.lpsID;
    }

    public String getOriginalUniqueIdentifier() {
        return "" + this.originalLpsID;
    }

    public boolean equals(Object object) {
        if (object instanceof CcLpsData) {
            CcLpsData ccLpsData = (CcLpsData)object;
            return this.lpsID == ccLpsData.lpsID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcLpsData) {
            CcLpsData ccLpsData = (CcLpsData)databaseRecord;
            return this.lpsID == ccLpsData.lpsID && CcLpsData.stringsAreEqual(this.lpsName, ccLpsData.lpsName);
        }
        return false;
    }

    public static void debugOut(String string) {
        CcLpsData.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcLpsData: " + string, n);
    }
}

