/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.join;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.join.CcJoinRecord;
import com.luna.insight.admin.collserver.join.CcJoinsEditComponent;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class CcJoinSubNode
extends ControlPanelNode
implements ActionListener {
    public static final String ADD_JOIN = "add-join";
    public static final String EDIT_JOIN = "edit-join";
    public static final String DELETE_JOIN = "delete-join";
    protected CollectionServer server;
    protected CcJoinRecord joinRecord;
    protected CcJoinsEditComponent joinsEditComponent;
    protected boolean isJoinTreeRoot;
    protected boolean subRoot;
    protected CcJoinSubNode subRootNode;

    public static void debugOut(String string) {
        CcJoinSubNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcJoinSubNode: " + string, n);
    }

    public CcJoinSubNode(CcJoinRecord ccJoinRecord, CcJoinsEditComponent ccJoinsEditComponent) {
        this(ccJoinRecord, ccJoinsEditComponent, false);
    }

    public CcJoinSubNode(CcJoinRecord ccJoinRecord, CcJoinsEditComponent ccJoinsEditComponent, boolean bl) {
        super(InsightAdministrator.getInsightAdministrator(), "", true);
        this.joinRecord = ccJoinRecord;
        this.joinsEditComponent = ccJoinsEditComponent;
        this.isJoinTreeRoot = bl;
        this.server = this.joinsEditComponent.getCollectionServer();
        this.subRoot = false;
        this.subRootNode = null;
        this.setNodeName();
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.server.getAdminAccount().createPermittedServerMenuItem("Add join", ADD_JOIN, this));
        if (this.isLeaf() && !this.isRoot()) {
            jPopupMenu.add(this.server.getAdminAccount().createPermittedServerMenuItem("Edit join", EDIT_JOIN, this));
            jPopupMenu.add(this.server.getAdminAccount().createPermittedServerMenuItem("Delete join", DELETE_JOIN, this));
        }
        return jPopupMenu;
    }

    public JComponent getDisplayComponent() {
        return null;
    }

    public boolean isSubRoot() {
        return this.subRoot;
    }

    public void setSubRoot(boolean bl) {
        this.subRoot = bl;
    }

    public CcJoinSubNode getSubRootNode() {
        return this.subRootNode;
    }

    public void setSubRootNode(CcJoinSubNode ccJoinSubNode) {
        this.subRootNode = ccJoinSubNode;
    }

    public CcJoinRecord getJoinRecord() {
        return this.joinRecord;
    }

    public void setNodeName() {
        this.setText(this.getName());
        this.setUserObject(this.getText());
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isJoinTreeRoot) {
            if (this.joinRecord.getJoinType() == 2) {
                stringBuffer.append("Record Joins");
            } else {
                stringBuffer.append(this.joinRecord.getStartTableName());
            }
        } else if (this.joinRecord.getJoinType() == 2) {
            stringBuffer.append(this.joinRecord.getEndTableName());
        } else {
            stringBuffer.append(this.joinRecord.getStartTableName());
            stringBuffer.append(" ( " + this.joinRecord.getStartFieldName() + " to " + this.joinRecord.getEndTableName() + "." + this.joinRecord.getEndFieldName() + " )");
        }
        return stringBuffer.toString();
    }

    public void expandNode() {
        this.joinsEditComponent.getJoinTree().expandPath(new TreePath(this.getPath()));
    }

    public void collapseNode() {
        this.joinsEditComponent.getJoinTree().collapsePath(new TreePath(this.getPath()));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CcJoinSubNode.debugOut("Received command: " + string);
        if (string.equals(ADD_JOIN)) {
            this.joinsEditComponent.prependJoin(this);
        } else if (string.equals(EDIT_JOIN)) {
            this.joinsEditComponent.editJoin(this);
        } else if (string.equals(DELETE_JOIN)) {
            this.joinsEditComponent.deleteJoin(this);
        }
    }
}

