/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.join;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.join.CcJoinManager;
import com.luna.insight.admin.collserver.join.CcJoinRecord;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.List;
import java.util.Vector;

public class CcJoinRecordHandler
extends DatabaseRecordHandler {
    public CcJoinRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcJoinRecordHandler";
    }

    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        try {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)databaseRecord;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGeneratorUtil();
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JoinID", 2, stringBuffer2, ccJoinRecord.getJoinID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StartTableID", 2, stringBuffer2, ccJoinRecord.getStartTableID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "StartFieldName", 1, stringBuffer2, ccJoinRecord.getStartFieldName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EndTableID", 2, stringBuffer2, ccJoinRecord.getEndTableID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "EndFieldName", 1, stringBuffer2, ccJoinRecord.getEndFieldName());
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "NextJoin", 2, stringBuffer2, ccJoinRecord.getNextJoinID() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "JoinType", 2, stringBuffer2, ccJoinRecord.getJoinType() + "");
            sqlQueryGenerator.appendFieldAndValue(stringBuffer, "UniqueCollectionID", 2, stringBuffer2, ccJoinRecord.getUniqueCollectionID());
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("INSERT INTO ISJOINS (" + stringBuffer.toString() + ")" + " VALUES (" + stringBuffer2.toString() + ")");
            this.debugOut("Insert join:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            ((CollectionServerConnector)this.serverConnector).fieldHandler.clearJoinNames(2);
            ((CollectionServerConnector)this.serverConnector).fieldHandler.clearJoinNames(1);
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + InsightUtilities.getStackTrace(exception));
        }
    }

    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        try {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)databaseRecord;
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("DELETE FROM ISJOINS WHERE JoinID = " + ccJoinRecord.getJoinID() + " AND UniqueCollectionID = " + ccJoinRecord.getUniqueCollectionID());
            this.debugOut("Delete join query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            ((CollectionServerConnector)this.serverConnector).fieldHandler.clearJoinNames(2);
            ((CollectionServerConnector)this.serverConnector).fieldHandler.clearJoinNames(1);
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + InsightUtilities.getStackTrace(exception));
        }
    }

    public Vector getRecords() {
        return null;
    }

    public Vector getRecords(Integer n) {
        return this.getRecords(n, -1);
    }

    public Vector getRecords(Integer n, int n2) {
        this.debugOut("in getRecords()");
        Vector<CcJoinRecord> vector = new Vector<CcJoinRecord>();
        try {
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISJOINS", null, "*");
            sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + n);
            if (n2 != -1) {
                sqlQueryGenerator.appendToWhere("ISJOINS.JoinType = " + n2);
            }
            sqlQueryGenerator.addOrderBy("ISJOINS", "JoinID");
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Fetch join records query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                vector.addElement(new CcJoinRecord(n, databaseConnector.getIntegerField("JoinID"), databaseConnector.getIntegerField("StartTableID"), databaseConnector.getField("StartFieldName"), databaseConnector.getIntegerField("EndTableID"), databaseConnector.getField("EndFieldName"), databaseConnector.getIntegerField("NextJoin"), databaseConnector.getIntegerField("JoinType")));
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + InsightUtilities.getStackTrace(exception));
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcJoinRecord ccJoinRecord = null;
        try {
            CcJoinRecord ccJoinRecord2 = (CcJoinRecord)databaseRecord;
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISJOINS", null, "*");
            sqlQueryGenerator.appendToWhere("UniqueCollectionID = " + ccJoinRecord2.getUniqueCollectionID());
            sqlQueryGenerator.appendToWhere("JoinID = " + ccJoinRecord2.getJoinID());
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Find join record query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccJoinRecord = new CcJoinRecord(ccJoinRecord2.getUniqueCollectionID(), databaseConnector.getIntegerField("JoinID"), databaseConnector.getIntegerField("StartTableID"), databaseConnector.getField("StartFieldName"), databaseConnector.getIntegerField("EndTableID"), databaseConnector.getField("EndFieldName"), databaseConnector.getIntegerField("NextJoin"), databaseConnector.getIntegerField("JoinType"));
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecord(): " + InsightUtilities.getStackTrace(exception));
        }
        return ccJoinRecord;
    }

    public String getNextValidIDQuery() {
        return "SELECT JoinID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "ISJOINS" + " ORDER BY JoinID";
    }

    public CcJoinManager getJoinManager(Collection collection, int n) {
        if (collection != null) {
            return new CcJoinManager(collection, this.getRecords(collection.getUniqueCollectionID(), n), ((CollectionServerConnector)this.serverConnector).getTableRecords(collection), n, this.getMaxJoinID());
        }
        return new CcJoinManager(this.getMaxJoinID());
    }

    public void saveJoins(CcJoinManager ccJoinManager) {
        this.debugOut("in saveJoins().");
        try {
            if (ccJoinManager != null) {
                DatabaseConnector databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("DELETE FROM ISJOINS WHERE JoinType=" + ccJoinManager.getJoinsType());
                this.debugOut("Delete joins:\n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
                List list = ccJoinManager.getJoins();
                for (int i = 0; i < list.size(); ++i) {
                    this.doInsert((CcJoinRecord)list.get(i));
                }
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in saveJoins(): " + InsightUtilities.getStackTrace(exception));
        }
    }

    protected int getMaxJoinID() {
        int n = 0;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT MAX(JoinID) AS MaxID FROM ISJOINS");
            this.debugOut("Get max Join ID query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                n = (int)databaseConnector.getLongField("MaxID");
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxJoinID(): " + InsightUtilities.getStackTrace(exception));
        }
        return n;
    }

    public void updateMaxIDValue(long l) {
    }
}

