/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.join;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.admin.collserver.join.CcJoinManager;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.admin.collserver.table.CcTableRecordHandler;
import com.luna.insight.server.Debug;
import java.util.Iterator;
import java.util.List;

public class CcJoinRecord
implements DatabaseRecord {
    protected int joinID;
    protected CcTableRecord startTable;
    protected int startTableID;
    protected String startFieldName;
    protected CcTableRecord endTable;
    protected int endTableID;
    protected String endFieldName;
    protected CcJoinRecord nextJoin = null;
    protected int nextJoinID;
    protected int joinType;
    protected Integer uniqueCollectionID = null;
    protected CcJoinRecord prevJoin = null;

    public static void debugOut(String string) {
        CcJoinRecord.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcJoinRecord: " + string, n);
    }

    public CcJoinRecord(Integer n, int n2, CcTableRecord ccTableRecord, String string, CcTableRecord ccTableRecord2, String string2, int n3) {
        this.joinID = n2;
        this.startFieldName = string;
        this.endFieldName = string2;
        this.setStartTable(ccTableRecord);
        this.setEndTable(ccTableRecord2);
        this.joinType = n3;
        this.uniqueCollectionID = n;
    }

    public CcJoinRecord(Integer n, int n2, int n3, String string, int n4, String string2, int n5, int n6) {
        this.joinID = n2;
        this.startTableID = n3;
        this.startFieldName = string;
        this.endTableID = n4;
        this.endFieldName = string2;
        this.nextJoinID = n5;
        this.joinType = n6;
        this.uniqueCollectionID = n;
    }

    public Integer getUniqueCollectionID() {
        return this.uniqueCollectionID;
    }

    public int getJoinID() {
        return this.joinID;
    }

    public CcTableRecord getStartTable() {
        return this.startTable;
    }

    public String getStartFieldName() {
        return this.startFieldName;
    }

    public CcTableRecord getEndTable() {
        return this.endTable;
    }

    public String getEndFieldName() {
        return this.endFieldName;
    }

    public int getNextJoinID() {
        return this.nextJoinID;
    }

    public CcJoinRecord getNextJoin() {
        return this.nextJoin;
    }

    public CcJoinRecord getPrevJoin() {
        return this.prevJoin;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public String getStartTableName() {
        if (this.startTable != null) {
            return this.startTable.getTableName();
        }
        return this.startTableID + "";
    }

    public String getEndTableName() {
        if (this.endTable != null) {
            return this.endTable.getTableName();
        }
        return this.endTableID + "";
    }

    public int getStartTableID() {
        if (this.startTable != null) {
            return this.startTable.getTableID();
        }
        return this.startTableID;
    }

    public int getEndTableID() {
        if (this.endTable != null) {
            return this.endTable.getTableID();
        }
        return this.endTableID;
    }

    public void setJoinID(int n) {
        this.joinID = n;
    }

    public void setStartFieldName(String string) {
        this.startFieldName = string;
    }

    public void setEndFieldName(String string) {
        this.endFieldName = string;
    }

    public void setStartTable(CcTableRecord ccTableRecord) {
        this.startTableID = 0;
        this.startTable = ccTableRecord;
        if (this.startTable != null) {
            this.startTableID = this.startTable.getTableID();
        }
    }

    public void setEndTable(CcTableRecord ccTableRecord) {
        this.endTableID = 0;
        this.endTable = ccTableRecord;
        if (this.endTable != null) {
            this.endTableID = this.endTable.getTableID();
        }
    }

    public void setNextJoin(List list) {
        this.setNextJoin(CcJoinManager.getJoin(list, this.getNextJoinID()));
    }

    public void setNextJoin(CcJoinRecord ccJoinRecord) {
        if (this.nextJoin != null && this.nextJoin.getPrevJoin() == this) {
            this.nextJoin.setPrevJoin(null);
        }
        this.nextJoinID = 0;
        this.nextJoin = ccJoinRecord;
        if (this.nextJoin == this) {
            this.nextJoin = null;
        }
        if (this.nextJoin != null) {
            this.nextJoinID = this.nextJoin.getJoinID();
            this.nextJoin.setPrevJoin(this);
        }
    }

    public void setPrevJoin(CcJoinRecord ccJoinRecord) {
        this.prevJoin = ccJoinRecord;
    }

    public void setTables(List list) {
        this.setStartTable(CcTableRecordHandler.getTable(list, this.getStartTableID()));
        this.setEndTable(CcTableRecordHandler.getTable(list, this.getEndTableID()));
    }

    public boolean linksToPrimaryObjectTable() {
        return this.startTableLinksToPrimaryObjectTable() || this.endTableLinksToPrimaryObjectTable();
    }

    public boolean startTableLinksToPrimaryObjectTable() {
        return this.startTable != null && this.startTable.isPrimaryObjectTable();
    }

    public boolean endTableLinksToPrimaryObjectTable() {
        return this.endTable != null && this.endTable.isPrimaryObjectTable();
    }

    public void swapTables() {
        if (!this.endTableLinksToPrimaryObjectTable() || this.getNextJoin() != null) {
            CcTableRecord ccTableRecord = this.startTable;
            String string = this.startFieldName;
            this.setStartTable(this.endTable);
            this.setStartFieldName(this.endFieldName);
            this.setEndTable(ccTableRecord);
            this.setEndFieldName(string);
        }
    }

    public String toString() {
        return this.getJoinID() + "";
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((this.getStartTable() == null ? "[" + this.getStartTableID() + "]" : this.getStartTable().getTableName()) + "." + this.getStartFieldName());
        stringBuffer.append(" to ");
        stringBuffer.append((this.getEndTable() == null ? "[" + this.getEndTableID() + "]" : this.getEndTable().getTableName()) + "." + this.getEndFieldName());
        return stringBuffer.toString();
    }

    public String getShortDisplayString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getStartTable() == null ? "[" + this.getStartTableID() + "]" : this.getStartTable().getTableName());
        stringBuffer.append(" => ");
        stringBuffer.append(this.getEndTable() == null ? "[" + this.getEndTableID() + "]" : this.getEndTable().getTableName());
        return stringBuffer.toString();
    }

    public String getShortDisplayStringFromFieldTableInfos(List list) {
        CollectionServerFieldTableInfo collectionServerFieldTableInfo;
        StringBuffer stringBuffer = new StringBuffer();
        CollectionServerFieldTableInfo collectionServerFieldTableInfo2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)iterator.next();
            if (collectionServerFieldTableInfo2.getTableId() != this.getStartTableID()) continue;
            collectionServerFieldTableInfo2 = collectionServerFieldTableInfo;
            break;
        }
        stringBuffer.append(collectionServerFieldTableInfo2 == null ? "[" + this.getStartTableID() + "]" : collectionServerFieldTableInfo2.getName());
        stringBuffer.append(" => ");
        collectionServerFieldTableInfo2 = null;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            collectionServerFieldTableInfo = (CollectionServerFieldTableInfo)iterator.next();
            if (collectionServerFieldTableInfo2.getTableId() != this.getEndTableID()) continue;
            collectionServerFieldTableInfo2 = collectionServerFieldTableInfo;
            break;
        }
        stringBuffer.append(collectionServerFieldTableInfo2 == null ? "[" + this.getEndTableID() + "]" : collectionServerFieldTableInfo2.getName());
        return stringBuffer.toString();
    }

    public int getIndex() {
        return this.joinID;
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcJoinRecord) {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)databaseRecord;
            return this.getJoinID() == ccJoinRecord.getJoinID();
        }
        return databaseRecord == this;
    }
}

