/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.join;

import com.luna.insight.admin.collserver.collection.Collection;
import com.luna.insight.admin.collserver.join.CcJoinRecord;
import com.luna.insight.admin.collserver.table.CcTableRecord;
import com.luna.insight.server.Debug;
import java.util.List;
import java.util.Vector;

public class CcJoinManager {
    protected static int maxJoinID = 0;
    protected List joins;
    protected List tables;
    protected int joinsType;
    protected CcTableRecord primaryObjectTable;
    protected boolean hasChanged = false;
    protected Object maxIDLockObj = new Object();
    protected Collection collection = null;

    public static CcJoinRecord getJoin(List list, int n) {
        for (int i = 0; list != null && i < list.size(); ++i) {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)list.get(i);
            if (ccJoinRecord.getJoinID() != n) continue;
            return ccJoinRecord;
        }
        return null;
    }

    public static void debugOut(String string) {
        CcJoinManager.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcJoinManager: " + string, n);
    }

    public CcJoinManager(Collection collection, List list, List list2, int n, int n2) {
        this.joins = list;
        this.tables = list2;
        this.joinsType = n;
        if (n2 > maxJoinID) {
            maxJoinID = n2;
        }
        this.collection = collection;
        this.initializeManager();
    }

    public CcJoinManager(int n) {
        if (n > maxJoinID) {
            maxJoinID = n;
        }
    }

    public Collection getCollection() {
        return this.collection;
    }

    public List getJoins() {
        return this.joins;
    }

    public List getTables() {
        return this.tables;
    }

    public int getJoinsType() {
        return this.joinsType;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void addJoin(CcJoinRecord ccJoinRecord) {
        if (!this.joins.contains(ccJoinRecord)) {
            this.joins.add(ccJoinRecord);
            this.hasChanged = true;
        }
    }

    public void removeJoin(CcJoinRecord ccJoinRecord) {
        if (ccJoinRecord != null) {
            ccJoinRecord.setNextJoin((CcJoinRecord)null);
            this.joins.remove(ccJoinRecord);
            this.setNextJoins();
            this.hasChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextJoinID() {
        Object object = this.maxIDLockObj;
        synchronized (object) {
            return ++maxJoinID;
        }
    }

    protected void initializeManager() {
        this.setNextJoins();
        this.setTables();
        this.getPrimaryObjectTable();
        this.verifyJoinPathsIntegrity();
    }

    protected void setNextJoins() {
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)this.joins.get(i);
            ccJoinRecord.setNextJoin(this.joins);
        }
    }

    protected void setTables() {
        for (int i = 0; this.joins != null && i < this.joins.size(); ++i) {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)this.joins.get(i);
            ccJoinRecord.setTables(this.tables);
        }
    }

    protected CcTableRecord getPrimaryObjectTable() {
        if (this.joinsType == 2) {
            return null;
        }
        if (this.primaryObjectTable == null) {
            int n = Integer.MAX_VALUE;
            for (int i = 0; i < this.tables.size(); ++i) {
                CcTableRecord ccTableRecord = (CcTableRecord)this.tables.get(i);
                if (ccTableRecord.isPrimaryObjectTable()) {
                    this.primaryObjectTable = ccTableRecord;
                    break;
                }
                if (ccTableRecord.getTableID() >= n) continue;
                n = ccTableRecord.getTableID();
                this.primaryObjectTable = ccTableRecord;
            }
            if (this.primaryObjectTable != null) {
                this.primaryObjectTable.setIsPrimaryObjectTable(true);
            }
        }
        return this.primaryObjectTable;
    }

    protected void verifyJoinPathsIntegrity() {
        if (this.joinsType == 2) {
            return;
        }
        List list = this.getJoinPaths();
        for (int i = 0; i < list.size(); ++i) {
            List list2 = (List)list.get(i);
            if (this.pathValid(list2)) continue;
            this.invertPath(list2);
        }
    }

    public List getJoinPaths() {
        Vector<CcJoinRecord> vector = new Vector<CcJoinRecord>();
        for (int i = 0; i < this.joins.size(); ++i) {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)this.joins.get(i);
            if (ccJoinRecord.getPrevJoin() != null || vector.contains(ccJoinRecord)) continue;
            vector.add(ccJoinRecord);
        }
        Vector<List> vector2 = new Vector<List>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(this.getJoinPath((CcJoinRecord)vector.get(i)));
        }
        if (this.joinsType == 2) {
            Vector<List> vector3 = new Vector<List>(vector2.size());
            block2: while (vector2.size() > 0) {
                for (int i = 0; i < vector2.size(); ++i) {
                    List list = (List)vector2.get(i);
                    if (list.size() > 0) {
                        CcTableRecord ccTableRecord = ((CcJoinRecord)list.get(0)).getStartTable();
                        boolean bl = false;
                        for (int j = i + 1; j < vector2.size(); ++j) {
                            List list2 = (List)vector2.get(j);
                            CcJoinRecord ccJoinRecord = this.findRecordWithEndEquals(list2, ccTableRecord);
                            if (ccJoinRecord == null) continue;
                            bl = true;
                            break;
                        }
                        if (bl) continue;
                    }
                    vector2.remove(i);
                    vector3.add(list);
                    continue block2;
                }
            }
            return vector3;
        }
        return vector2;
    }

    private CcJoinRecord findRecordWithEndEquals(List list, CcTableRecord ccTableRecord) {
        for (int i = 0; i < list.size(); ++i) {
            CcJoinRecord ccJoinRecord = (CcJoinRecord)list.get(i);
            CcTableRecord ccTableRecord2 = ccJoinRecord.getEndTable();
            if (ccTableRecord2 == null || !ccTableRecord2.equals(ccTableRecord)) continue;
            return ccJoinRecord;
        }
        return null;
    }

    protected List getJoinPath(CcJoinRecord ccJoinRecord) {
        Vector<CcJoinRecord> vector = new Vector<CcJoinRecord>();
        while (ccJoinRecord != null) {
            vector.add(ccJoinRecord);
            ccJoinRecord = ccJoinRecord.getNextJoin();
        }
        return vector;
    }

    protected boolean pathValid(List list) {
        CcJoinRecord ccJoinRecord;
        boolean bl = false;
        if (list.size() > 0 && (bl = (ccJoinRecord = (CcJoinRecord)list.get(list.size() - 1)).linksToPrimaryObjectTable())) {
            ccJoinRecord.swapTables();
        }
        return bl;
    }

    protected void invertPath(List list) {
        if (list != null) {
            CcJoinRecord ccJoinRecord = null;
            CcJoinRecord ccJoinRecord2 = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                ccJoinRecord = (CcJoinRecord)list.get(i);
                CcJoinRecord ccJoinRecord3 = ccJoinRecord2 = i > 0 ? (CcJoinRecord)list.get(i - 1) : null;
                if (i == list.size() - 1) {
                    ccJoinRecord.setPrevJoin(null);
                }
                ccJoinRecord.swapTables();
                ccJoinRecord.setNextJoin(ccJoinRecord2);
            }
        }
    }
}

