/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.NodeChildConstituent;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.inscribe.CcMedeProfileEditComponent;
import com.luna.insight.admin.collserver.profile.CollectionServerProfile;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import javax.swing.ImageIcon;

public class CcMedeProfile
extends CollectionServerProfile
implements DatabaseRecord,
NodeChildConstituent {
    private CcMedeProfileEditComponent editComponent = null;
    protected boolean entityRead = false;
    protected boolean entityEdit = false;
    protected boolean entityAdd = false;
    protected boolean entityDelete = false;
    protected boolean entityToEntityMapping = false;
    protected boolean entityToMediaMapping = false;
    protected boolean editVC = false;

    public CcMedeProfile(CollectionServer collectionServer, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, boolean bl3, boolean bl4, int n7, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string, boolean bl10, int n8, int n9, boolean bl11) {
        super(collectionServer, n, n2, bl, bl2, n3, n4, n5, n6, bl3, bl4, n7, bl5, bl6, bl7, bl8, bl9, string, bl10, n8, n9, bl11);
    }

    public EditComponent getEditComponent() {
        this.editComponent = new CcMedeProfileEditComponent();
        this.editComponent.getApprovalLevelField().setText(this.approvalLevel + "");
        this.editComponent.getReadCheckBox().setSelected(this.hasMedePermission(1));
        this.editComponent.getEditCheckBox().setSelected(this.hasMedePermission(3));
        this.editComponent.getAddCheckBox().setSelected(this.hasMedePermission(5));
        this.editComponent.getDeleteCheckBox().setSelected(this.hasMedePermission(9));
        this.editComponent.getEntityMappingCheckBox().setSelected(this.hasMedePermission(17));
        this.editComponent.getMediaMappingCheckBox().setSelected(this.hasMedePermission(33));
        return this.editComponent;
    }

    public void save() {
        CcMedeProfile.debugOut("Save...", 3);
        this.requiresCommit = false;
        this.entityRead = this.hasMedePermission(1);
        this.entityEdit = this.hasMedePermission(3);
        this.entityAdd = this.hasMedePermission(5);
        this.entityDelete = this.hasMedePermission(9);
        this.entityToEntityMapping = this.hasMedePermission(17);
        this.entityToMediaMapping = this.hasMedePermission(33);
        this.editVC = this.hasMedePermission(128);
        if (this.hasChanged(this.approvalLevel + "", this.editComponent.getApprovalLevelField().getText())) {
            this.approvalLevel = Integer.parseInt(this.editComponent.getApprovalLevelField().getText());
        }
        if (this.hasChanged(this.entityRead, this.editComponent.getReadCheckBox().isSelected())) {
            this.entityRead = this.editComponent.getReadCheckBox().isSelected();
        }
        if (this.hasChanged(this.entityEdit, this.editComponent.getEditCheckBox().isSelected())) {
            this.entityEdit = this.editComponent.getEditCheckBox().isSelected();
        }
        if (this.hasChanged(this.entityAdd, this.editComponent.getAddCheckBox().isSelected())) {
            this.entityAdd = this.editComponent.getAddCheckBox().isSelected();
        }
        if (this.hasChanged(this.entityDelete, this.editComponent.getDeleteCheckBox().isSelected())) {
            this.entityDelete = this.editComponent.getDeleteCheckBox().isSelected();
        }
        if (this.hasChanged(this.entityToEntityMapping, this.editComponent.getEntityMappingCheckBox().isSelected())) {
            this.entityToEntityMapping = this.editComponent.getEntityMappingCheckBox().isSelected();
        }
        if (this.hasChanged(this.entityToMediaMapping, this.editComponent.getMediaMappingCheckBox().isSelected())) {
            this.entityToMediaMapping = this.editComponent.getMediaMappingCheckBox().isSelected();
        }
        this.updatePermissions();
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.collectionServer.commitDataObject(this);
        } else {
            this.collectionServer.cancelEdit(this);
        }
    }

    public String getEditWindowTitle() {
        return "Editing Inscribe Privilege: " + this.getDisplayName();
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-profiles-node-icon.gif");
    }

    public void updatePermissions() {
        this.medePermissions = 0;
        if (this.entityRead) {
            this.medePermissions |= 1;
        }
        if (this.entityEdit) {
            this.medePermissions |= 3;
        }
        if (this.entityAdd) {
            this.medePermissions |= 5;
        }
        if (this.entityDelete) {
            this.medePermissions |= 9;
        }
        if (this.entityToEntityMapping) {
            this.medePermissions |= 0x11;
        }
        if (this.entityToMediaMapping) {
            this.medePermissions |= 0x21;
        }
        if (this.editVC) {
            this.medePermissions |= 0x80;
        }
    }

    public boolean hasMedePermission(int n) {
        return (this.medePermissions & n) == n;
    }

    public static void debugOut(String string) {
        CcMedeProfile.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeProfile: " + string, n);
    }
}

