/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.AdministeredServerNode;
import com.luna.insight.admin.TableDisplayControlPanelNode;
import com.luna.insight.admin.catalog.CatalogTemplateNode;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class CcMedeEntityTypesNode
extends TableDisplayControlPanelNode {
    protected CatalogTemplateNode catalogTemplateNode = null;

    public CcMedeEntityTypesNode(CatalogTemplateNode catalogTemplateNode) {
        super(catalogTemplateNode.getCollectionServerNode().getCollectionServer().getInsightAdministrator(), "Record Types", false);
        this.catalogTemplateNode = catalogTemplateNode;
        this.columnNames = new Object[]{"Name", "Display Name", "Table Name", "Column Name", "Restriction Level", "Is Vocabulary", "Is Dependent", "Enable Dupe Check", "Enable Ref Check", "Display Order", "Primary Insight Record Type"};
    }

    public void updateInformationDisplay() {
        this.tableModel.setDataVector(this.getTableData(this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getMedeEntityTypes(this.catalogTemplateNode.getTemplate().getTemplateID())), this.columnNames);
    }

    private Object[][] getTableData(Vector vector) {
        Object[][] objectArray = new Object[vector.size()][this.columnNames.length];
        Vector vector2 = this.catalogTemplateNode.getCollectionServerNode().getCollectionServer().getCollectionServerConnector().fieldHandler.getTableNames();
        for (int i = 0; i < vector.size(); ++i) {
            CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)vector.elementAt(i);
            objectArray[i][0] = ccMedeEntityType;
            objectArray[i][1] = ccMedeEntityType.displayName;
            objectArray[i][2] = "";
            for (int j = 0; j < vector2.size(); ++j) {
                int n = ((CollectionServerFieldTableInfo)vector2.elementAt(j)).getTableId();
                if (ccMedeEntityType.tableID != n) continue;
                objectArray[i][2] = ((CollectionServerFieldTableInfo)vector2.elementAt(j)).getName();
                break;
            }
            objectArray[i][3] = ccMedeEntityType.columnName;
            objectArray[i][4] = ccMedeEntityType.restrictionLevel + "";
            objectArray[i][5] = new Boolean(ccMedeEntityType.isVocabulary);
            objectArray[i][6] = new Boolean(ccMedeEntityType.isDependent);
            objectArray[i][7] = new Boolean(ccMedeEntityType.isDupeCheckEnabled);
            objectArray[i][8] = new Boolean(ccMedeEntityType.isRefCheckEnabled);
            objectArray[i][9] = ccMedeEntityType.displayOrder + "";
            objectArray[i][10] = new Boolean(ccMedeEntityType.isPreferredEntity);
        }
        return objectArray;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.catalogTemplateNode.getCollectionServerNode().getAdminAccount().createPermittedServerMenuItem("New...", "New Entity Type Command", this.catalogTemplateNode));
        return jPopupMenu;
    }

    public boolean hasReadPermission() {
        return this.catalogTemplateNode.getCollectionServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
        }
        return this.treeIcon;
    }

    public JPopupMenu getDisplayPopupMenu(ActionListener actionListener, int n) {
        return AdministeredServerNode.createServerNodePopupMenu(actionListener, n, this.catalogTemplateNode.getCollectionServerNode().getAdminAccount(), "New Entity Type Command", "Edit Entity Type Command", "Delete Entity Type Command");
    }

    public void actionPerformed(String string, Vector vector) {
        if (string.equals("New Entity Type Command")) {
            this.catalogTemplateNode.getCollectionServerNode().createNewMedeEntityType(this.catalogTemplateNode.getTemplate().getTemplateID());
        }
        if (string.equals("Delete Entity Type Command")) {
            if (vector != null && vector.size() > 0) {
                this.catalogTemplateNode.getCollectionServerNode().removeEntityTypes(vector);
            }
        } else if (string.equals("Edit Entity Type Command") && vector != null && vector.size() == 1) {
            this.catalogTemplateNode.getCollectionServerNode().editEntityType((CcMedeEntityType)vector.firstElement());
        }
    }

    public void defaultItemAction(Object object) {
        if (object != null) {
            this.catalogTemplateNode.getCollectionServerNode().editEntityType((CcMedeEntityType)object);
        }
    }

    public static void debugOut(String string) {
        CcMedeEntityTypesNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeEntityTypesNode: " + string, n);
    }
}

