/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.AdministeredServerConnector;
import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.DatabaseRecordHandler;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityType;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityTypeUnmappedFieldGroup;
import com.luna.insight.server.InsightUtilities;
import com.luna.insight.server.backend.DatabaseConnector;
import com.luna.insight.server.backend.SqlQueryGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CcMedeEntityTypeRecordHandler
extends DatabaseRecordHandler {
    public CcMedeEntityTypeRecordHandler(AdministeredServerConnector administeredServerConnector) {
        super(administeredServerConnector);
        this.COMPONENT_CODE = "CcMedeEntityTypeRecordHandler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInsert(DatabaseRecord databaseRecord) {
        this.debugOut("in doInsert()");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)databaseRecord;
            int n = ccMedeEntityType.entityTypeID;
            int n2 = ccMedeEntityType.displayOrder;
            CcMedeEntityTypeUnmappedFieldGroup ccMedeEntityTypeUnmappedFieldGroup = null;
            if (!ccMedeEntityType.isSaved) {
                if (ccMedeEntityType.selectedFieldGroup != null) {
                    n = ccMedeEntityType.selectedFieldGroup.getId();
                    n2 = ccMedeEntityType.selectedFieldGroup.getDisplayOrder();
                    ccMedeEntityType.entityTypeID = n;
                    ccMedeEntityType.displayOrder = n2;
                } else {
                    ccMedeEntityTypeUnmappedFieldGroup = new CcMedeEntityTypeUnmappedFieldGroup(ccMedeEntityType.displayName, ccMedeEntityType.entityTypeID, ccMedeEntityType.displayOrder);
                }
            }
            String string = "INSERT INTO ISENTITYTYPES (EntityTypeID, EntityTypeName, EntityTypeDisplayName, EntityTableID, EntityIDColumnName, RestrictionLevel, IsVocabulary, IsDependent, IsDupeCheckEnabled, IsRefCheckEnabled, EntityTypeDisplayOrder, IsPreferredEntity) VALUES (" + n + ", " + this.prepForInsertQuery(ccMedeEntityType.name) + ", " + this.prepForInsertQuery(ccMedeEntityType.displayName) + ", " + ccMedeEntityType.tableID + ", " + this.prepForInsertQuery(ccMedeEntityType.columnName) + ", " + ccMedeEntityType.restrictionLevel + ", " + (ccMedeEntityType.isVocabulary ? 1 : 0) + ", " + (ccMedeEntityType.isDependent ? 1 : 0) + ", " + (ccMedeEntityType.isDupeCheckEnabled ? 1 : 0) + ", " + (ccMedeEntityType.isRefCheckEnabled ? 1 : 0) + ", " + n2 + ", " + (ccMedeEntityType.isPreferredEntity ? 1 : 0) + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertEntityTypeQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            string = "INSERT INTO ISTEMPLATEENTITYTYPEMAP (TemplateID, EntityTypeID) VALUES (" + ccMedeEntityType.getTemplate().getTemplateID() + ", " + n + ")";
            databaseConnector.setQuery(string);
            this.debugOut("insertEntityTypeQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            if (ccMedeEntityTypeUnmappedFieldGroup != null) {
                string = "INSERT INTO IRFIELDGROUPS (FieldGroupID, DisplayName, FieldGroupType, DisplayOrder) VALUES (" + ccMedeEntityTypeUnmappedFieldGroup.getId() + ", " + this.prepForInsertQuery(ccMedeEntityTypeUnmappedFieldGroup.getName()) + ", 2, " + ccMedeEntityTypeUnmappedFieldGroup.getDisplayOrder() + ")";
                databaseConnector.setQuery(string);
                this.debugOut("insertEntityTypeQuery query: \n" + databaseConnector.getQuery(), 3);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in doInsert(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDelete(DatabaseRecord databaseRecord) {
        this.debugOut("in doDelete()");
        DatabaseConnector databaseConnector = this.getDatabaseConnector();
        try {
            CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)databaseRecord;
            if (!ccMedeEntityType.isSaveOnly()) {
                ((CollectionServerConnector)this.serverConnector).medeEntityRelationshipHandler.doDelete(ccMedeEntityType.entityTypeID);
                ((CollectionServerConnector)this.serverConnector).entityFieldHandler.doDelete(ccMedeEntityType.entityTypeID);
            }
            String string = "DELETE FROM ISENTITYTYPES WHERE EntityTypeID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteEntityTypeQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
            string = "DELETE FROM ISTEMPLATEENTITYTYPEMAP Where EntityTypeID = " + databaseRecord.getIndex();
            databaseConnector.setQuery(string);
            this.debugOut("deleteEntityTypeQuery query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runUpdateQuery();
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in doDelete(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }

    public Vector getRecords() {
        return null;
    }

    public Vector getRecords(Integer n) {
        this.debugOut("in getRecords()");
        Vector<CcMedeEntityType> vector = new Vector<CcMedeEntityType>();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYTYPES", null, "*");
            if (n != null) {
                sqlQueryGenerator.addJoin("ISENTITYTYPES", "ISTEMPLATEENTITYTYPEMAP", "EntityTypeID", 0);
                sqlQueryGenerator.appendToWhere("ISTEMPLATEENTITYTYPEMAP.TemplateID = " + n);
            }
            sqlQueryGenerator.addOrderBy("ISENTITYTYPES", "EntityTypeID");
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Record types query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                while (databaseConnector.more()) {
                    CcMedeEntityType ccMedeEntityType = new CcMedeEntityType(((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCatalogTemplateNode(n).getTemplate(), databaseConnector.getIntegerFieldByName("EntityTypeID"), databaseConnector.getFieldByName("EntityTypeName"), databaseConnector.getFieldByName("EntityTypeDisplayName"), databaseConnector.getIntegerField("EntityTableID", -1), databaseConnector.getFieldByName("EntityIDColumnName"), databaseConnector.getIntegerFieldByName("RestrictionLevel"), databaseConnector.getIntegerFieldByName("IsVocabulary") == 1, databaseConnector.getIntegerFieldByName("IsDependent") == 1, databaseConnector.getIntegerFieldByName("IsDupeCheckEnabled") == 1, databaseConnector.getIntegerFieldByName("IsRefCheckEnabled") == 1, databaseConnector.getIntegerFieldByName("EntityTypeDisplayOrder"), databaseConnector.getIntegerFieldByName("IsPreferredEntity") == 1);
                    vector.addElement(ccMedeEntityType);
                    databaseConnector.next();
                }
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return vector;
    }

    public DatabaseRecord getRecord(DatabaseRecord databaseRecord) {
        this.debugOut("in getRecord()");
        CcMedeEntityType ccMedeEntityType = null;
        int n = databaseRecord.getIndex();
        Integer n2 = ((CcMedeEntityType)databaseRecord).getTemplate().getTemplateID();
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("ISENTITYTYPES", null, "*");
            sqlQueryGenerator.appendToWhere("EntityTypeID = " + n);
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            this.debugOut("Record type query: \n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                ccMedeEntityType = new CcMedeEntityType(((CollectionServer)this.serverConnector.getAdministeredServer()).getServerNode().getCatalogTemplateNode(n2).getTemplate(), databaseConnector.getIntegerFieldByName("EntityTypeID"), databaseConnector.getFieldByName("EntityTypeName"), databaseConnector.getFieldByName("EntityTypeDisplayName"), databaseConnector.getIntegerField("EntityTableID", -1), databaseConnector.getFieldByName("EntityIDColumnName"), databaseConnector.getIntegerFieldByName("RestrictionLevel"), databaseConnector.getIntegerFieldByName("IsVocabulary") == 1, databaseConnector.getIntegerFieldByName("IsDependent") == 1, databaseConnector.getIntegerFieldByName("IsDupeCheckEnabled") == 1, databaseConnector.getIntegerFieldByName("IsRefCheckEnabled") == 1, databaseConnector.getIntegerFieldByName("EntityTypeDisplayOrder"), databaseConnector.getIntegerFieldByName("IsPreferredEntity") == 1);
                databaseConnector.next();
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getRecords(): " + exception);
        }
        return ccMedeEntityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnmappedFieldGroups() {
        DatabaseConnector databaseConnector = null;
        ArrayList<CcMedeEntityTypeUnmappedFieldGroup> arrayList = new ArrayList<CcMedeEntityTypeUnmappedFieldGroup>();
        try {
            databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT FieldGroupID, DisplayName, DisplayOrder FROM IRFIELDGROUPS WHERE FieldGroupID NOT IN (SELECT EntityTypeID FROM ISENTITYTYPES)");
            databaseConnector.runQuery();
            while (databaseConnector.more()) {
                CcMedeEntityTypeUnmappedFieldGroup ccMedeEntityTypeUnmappedFieldGroup = new CcMedeEntityTypeUnmappedFieldGroup(databaseConnector.getStringField("DisplayName"), databaseConnector.getIntegerField("FieldGroupID"), databaseConnector.getIntegerField("DisplayOrder"));
                arrayList.add(ccMedeEntityTypeUnmappedFieldGroup);
                databaseConnector.next();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in getUnmappedFieldGroups(): " + exception);
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
        return arrayList;
    }

    public String getNextValidIDQuery() {
        return "SELECT " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM (SELECT FieldGroupID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRFIELDGROUPS" + " UNION SELECT EntityTypeID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "ISENTITYTYPES" + " UNION SELECT FieldID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "IRFIELDS" + " UNION SELECT FieldID AS " + AdministeredServerConnector.CANDIDATE_INDEX_NAME + " FROM " + "ISENTITYFIELDS" + ") MaxUnion ORDER BY " + AdministeredServerConnector.CANDIDATE_INDEX_NAME;
    }

    public long getMaxDisplayOrder() {
        long l = 0L;
        try {
            DatabaseConnector databaseConnector = this.getDatabaseConnector();
            databaseConnector.setQuery("SELECT MAX(EntityTypeDisplayOrder) AS MaxID FROM ISENTITYTYPES");
            this.debugOut("Get max DisplayOrder query:\n" + databaseConnector.getQuery(), 3);
            databaseConnector.runQuery();
            if (databaseConnector.more()) {
                l = databaseConnector.getLongField("MaxID");
            }
            databaseConnector.close();
        }
        catch (Exception exception) {
            this.debugOut("Exception in getMaxDisplayOrder(): " + InsightUtilities.getStackTrace(exception));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMaxIDValue(long l) {
        DatabaseConnector databaseConnector = null;
        try {
            databaseConnector = this.getDatabaseConnector();
            SqlQueryGenerator sqlQueryGenerator = this.getQueryGenerator();
            sqlQueryGenerator.addTable("IRMAXIDS", null, new String[]{"MaxEntityTypeID"});
            databaseConnector.setQuery(sqlQueryGenerator.getQuery());
            databaseConnector.runQuery();
            int n = 0;
            if (databaseConnector.more()) {
                n = databaseConnector.getIntegerField("MaxEntityTypeID", 0);
            }
            databaseConnector.close();
            if (l > (long)n && n != 0) {
                databaseConnector = this.getDatabaseConnector();
                databaseConnector.setQuery("UPDATE IRMAXIDS SET MaxEntityTypeID = " + l);
                databaseConnector.runUpdateQuery();
                databaseConnector.close();
            }
        }
        catch (Exception exception) {
            this.debugOut("Exception in updateMaxIDValue():\n" + InsightUtilities.getStackTrace(exception));
        }
        finally {
            if (databaseConnector != null) {
                databaseConnector.close();
            }
        }
    }
}

