/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.inscribe;

import com.luna.insight.admin.DatabaseRecord;
import com.luna.insight.admin.EditComponent;
import com.luna.insight.admin.EditableDataObject;
import com.luna.insight.admin.IndexedObject;
import com.luna.insight.admin.catalog.CatalogTemplate;
import com.luna.insight.admin.collserver.CollectionServerConnector;
import com.luna.insight.admin.collserver.field.CollectionServerFieldTableInfo;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityTypeEditComponent;
import com.luna.insight.admin.collserver.inscribe.CcMedeEntityTypeUnmappedFieldGroup;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.Component;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;

public class CcMedeEntityType
extends EditableDataObject
implements IndexedObject,
DatabaseRecord {
    public static final String NO_SOURCE_TABLE = "(none)";
    protected int entityTypeID;
    protected int originalEntityTypeID;
    protected CatalogTemplate template;
    protected String name = "";
    protected String displayName = "";
    protected int tableID = -1;
    protected String columnName = "";
    protected int restrictionLevel = 0;
    protected boolean isVocabulary = false;
    protected boolean isDependent = false;
    protected boolean isDupeCheckEnabled = false;
    protected boolean isRefCheckEnabled = false;
    protected int displayOrder = 0;
    protected boolean isPreferredEntity = false;
    protected boolean saveOnly = false;
    protected boolean isSaved = true;
    protected List unmappedFieldGroups = null;
    protected CcMedeEntityTypeUnmappedFieldGroup selectedFieldGroup = null;
    protected CcMedeEntityTypeEditComponent editComponent = null;

    public CcMedeEntityType(CatalogTemplate catalogTemplate, int n, String string, String string2, int n2, String string3, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n4, boolean bl5) {
        this.template = catalogTemplate;
        this.entityTypeID = n;
        this.originalEntityTypeID = n;
        this.tableID = n2;
        this.restrictionLevel = n3;
        this.isVocabulary = bl;
        this.isDependent = bl2;
        this.isDupeCheckEnabled = bl3;
        this.isRefCheckEnabled = bl4;
        this.displayOrder = n4;
        this.isPreferredEntity = bl5;
        this.name = string == null ? "" : string;
        this.displayName = string2 == null ? "" : string2;
        this.columnName = string3 == null ? "" : string3;
    }

    public CcMedeEntityType(int n, CatalogTemplate catalogTemplate, List list) {
        this.entityTypeID = n;
        this.originalEntityTypeID = n;
        this.template = catalogTemplate;
        this.isSaved = false;
        this.unmappedFieldGroups = list;
    }

    public CatalogTemplate getTemplate() {
        return this.template;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.entityTypeID;
    }

    public EditComponent getEditComponent() {
        Serializable serializable;
        this.editComponent = new CcMedeEntityTypeEditComponent(this.isSaved);
        this.editComponent.getNameField().setText(this.name);
        this.editComponent.getDisplayNameField().setText(this.displayName);
        this.editComponent.getColumnNameField().setText(this.columnName);
        this.editComponent.getRestrictionLevelField().setText(this.restrictionLevel + "");
        this.editComponent.getIsVocabularyCheckBox().setSelected(this.isVocabulary);
        this.editComponent.getIsDependentCheckBox().setSelected(this.isDependent);
        this.editComponent.getIsDupeCheckEnabledCheckBox().setSelected(this.isDupeCheckEnabled);
        this.editComponent.getIsRefCheckEnabledCheckBox().setSelected(this.isRefCheckEnabled);
        if (!this.isSaved) {
            serializable = this.editComponent.getFieldGroupComboBox();
            Iterator iterator = this.unmappedFieldGroups.iterator();
            while (iterator.hasNext()) {
                ((JComboBox)serializable).addItem(iterator.next());
            }
            if (((JComboBox)serializable).getItemCount() > 0) {
                this.editComponent.setFieldGroupSelectionEnabled(true);
                ((JComboBox)serializable).setSelectedIndex(0);
            } else {
                this.editComponent.setFieldGroupSelectionEnabled(false);
            }
        }
        if (this.displayOrder == 0) {
            this.editComponent.getDisplayOrderField().setText(((CollectionServerConnector)this.template.getServer().getServerConnector()).getEntityTypeHandler().getMaxDisplayOrder() + 1L + "");
        } else {
            this.editComponent.getDisplayOrderField().setText(this.displayOrder + "");
        }
        serializable = this.template.getServer().getCollectionServerConnector().fieldHandler.getTableNames();
        for (int i = 0; i < ((Vector)serializable).size(); ++i) {
            int n = ((CollectionServerFieldTableInfo)((Vector)serializable).elementAt(i)).getTableId();
            String string = ((CollectionServerFieldTableInfo)((Vector)serializable).elementAt(i)).getName();
            String string2 = "" + n + " - " + string;
            this.editComponent.getTableComboBox().addItem(string2);
            if (this.tableID != n) continue;
            this.editComponent.getTableComboBox().setSelectedItem(string2);
        }
        this.editComponent.getNameField().selectAll();
        this.editComponent.getNameField().requestFocus();
        this.editComponent.getIsPreferredEntityCheckBox().setSelected(this.isPreferredEntity);
        return this.editComponent;
    }

    public void save() {
        Object object;
        CcMedeEntityType.debugOut("Save...", 3);
        this.requiresCommit = false;
        if (!this.isSaved && ((Component)(object = this.editComponent.getFieldGroupComboBox())).isEnabled()) {
            this.selectedFieldGroup = (CcMedeEntityTypeUnmappedFieldGroup)((JComboBox)object).getSelectedItem();
        }
        if (this.hasChanged(this.name, this.editComponent.getNameField().getText())) {
            this.name = this.editComponent.getNameField().getText();
        }
        if (this.hasChanged(this.displayName, this.editComponent.getDisplayNameField().getText())) {
            this.displayName = this.editComponent.getDisplayNameField().getText();
        }
        object = (String)this.editComponent.getTableComboBox().getSelectedItem();
        int n = this.tableID;
        try {
            n = Integer.parseInt(((String)object).substring(0, ((String)object).indexOf(32)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged("" + this.tableID, "" + n)) {
            this.tableID = n;
        }
        if (this.hasChanged(this.columnName, this.editComponent.getColumnNameField().getText())) {
            this.columnName = this.editComponent.getColumnNameField().getText();
        }
        try {
            if (this.hasChanged(this.restrictionLevel, Integer.parseInt(this.editComponent.getRestrictionLevelField().getText()))) {
                this.restrictionLevel = Integer.parseInt(this.editComponent.getRestrictionLevelField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.isVocabulary, this.editComponent.getIsVocabularyCheckBox().isSelected())) {
            this.isVocabulary = this.editComponent.getIsVocabularyCheckBox().isSelected();
        }
        if (this.hasChanged(this.isDependent, this.editComponent.getIsDependentCheckBox().isSelected())) {
            this.isDependent = this.editComponent.getIsDependentCheckBox().isSelected();
        }
        if (this.hasChanged(this.isDupeCheckEnabled, this.editComponent.getIsDupeCheckEnabledCheckBox().isSelected())) {
            this.isDupeCheckEnabled = this.editComponent.getIsDupeCheckEnabledCheckBox().isSelected();
        }
        if (this.hasChanged(this.isRefCheckEnabled, this.editComponent.getIsRefCheckEnabledCheckBox().isSelected())) {
            this.isRefCheckEnabled = this.editComponent.getIsRefCheckEnabledCheckBox().isSelected();
        }
        try {
            if (this.hasChanged(this.displayOrder, Integer.parseInt(this.editComponent.getDisplayOrderField().getText()))) {
                this.displayOrder = Integer.parseInt(this.editComponent.getDisplayOrderField().getText());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.hasChanged(this.isPreferredEntity, this.editComponent.getIsPreferredEntityCheckBox().isSelected())) {
            this.isPreferredEntity = this.editComponent.getIsPreferredEntityCheckBox().isSelected();
        }
        this.creationCompleted = true;
        if (this.requiresCommit) {
            this.saveOnly = true;
            this.template.getServer().commitDataObject(this);
            this.saveOnly = false;
        } else {
            this.template.getServer().cancelEdit(this);
        }
    }

    public void cancel() {
        CcMedeEntityType.debugOut("Cancel...", 3);
        this.editComponent = null;
        this.template.getServer().cancelEdit(this);
    }

    public String getEditWindowTitle() {
        return "Edit Record Type - " + this.displayName;
    }

    public ImageIcon getEditWindowIcon() {
        return IconMaker.createImage("images/collection-server-connection-pools-node-icon.gif");
    }

    public String getUniqueIdentifier() {
        return "" + this.getIndex();
    }

    public String getOriginalUniqueIdentifier() {
        return "" + this.originalEntityTypeID;
    }

    public boolean equals(Object object) {
        if (object instanceof CcMedeEntityType) {
            CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)object;
            return this.entityTypeID == ccMedeEntityType.entityTypeID;
        }
        return super.equals(object);
    }

    public boolean equalsRecord(DatabaseRecord databaseRecord) {
        if (databaseRecord instanceof CcMedeEntityType) {
            CcMedeEntityType ccMedeEntityType = (CcMedeEntityType)databaseRecord;
            return this.entityTypeID == ccMedeEntityType.entityTypeID && CcMedeEntityType.stringsAreEqual(this.name, ccMedeEntityType.name) && CcMedeEntityType.stringsAreEqual(this.displayName, ccMedeEntityType.displayName) && this.tableID == ccMedeEntityType.tableID && CcMedeEntityType.stringsAreEqual(this.columnName, ccMedeEntityType.columnName) && this.isVocabulary == ccMedeEntityType.isVocabulary && this.isDependent == ccMedeEntityType.isDependent && this.isDupeCheckEnabled == ccMedeEntityType.isDupeCheckEnabled && this.isRefCheckEnabled == ccMedeEntityType.isRefCheckEnabled && this.displayOrder == ccMedeEntityType.displayOrder && this.isPreferredEntity == ccMedeEntityType.isPreferredEntity && this.restrictionLevel == ccMedeEntityType.restrictionLevel;
        }
        return false;
    }

    public static void debugOut(String string) {
        CcMedeEntityType.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CcMedeEntityType: " + string, n);
    }

    public boolean isSaveOnly() {
        return this.saveOnly;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

