/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.indexer;

import com.luna.insight.admin.ControlPanelNode;
import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.collection.CollectionNode;
import com.luna.insight.admin.collserver.indexer.CsTasksInvokeIndexer;
import com.luna.insight.admin.collserver.indexer.CsTasksInvokeIndexerDisplay;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.client.IconMaker;
import com.luna.insight.server.Debug;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;

public class CsTasksInvokeIndexerNode
extends ControlPanelNode
implements ActionListener {
    protected InsightAdministrator insightAdministrator = null;
    protected CollectionNode collectionNode = null;
    protected CollectionServer collectionServer = null;
    protected CsTasksInvokeIndexerDisplay indexerDisplay = null;
    protected int nodeChildIndex = -1;
    protected String taskName = "";
    protected CcTaskItem taskItem;

    public static void debugOut(String string) {
        CsTasksInvokeIndexerNode.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsTasksInvokeIndexerNode: " + string, n);
    }

    public CsTasksInvokeIndexerNode(InsightAdministrator insightAdministrator, CollectionNode collectionNode, String string, int n, boolean bl) {
        super(insightAdministrator, string, bl);
        this.insightAdministrator = insightAdministrator;
        this.taskName = string;
        this.nodeChildIndex = n;
        this.collectionNode = collectionNode;
        this.collectionServer = collectionNode.getCollectionServerNode().getCollectionServer();
    }

    public JComponent getDisplayComponent() {
        return new JLabel();
    }

    public boolean isIndexerDisplayOpen() {
        return this.indexerDisplay != null && !this.indexerDisplay.isClosed();
    }

    public void launchIndexerSetup(CcTaskItem ccTaskItem) {
        boolean bl;
        this.taskItem = ccTaskItem;
        boolean bl2 = bl = this.collectionServer.isMedeEnabled() && this.collectionServer.getCollectionServerInscribeCompliant();
        if (this.indexerDisplay == null || this.indexerDisplay.isClosed()) {
            Vector vector = this.collectionServer.getMpdsToIndex(this.collectionNode.getCollection().getUniqueCollectionID());
            this.indexerDisplay = new CsTasksInvokeIndexerDisplay(this.insightAdministrator, vector, bl ? null : this.collectionServer.getFields(this.collectionNode.getCollection().getTemplateID()), bl);
            this.indexerDisplay.setTaskItem(ccTaskItem);
            this.indexerDisplay.setFrameIcon(this.getIcon());
            this.indexerDisplay.getStartButton().addActionListener(this);
            this.indexerDisplay.show();
        } else {
            InsightAdministrator.getInsightAdministrator().setSelectedFrame(this.indexerDisplay);
        }
    }

    public boolean hasReadPermission() {
        return this.collectionServer.getServerNode().getAdministeredServer().getAdminAccount().hasServerPermission(1);
    }

    public ImageIcon getIcon() {
        if (this.treeIcon == null) {
            this.treeIcon = IconMaker.createImage("images/collection-creation-indexer-icon.gif");
        }
        return this.treeIcon;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.indexerDisplay.getStartButton()) {
            boolean bl = false;
            String string = this.indexerDisplay.getDiacriticsFileTextField().getText();
            if (this.indexerDisplay.getUpdateThumbnailCachesCheckBox().isSelected() && (this.indexerDisplay.getServerPort().getText().equals("") || this.indexerDisplay.getServerHost().getText().equals(""))) {
                this.insightAdministrator.showWarningDialog("Host name and port number must be specified.", "Improper Host or Port");
                return;
            }
            this.doIndexing();
        }
    }

    public void doIndexing() {
        this.collectionServer.setGenerateDocumentFlag(this.indexerDisplay.getMultipageDocumentsList().getSelectedValues());
        int n = 0;
        if (!this.indexerDisplay.getServerPort().getText().equals("")) {
            n = Integer.parseInt(this.indexerDisplay.getServerPort().getText());
        }
        CsTasksInvokeIndexer csTasksInvokeIndexer = new CsTasksInvokeIndexer(this.collectionNode.getCollection().getUniqueCollectionID(), this.insightAdministrator, this, this.indexerDisplay.getSelectedFieldIDs(), this.indexerDisplay.getValueIndexingCheckBox().isSelected(), this.indexerDisplay.getTermIndexingCheckBox().isSelected(), this.indexerDisplay.getIncrementalIndexingCheckBox().isSelected(), this.indexerDisplay.getBulkLoadingCheckBox().isSelected(), this.indexerDisplay.getBulkFilePathname(), this.indexerDisplay.getBrowserIndexingCheckBox().isSelected(), this.indexerDisplay.getMaxChars(), this.indexerDisplay.getHierarchyIndexingCheckBox().isSelected(), this.indexerDisplay.getMultipageDocumentGenerationCheckBox().isSelected(), this.indexerDisplay.getFuzzyDateIndexingCheckBox().isSelected(), this.indexerDisplay.getUpdateThumbnailCachesCheckBox().isSelected(), this.indexerDisplay.getServerHost().getText(), n, this.indexerDisplay.getDiacriticsFile(), this.indexerDisplay.getAutomaticallyPostChangesCheckBox().isSelected(), this.indexerDisplay.getSaveTemporaryTablesCheckBox().isSelected(), this.collectionServer);
        csTasksInvokeIndexer.setTaskItem(this.taskItem);
        this.indexerDisplay.dispose();
        csTasksInvokeIndexer.start();
        CsTasksInvokeIndexerNode.debugOut("Completed indexer");
    }

    public String toString() {
        return this.taskName;
    }

    public JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.collectionServer.getServerNode().getAdminAccount().createMenuItem("Run", "Edit invoke-indexer", this.collectionNode));
        return jPopupMenu;
    }

    public void updateInformationDisplay() {
    }
}

