/*
 * Decompiled with CFR 0.152.
 */
package com.luna.insight.admin.collserver.indexer;

import com.luna.insight.admin.InsightAdministrator;
import com.luna.insight.admin.collserver.CollectionServer;
import com.luna.insight.admin.collserver.indexer.CsTasksIndexerDisplayDialog;
import com.luna.insight.admin.collserver.indexer.CsTasksInvokeIndexerNode;
import com.luna.insight.admin.collserver.task.CcTaskItem;
import com.luna.insight.server.Debug;
import com.luna.insight.server.indexer.TrinityIndexer;
import com.luna.insight.server.indexer.TrinityIndexerProgressListener;
import com.luna.insight.server.inscribe.EntityIndexer;
import java.io.File;
import java.util.List;

public class CsTasksInvokeIndexer
extends Thread {
    protected Integer uniqueCollectionID = null;
    protected List selectedFieldIDs;
    protected boolean valueIndexing = false;
    protected boolean termIndexing = false;
    protected boolean incrementalIndexing = false;
    protected boolean bulkIndexing = false;
    protected String bulkFilePathname = null;
    protected boolean browserIndexing = false;
    protected int maxChars;
    protected boolean hierarchyIndexing = false;
    protected boolean multipageDocumentIndexing = false;
    protected boolean fuzzyDateIndexing = false;
    protected boolean updateThumbnailCaches = false;
    protected File diacriticsFile = null;
    protected boolean automaticallyPostChanges = false;
    protected boolean saveTemporaryTables = false;
    protected CollectionServer collectionServer = null;
    protected InsightAdministrator insightAdministrator = null;
    protected CsTasksInvokeIndexerNode indexerNode = null;
    protected TrinityIndexerProgressListener progressListener = null;
    protected TrinityIndexer ti = null;
    protected EntityIndexer mei = null;
    protected String serverAddress = TrinityIndexer.DEFAULT_SERVER_ADDRESS;
    protected int serverPort = TrinityIndexer.DEFAULT_SERVER_PORT;
    protected CcTaskItem taskItem;

    public static void debugOut(String string) {
        CsTasksInvokeIndexer.debugOut(string, 2);
    }

    public static void debugOut(String string, int n) {
        Debug.debugOut("CsTasksInvokeIndexer: " + string, n);
    }

    public CsTasksInvokeIndexer(Integer n, InsightAdministrator insightAdministrator, CsTasksInvokeIndexerNode csTasksInvokeIndexerNode, List list, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, boolean bl5, int n2, boolean bl6, boolean bl7, boolean bl8, boolean bl9, String string2, int n3, File file, boolean bl10, boolean bl11, CollectionServer collectionServer) {
        this.uniqueCollectionID = n;
        this.insightAdministrator = insightAdministrator;
        this.indexerNode = csTasksInvokeIndexerNode;
        this.selectedFieldIDs = list;
        this.valueIndexing = bl;
        this.termIndexing = bl2;
        this.incrementalIndexing = bl3;
        this.bulkIndexing = bl4;
        this.bulkFilePathname = string;
        this.browserIndexing = bl5;
        this.maxChars = n2;
        this.hierarchyIndexing = bl6;
        this.multipageDocumentIndexing = bl7;
        this.fuzzyDateIndexing = bl8;
        this.updateThumbnailCaches = bl9;
        this.serverAddress = string2;
        this.serverPort = n3;
        this.diacriticsFile = file;
        this.automaticallyPostChanges = bl10;
        this.saveTemporaryTables = bl11;
        this.collectionServer = collectionServer;
    }

    public void setTaskItem(CcTaskItem ccTaskItem) {
        this.taskItem = ccTaskItem;
    }

    public void run() {
        TrinityIndexer trinityIndexer;
        CsTasksInvokeIndexer.debugOut("Starting the indexer as a separate thread");
        try {
            this.setPriority(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 100;
        int n2 = this.collectionServer.getQueryMode();
        String string = this.collectionServer.getGlobalEscapeDelimiter();
        String string2 = this.collectionServer.getUnicodeFieldPrefix();
        String string3 = TrinityIndexer.DEFAULT_DATE_FORMAT_STRING;
        int n3 = 3;
        boolean bl = this.valueIndexing;
        boolean bl2 = this.termIndexing;
        boolean bl3 = this.incrementalIndexing;
        EntityIndexer entityIndexer = null;
        if (this.collectionServer.isMedeEnabled() && this.collectionServer.getCollectionServerInscribeCompliant()) {
            CsTasksInvokeIndexer.debugOut("preparing Entity indexer with query mode: " + n2 + " GlobalEscapeDelimiter: " + string + " UnicodeFieldPrefix: " + string2);
            this.mei = entityIndexer = new EntityIndexer(this.uniqueCollectionID, this.valueIndexing, this.termIndexing, this.bulkIndexing, this.bulkFilePathname, n, n2, string, string2, string3, this.diacriticsFile, this.automaticallyPostChanges, this.saveTemporaryTables, n3, this.collectionServer.getConnectString(), this.collectionServer.getCollectionServerConnector().getDatabaseConnectorGenerator());
            bl = false;
            bl2 = false;
            bl3 = false;
        }
        CsTasksInvokeIndexer.debugOut("preparing Trinity indexer with query mode " + n2 + " GlobalEscapeDelimiter: " + string + " UnicodeFieldPrefix: " + string2);
        this.ti = trinityIndexer = new TrinityIndexer(this.uniqueCollectionID, this.selectedFieldIDs, bl, bl2, bl3, this.bulkIndexing, this.bulkFilePathname, this.browserIndexing, this.maxChars, this.hierarchyIndexing, this.multipageDocumentIndexing, this.fuzzyDateIndexing, this.updateThumbnailCaches, this.serverAddress, this.serverPort, n, n2, string, string2, string3, this.diacriticsFile, this.automaticallyPostChanges, this.saveTemporaryTables, entityIndexer == null || !this.saveTemporaryTables, n3, this.collectionServer.getConnectString(), this.collectionServer.getCollectionServerConnector().getDatabaseConnectorGenerator());
        this.progressListener = new CsTasksIndexerDisplayDialog(this.insightAdministrator.getFrame(), this.valueIndexing, this.termIndexing, this.incrementalIndexing, this.browserIndexing, this.maxChars, this.hierarchyIndexing, this.multipageDocumentIndexing, this.fuzzyDateIndexing, this.updateThumbnailCaches, trinityIndexer, entityIndexer);
        ((CsTasksIndexerDisplayDialog)this.progressListener).setTaskItem(this.taskItem);
        if (entityIndexer != null) {
            CsTasksInvokeIndexer.debugOut("invoking Entity indexer with query mode " + n2 + " GlobalEscapeDelimiter: " + string + " UnicodeFieldPrefix: " + string2);
            entityIndexer.setProgressListener(this.progressListener);
            entityIndexer.go();
        }
        CsTasksInvokeIndexer.debugOut("invoking Trinity indexer with query mode " + n2 + " GlobalEscapeDelimiter: " + string + " UnicodeFieldPrefix: " + string2);
        trinityIndexer.setProgressListener(this.progressListener);
        trinityIndexer.go();
        this.collectionServer.resetGenerateDocumentFlag();
        this.progressListener.stopRemainingTimeTimer();
        this.progressListener.stopTimer();
        CsTasksInvokeIndexer.debugOut("Indexing process is either successfully completed or successfully cancelled.");
    }

    public boolean getValueIndexing() {
        return this.valueIndexing;
    }

    public boolean getTermIndexing() {
        return this.termIndexing;
    }

    public boolean getIncrementalIndexing() {
        return this.incrementalIndexing;
    }

    public boolean getHierarchyIndexing() {
        return this.hierarchyIndexing;
    }

    public boolean getMultipageDocumentIndexing() {
        return this.multipageDocumentIndexing;
    }

    public boolean getFuzzyDateIndexing() {
        return this.fuzzyDateIndexing;
    }

    public boolean getUpdateThumbnailCaches() {
        return this.updateThumbnailCaches;
    }

    public boolean getAutomaticallyPostChanges() {
        return this.automaticallyPostChanges;
    }

    public boolean getSaveTemporaryTables() {
        return this.saveTemporaryTables;
    }
}

